// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/privacy/dlp/v2/dlp.proto

package dlppb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DlpService_InspectContent_FullMethodName             = "/google.privacy.dlp.v2.DlpService/InspectContent"
	DlpService_RedactImage_FullMethodName                = "/google.privacy.dlp.v2.DlpService/RedactImage"
	DlpService_DeidentifyContent_FullMethodName          = "/google.privacy.dlp.v2.DlpService/DeidentifyContent"
	DlpService_ReidentifyContent_FullMethodName          = "/google.privacy.dlp.v2.DlpService/ReidentifyContent"
	DlpService_ListInfoTypes_FullMethodName              = "/google.privacy.dlp.v2.DlpService/ListInfoTypes"
	DlpService_CreateInspectTemplate_FullMethodName      = "/google.privacy.dlp.v2.DlpService/CreateInspectTemplate"
	DlpService_UpdateInspectTemplate_FullMethodName      = "/google.privacy.dlp.v2.DlpService/UpdateInspectTemplate"
	DlpService_GetInspectTemplate_FullMethodName         = "/google.privacy.dlp.v2.DlpService/GetInspectTemplate"
	DlpService_ListInspectTemplates_FullMethodName       = "/google.privacy.dlp.v2.DlpService/ListInspectTemplates"
	DlpService_DeleteInspectTemplate_FullMethodName      = "/google.privacy.dlp.v2.DlpService/DeleteInspectTemplate"
	DlpService_CreateDeidentifyTemplate_FullMethodName   = "/google.privacy.dlp.v2.DlpService/CreateDeidentifyTemplate"
	DlpService_UpdateDeidentifyTemplate_FullMethodName   = "/google.privacy.dlp.v2.DlpService/UpdateDeidentifyTemplate"
	DlpService_GetDeidentifyTemplate_FullMethodName      = "/google.privacy.dlp.v2.DlpService/GetDeidentifyTemplate"
	DlpService_ListDeidentifyTemplates_FullMethodName    = "/google.privacy.dlp.v2.DlpService/ListDeidentifyTemplates"
	DlpService_DeleteDeidentifyTemplate_FullMethodName   = "/google.privacy.dlp.v2.DlpService/DeleteDeidentifyTemplate"
	DlpService_CreateJobTrigger_FullMethodName           = "/google.privacy.dlp.v2.DlpService/CreateJobTrigger"
	DlpService_UpdateJobTrigger_FullMethodName           = "/google.privacy.dlp.v2.DlpService/UpdateJobTrigger"
	DlpService_HybridInspectJobTrigger_FullMethodName    = "/google.privacy.dlp.v2.DlpService/HybridInspectJobTrigger"
	DlpService_GetJobTrigger_FullMethodName              = "/google.privacy.dlp.v2.DlpService/GetJobTrigger"
	DlpService_ListJobTriggers_FullMethodName            = "/google.privacy.dlp.v2.DlpService/ListJobTriggers"
	DlpService_DeleteJobTrigger_FullMethodName           = "/google.privacy.dlp.v2.DlpService/DeleteJobTrigger"
	DlpService_ActivateJobTrigger_FullMethodName         = "/google.privacy.dlp.v2.DlpService/ActivateJobTrigger"
	DlpService_CreateDiscoveryConfig_FullMethodName      = "/google.privacy.dlp.v2.DlpService/CreateDiscoveryConfig"
	DlpService_UpdateDiscoveryConfig_FullMethodName      = "/google.privacy.dlp.v2.DlpService/UpdateDiscoveryConfig"
	DlpService_GetDiscoveryConfig_FullMethodName         = "/google.privacy.dlp.v2.DlpService/GetDiscoveryConfig"
	DlpService_ListDiscoveryConfigs_FullMethodName       = "/google.privacy.dlp.v2.DlpService/ListDiscoveryConfigs"
	DlpService_DeleteDiscoveryConfig_FullMethodName      = "/google.privacy.dlp.v2.DlpService/DeleteDiscoveryConfig"
	DlpService_CreateDlpJob_FullMethodName               = "/google.privacy.dlp.v2.DlpService/CreateDlpJob"
	DlpService_ListDlpJobs_FullMethodName                = "/google.privacy.dlp.v2.DlpService/ListDlpJobs"
	DlpService_GetDlpJob_FullMethodName                  = "/google.privacy.dlp.v2.DlpService/GetDlpJob"
	DlpService_DeleteDlpJob_FullMethodName               = "/google.privacy.dlp.v2.DlpService/DeleteDlpJob"
	DlpService_CancelDlpJob_FullMethodName               = "/google.privacy.dlp.v2.DlpService/CancelDlpJob"
	DlpService_CreateStoredInfoType_FullMethodName       = "/google.privacy.dlp.v2.DlpService/CreateStoredInfoType"
	DlpService_UpdateStoredInfoType_FullMethodName       = "/google.privacy.dlp.v2.DlpService/UpdateStoredInfoType"
	DlpService_GetStoredInfoType_FullMethodName          = "/google.privacy.dlp.v2.DlpService/GetStoredInfoType"
	DlpService_ListStoredInfoTypes_FullMethodName        = "/google.privacy.dlp.v2.DlpService/ListStoredInfoTypes"
	DlpService_DeleteStoredInfoType_FullMethodName       = "/google.privacy.dlp.v2.DlpService/DeleteStoredInfoType"
	DlpService_ListProjectDataProfiles_FullMethodName    = "/google.privacy.dlp.v2.DlpService/ListProjectDataProfiles"
	DlpService_ListTableDataProfiles_FullMethodName      = "/google.privacy.dlp.v2.DlpService/ListTableDataProfiles"
	DlpService_ListColumnDataProfiles_FullMethodName     = "/google.privacy.dlp.v2.DlpService/ListColumnDataProfiles"
	DlpService_GetProjectDataProfile_FullMethodName      = "/google.privacy.dlp.v2.DlpService/GetProjectDataProfile"
	DlpService_ListFileStoreDataProfiles_FullMethodName  = "/google.privacy.dlp.v2.DlpService/ListFileStoreDataProfiles"
	DlpService_GetFileStoreDataProfile_FullMethodName    = "/google.privacy.dlp.v2.DlpService/GetFileStoreDataProfile"
	DlpService_DeleteFileStoreDataProfile_FullMethodName = "/google.privacy.dlp.v2.DlpService/DeleteFileStoreDataProfile"
	DlpService_GetTableDataProfile_FullMethodName        = "/google.privacy.dlp.v2.DlpService/GetTableDataProfile"
	DlpService_GetColumnDataProfile_FullMethodName       = "/google.privacy.dlp.v2.DlpService/GetColumnDataProfile"
	DlpService_DeleteTableDataProfile_FullMethodName     = "/google.privacy.dlp.v2.DlpService/DeleteTableDataProfile"
	DlpService_HybridInspectDlpJob_FullMethodName        = "/google.privacy.dlp.v2.DlpService/HybridInspectDlpJob"
	DlpService_FinishDlpJob_FullMethodName               = "/google.privacy.dlp.v2.DlpService/FinishDlpJob"
	DlpService_CreateConnection_FullMethodName           = "/google.privacy.dlp.v2.DlpService/CreateConnection"
	DlpService_GetConnection_FullMethodName              = "/google.privacy.dlp.v2.DlpService/GetConnection"
	DlpService_ListConnections_FullMethodName            = "/google.privacy.dlp.v2.DlpService/ListConnections"
	DlpService_SearchConnections_FullMethodName          = "/google.privacy.dlp.v2.DlpService/SearchConnections"
	DlpService_DeleteConnection_FullMethodName           = "/google.privacy.dlp.v2.DlpService/DeleteConnection"
	DlpService_UpdateConnection_FullMethodName           = "/google.privacy.dlp.v2.DlpService/UpdateConnection"
)

// DlpServiceClient is the client API for DlpService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DlpServiceClient interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// For how to guides, see
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
	InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/redacting-sensitive-data-images
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// Only the first frame of each multiframe image is redacted. Metadata and
	// other frames are omitted in the response.
	RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error)
	// Re-identifies content that has been de-identified.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
	// to learn more.
	ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error)
	// Returns a list of the sensitive information types that the DLP API
	// supports. See
	// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
	// to learn more.
	ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error)
	// Creates an InspectTemplate for reusing frequently used configuration
	// for inspecting content, images, and storage.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Updates the InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Gets an InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Lists InspectTemplates.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error)
	// Deletes an InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a DeidentifyTemplate for reusing frequently used configuration
	// for de-identifying content, images, and storage.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Updates the DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Gets a DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Lists DeidentifyTemplates.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error)
	// Deletes a DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a job trigger to run DLP actions such as scanning storage for
	// sensitive information on a set schedule.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Updates a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Inspect hybrid content and store findings to a trigger. The inspection
	// will be processed asynchronously. To review the findings monitor the
	// jobs within the trigger.
	HybridInspectJobTrigger(ctx context.Context, in *HybridInspectJobTriggerRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error)
	// Gets a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Lists job triggers.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Activate a job trigger. Causes the immediate execute of a trigger
	// instead of waiting on the trigger event to occur.
	ActivateJobTrigger(ctx context.Context, in *ActivateJobTriggerRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Creates a config for discovery to scan and profile storage.
	CreateDiscoveryConfig(ctx context.Context, in *CreateDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error)
	// Updates a discovery configuration.
	UpdateDiscoveryConfig(ctx context.Context, in *UpdateDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error)
	// Gets a discovery configuration.
	GetDiscoveryConfig(ctx context.Context, in *GetDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error)
	// Lists discovery configurations.
	ListDiscoveryConfigs(ctx context.Context, in *ListDiscoveryConfigsRequest, opts ...grpc.CallOption) (*ListDiscoveryConfigsResponse, error)
	// Deletes a discovery configuration.
	DeleteDiscoveryConfig(ctx context.Context, in *DeleteDiscoveryConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a new job to inspect storage or calculate risk metrics.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	CreateDlpJob(ctx context.Context, in *CreateDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Lists DlpJobs that match the specified filter in the request.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be canceled if
	// possible.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob. The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a pre-built stored infoType to be used for inspection.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	CreateStoredInfoType(ctx context.Context, in *CreateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Updates the stored infoType by creating a new version. The existing version
	// will continue to be used until the new version is ready.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	UpdateStoredInfoType(ctx context.Context, in *UpdateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Gets a stored infoType.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	GetStoredInfoType(ctx context.Context, in *GetStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Lists stored infoTypes.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	ListStoredInfoTypes(ctx context.Context, in *ListStoredInfoTypesRequest, opts ...grpc.CallOption) (*ListStoredInfoTypesResponse, error)
	// Deletes a stored infoType.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	DeleteStoredInfoType(ctx context.Context, in *DeleteStoredInfoTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists project data profiles for an organization.
	ListProjectDataProfiles(ctx context.Context, in *ListProjectDataProfilesRequest, opts ...grpc.CallOption) (*ListProjectDataProfilesResponse, error)
	// Lists table data profiles for an organization.
	ListTableDataProfiles(ctx context.Context, in *ListTableDataProfilesRequest, opts ...grpc.CallOption) (*ListTableDataProfilesResponse, error)
	// Lists column data profiles for an organization.
	ListColumnDataProfiles(ctx context.Context, in *ListColumnDataProfilesRequest, opts ...grpc.CallOption) (*ListColumnDataProfilesResponse, error)
	// Gets a project data profile.
	GetProjectDataProfile(ctx context.Context, in *GetProjectDataProfileRequest, opts ...grpc.CallOption) (*ProjectDataProfile, error)
	// Lists file store data profiles for an organization.
	ListFileStoreDataProfiles(ctx context.Context, in *ListFileStoreDataProfilesRequest, opts ...grpc.CallOption) (*ListFileStoreDataProfilesResponse, error)
	// Gets a file store data profile.
	GetFileStoreDataProfile(ctx context.Context, in *GetFileStoreDataProfileRequest, opts ...grpc.CallOption) (*FileStoreDataProfile, error)
	// Delete a FileStoreDataProfile. Will not prevent the profile from being
	// regenerated if the resource is still included in a discovery configuration.
	DeleteFileStoreDataProfile(ctx context.Context, in *DeleteFileStoreDataProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a table data profile.
	GetTableDataProfile(ctx context.Context, in *GetTableDataProfileRequest, opts ...grpc.CallOption) (*TableDataProfile, error)
	// Gets a column data profile.
	GetColumnDataProfile(ctx context.Context, in *GetColumnDataProfileRequest, opts ...grpc.CallOption) (*ColumnDataProfile, error)
	// Delete a TableDataProfile. Will not prevent the profile from being
	// regenerated if the table is still included in a discovery configuration.
	DeleteTableDataProfile(ctx context.Context, in *DeleteTableDataProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Inspect hybrid content and store findings to a job.
	// To review the findings, inspect the job. Inspection will occur
	// asynchronously.
	HybridInspectDlpJob(ctx context.Context, in *HybridInspectDlpJobRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error)
	// Finish a running hybrid DlpJob. Triggers the finalization steps and running
	// of any enabled actions that have not yet run.
	FinishDlpJob(ctx context.Context, in *FinishDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a Connection to an external data source.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Get a Connection by name.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Lists Connections in a parent. Use SearchConnections to see all connections
	// within an organization.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Searches for Connections in a parent.
	SearchConnections(ctx context.Context, in *SearchConnectionsRequest, opts ...grpc.CallOption) (*SearchConnectionsResponse, error)
	// Delete a Connection.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update a Connection.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
}

type dlpServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDlpServiceClient(cc grpc.ClientConnInterface) DlpServiceClient {
	return &dlpServiceClient{cc}
}

func (c *dlpServiceClient) InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error) {
	out := new(InspectContentResponse)
	err := c.cc.Invoke(ctx, DlpService_InspectContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error) {
	out := new(RedactImageResponse)
	err := c.cc.Invoke(ctx, DlpService_RedactImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error) {
	out := new(DeidentifyContentResponse)
	err := c.cc.Invoke(ctx, DlpService_DeidentifyContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error) {
	out := new(ReidentifyContentResponse)
	err := c.cc.Invoke(ctx, DlpService_ReidentifyContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error) {
	out := new(ListInfoTypesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListInfoTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, DlpService_CreateInspectTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, DlpService_UpdateInspectTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, DlpService_GetInspectTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error) {
	out := new(ListInspectTemplatesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListInspectTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteInspectTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, DlpService_CreateDeidentifyTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, DlpService_UpdateDeidentifyTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, DlpService_GetDeidentifyTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error) {
	out := new(ListDeidentifyTemplatesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListDeidentifyTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteDeidentifyTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, DlpService_CreateJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, DlpService_UpdateJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) HybridInspectJobTrigger(ctx context.Context, in *HybridInspectJobTriggerRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error) {
	out := new(HybridInspectResponse)
	err := c.cc.Invoke(ctx, DlpService_HybridInspectJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, DlpService_GetJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error) {
	out := new(ListJobTriggersResponse)
	err := c.cc.Invoke(ctx, DlpService_ListJobTriggers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ActivateJobTrigger(ctx context.Context, in *ActivateJobTriggerRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, DlpService_ActivateJobTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDiscoveryConfig(ctx context.Context, in *CreateDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error) {
	out := new(DiscoveryConfig)
	err := c.cc.Invoke(ctx, DlpService_CreateDiscoveryConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateDiscoveryConfig(ctx context.Context, in *UpdateDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error) {
	out := new(DiscoveryConfig)
	err := c.cc.Invoke(ctx, DlpService_UpdateDiscoveryConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDiscoveryConfig(ctx context.Context, in *GetDiscoveryConfigRequest, opts ...grpc.CallOption) (*DiscoveryConfig, error) {
	out := new(DiscoveryConfig)
	err := c.cc.Invoke(ctx, DlpService_GetDiscoveryConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDiscoveryConfigs(ctx context.Context, in *ListDiscoveryConfigsRequest, opts ...grpc.CallOption) (*ListDiscoveryConfigsResponse, error) {
	out := new(ListDiscoveryConfigsResponse)
	err := c.cc.Invoke(ctx, DlpService_ListDiscoveryConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDiscoveryConfig(ctx context.Context, in *DeleteDiscoveryConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteDiscoveryConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDlpJob(ctx context.Context, in *CreateDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, DlpService_CreateDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error) {
	out := new(ListDlpJobsResponse)
	err := c.cc.Invoke(ctx, DlpService_ListDlpJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, DlpService_GetDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_CancelDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateStoredInfoType(ctx context.Context, in *CreateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, DlpService_CreateStoredInfoType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateStoredInfoType(ctx context.Context, in *UpdateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, DlpService_UpdateStoredInfoType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetStoredInfoType(ctx context.Context, in *GetStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, DlpService_GetStoredInfoType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListStoredInfoTypes(ctx context.Context, in *ListStoredInfoTypesRequest, opts ...grpc.CallOption) (*ListStoredInfoTypesResponse, error) {
	out := new(ListStoredInfoTypesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListStoredInfoTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteStoredInfoType(ctx context.Context, in *DeleteStoredInfoTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteStoredInfoType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListProjectDataProfiles(ctx context.Context, in *ListProjectDataProfilesRequest, opts ...grpc.CallOption) (*ListProjectDataProfilesResponse, error) {
	out := new(ListProjectDataProfilesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListProjectDataProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListTableDataProfiles(ctx context.Context, in *ListTableDataProfilesRequest, opts ...grpc.CallOption) (*ListTableDataProfilesResponse, error) {
	out := new(ListTableDataProfilesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListTableDataProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListColumnDataProfiles(ctx context.Context, in *ListColumnDataProfilesRequest, opts ...grpc.CallOption) (*ListColumnDataProfilesResponse, error) {
	out := new(ListColumnDataProfilesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListColumnDataProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetProjectDataProfile(ctx context.Context, in *GetProjectDataProfileRequest, opts ...grpc.CallOption) (*ProjectDataProfile, error) {
	out := new(ProjectDataProfile)
	err := c.cc.Invoke(ctx, DlpService_GetProjectDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListFileStoreDataProfiles(ctx context.Context, in *ListFileStoreDataProfilesRequest, opts ...grpc.CallOption) (*ListFileStoreDataProfilesResponse, error) {
	out := new(ListFileStoreDataProfilesResponse)
	err := c.cc.Invoke(ctx, DlpService_ListFileStoreDataProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetFileStoreDataProfile(ctx context.Context, in *GetFileStoreDataProfileRequest, opts ...grpc.CallOption) (*FileStoreDataProfile, error) {
	out := new(FileStoreDataProfile)
	err := c.cc.Invoke(ctx, DlpService_GetFileStoreDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteFileStoreDataProfile(ctx context.Context, in *DeleteFileStoreDataProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteFileStoreDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetTableDataProfile(ctx context.Context, in *GetTableDataProfileRequest, opts ...grpc.CallOption) (*TableDataProfile, error) {
	out := new(TableDataProfile)
	err := c.cc.Invoke(ctx, DlpService_GetTableDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetColumnDataProfile(ctx context.Context, in *GetColumnDataProfileRequest, opts ...grpc.CallOption) (*ColumnDataProfile, error) {
	out := new(ColumnDataProfile)
	err := c.cc.Invoke(ctx, DlpService_GetColumnDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteTableDataProfile(ctx context.Context, in *DeleteTableDataProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteTableDataProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) HybridInspectDlpJob(ctx context.Context, in *HybridInspectDlpJobRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error) {
	out := new(HybridInspectResponse)
	err := c.cc.Invoke(ctx, DlpService_HybridInspectDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) FinishDlpJob(ctx context.Context, in *FinishDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_FinishDlpJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, DlpService_CreateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, DlpService_GetConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, DlpService_ListConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) SearchConnections(ctx context.Context, in *SearchConnectionsRequest, opts ...grpc.CallOption) (*SearchConnectionsResponse, error) {
	out := new(SearchConnectionsResponse)
	err := c.cc.Invoke(ctx, DlpService_SearchConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DlpService_DeleteConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, DlpService_UpdateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DlpServiceServer is the server API for DlpService service.
// All implementations should embed UnimplementedDlpServiceServer
// for forward compatibility
type DlpServiceServer interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// For how to guides, see
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
	InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/redacting-sensitive-data-images
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// Only the first frame of each multiframe image is redacted. Metadata and
	// other frames are omitted in the response.
	RedactImage(context.Context, *RedactImageRequest) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	DeidentifyContent(context.Context, *DeidentifyContentRequest) (*DeidentifyContentResponse, error)
	// Re-identifies content that has been de-identified.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
	// to learn more.
	ReidentifyContent(context.Context, *ReidentifyContentRequest) (*ReidentifyContentResponse, error)
	// Returns a list of the sensitive information types that the DLP API
	// supports. See
	// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
	// to learn more.
	ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error)
	// Creates an InspectTemplate for reusing frequently used configuration
	// for inspecting content, images, and storage.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	CreateInspectTemplate(context.Context, *CreateInspectTemplateRequest) (*InspectTemplate, error)
	// Updates the InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	UpdateInspectTemplate(context.Context, *UpdateInspectTemplateRequest) (*InspectTemplate, error)
	// Gets an InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	GetInspectTemplate(context.Context, *GetInspectTemplateRequest) (*InspectTemplate, error)
	// Lists InspectTemplates.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	ListInspectTemplates(context.Context, *ListInspectTemplatesRequest) (*ListInspectTemplatesResponse, error)
	// Deletes an InspectTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
	// to learn more.
	DeleteInspectTemplate(context.Context, *DeleteInspectTemplateRequest) (*emptypb.Empty, error)
	// Creates a DeidentifyTemplate for reusing frequently used configuration
	// for de-identifying content, images, and storage.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	CreateDeidentifyTemplate(context.Context, *CreateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Updates the DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	UpdateDeidentifyTemplate(context.Context, *UpdateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Gets a DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	GetDeidentifyTemplate(context.Context, *GetDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Lists DeidentifyTemplates.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	ListDeidentifyTemplates(context.Context, *ListDeidentifyTemplatesRequest) (*ListDeidentifyTemplatesResponse, error)
	// Deletes a DeidentifyTemplate.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
	// to learn more.
	DeleteDeidentifyTemplate(context.Context, *DeleteDeidentifyTemplateRequest) (*emptypb.Empty, error)
	// Creates a job trigger to run DLP actions such as scanning storage for
	// sensitive information on a set schedule.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	CreateJobTrigger(context.Context, *CreateJobTriggerRequest) (*JobTrigger, error)
	// Updates a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	UpdateJobTrigger(context.Context, *UpdateJobTriggerRequest) (*JobTrigger, error)
	// Inspect hybrid content and store findings to a trigger. The inspection
	// will be processed asynchronously. To review the findings monitor the
	// jobs within the trigger.
	HybridInspectJobTrigger(context.Context, *HybridInspectJobTriggerRequest) (*HybridInspectResponse, error)
	// Gets a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	GetJobTrigger(context.Context, *GetJobTriggerRequest) (*JobTrigger, error)
	// Lists job triggers.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	ListJobTriggers(context.Context, *ListJobTriggersRequest) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
	// to learn more.
	DeleteJobTrigger(context.Context, *DeleteJobTriggerRequest) (*emptypb.Empty, error)
	// Activate a job trigger. Causes the immediate execute of a trigger
	// instead of waiting on the trigger event to occur.
	ActivateJobTrigger(context.Context, *ActivateJobTriggerRequest) (*DlpJob, error)
	// Creates a config for discovery to scan and profile storage.
	CreateDiscoveryConfig(context.Context, *CreateDiscoveryConfigRequest) (*DiscoveryConfig, error)
	// Updates a discovery configuration.
	UpdateDiscoveryConfig(context.Context, *UpdateDiscoveryConfigRequest) (*DiscoveryConfig, error)
	// Gets a discovery configuration.
	GetDiscoveryConfig(context.Context, *GetDiscoveryConfigRequest) (*DiscoveryConfig, error)
	// Lists discovery configurations.
	ListDiscoveryConfigs(context.Context, *ListDiscoveryConfigsRequest) (*ListDiscoveryConfigsResponse, error)
	// Deletes a discovery configuration.
	DeleteDiscoveryConfig(context.Context, *DeleteDiscoveryConfigRequest) (*emptypb.Empty, error)
	// Creates a new job to inspect storage or calculate risk metrics.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	CreateDlpJob(context.Context, *CreateDlpJobRequest) (*DlpJob, error)
	// Lists DlpJobs that match the specified filter in the request.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	ListDlpJobs(context.Context, *ListDlpJobsRequest) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	GetDlpJob(context.Context, *GetDlpJobRequest) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be canceled if
	// possible.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	DeleteDlpJob(context.Context, *DeleteDlpJobRequest) (*emptypb.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob. The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
	// and
	// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
	// to learn more.
	CancelDlpJob(context.Context, *CancelDlpJobRequest) (*emptypb.Empty, error)
	// Creates a pre-built stored infoType to be used for inspection.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	CreateStoredInfoType(context.Context, *CreateStoredInfoTypeRequest) (*StoredInfoType, error)
	// Updates the stored infoType by creating a new version. The existing version
	// will continue to be used until the new version is ready.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	UpdateStoredInfoType(context.Context, *UpdateStoredInfoTypeRequest) (*StoredInfoType, error)
	// Gets a stored infoType.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	GetStoredInfoType(context.Context, *GetStoredInfoTypeRequest) (*StoredInfoType, error)
	// Lists stored infoTypes.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	ListStoredInfoTypes(context.Context, *ListStoredInfoTypesRequest) (*ListStoredInfoTypesResponse, error)
	// Deletes a stored infoType.
	// See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
	// to learn more.
	DeleteStoredInfoType(context.Context, *DeleteStoredInfoTypeRequest) (*emptypb.Empty, error)
	// Lists project data profiles for an organization.
	ListProjectDataProfiles(context.Context, *ListProjectDataProfilesRequest) (*ListProjectDataProfilesResponse, error)
	// Lists table data profiles for an organization.
	ListTableDataProfiles(context.Context, *ListTableDataProfilesRequest) (*ListTableDataProfilesResponse, error)
	// Lists column data profiles for an organization.
	ListColumnDataProfiles(context.Context, *ListColumnDataProfilesRequest) (*ListColumnDataProfilesResponse, error)
	// Gets a project data profile.
	GetProjectDataProfile(context.Context, *GetProjectDataProfileRequest) (*ProjectDataProfile, error)
	// Lists file store data profiles for an organization.
	ListFileStoreDataProfiles(context.Context, *ListFileStoreDataProfilesRequest) (*ListFileStoreDataProfilesResponse, error)
	// Gets a file store data profile.
	GetFileStoreDataProfile(context.Context, *GetFileStoreDataProfileRequest) (*FileStoreDataProfile, error)
	// Delete a FileStoreDataProfile. Will not prevent the profile from being
	// regenerated if the resource is still included in a discovery configuration.
	DeleteFileStoreDataProfile(context.Context, *DeleteFileStoreDataProfileRequest) (*emptypb.Empty, error)
	// Gets a table data profile.
	GetTableDataProfile(context.Context, *GetTableDataProfileRequest) (*TableDataProfile, error)
	// Gets a column data profile.
	GetColumnDataProfile(context.Context, *GetColumnDataProfileRequest) (*ColumnDataProfile, error)
	// Delete a TableDataProfile. Will not prevent the profile from being
	// regenerated if the table is still included in a discovery configuration.
	DeleteTableDataProfile(context.Context, *DeleteTableDataProfileRequest) (*emptypb.Empty, error)
	// Inspect hybrid content and store findings to a job.
	// To review the findings, inspect the job. Inspection will occur
	// asynchronously.
	HybridInspectDlpJob(context.Context, *HybridInspectDlpJobRequest) (*HybridInspectResponse, error)
	// Finish a running hybrid DlpJob. Triggers the finalization steps and running
	// of any enabled actions that have not yet run.
	FinishDlpJob(context.Context, *FinishDlpJobRequest) (*emptypb.Empty, error)
	// Create a Connection to an external data source.
	CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error)
	// Get a Connection by name.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Lists Connections in a parent. Use SearchConnections to see all connections
	// within an organization.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Searches for Connections in a parent.
	SearchConnections(context.Context, *SearchConnectionsRequest) (*SearchConnectionsResponse, error)
	// Delete a Connection.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*emptypb.Empty, error)
	// Update a Connection.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error)
}

// UnimplementedDlpServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDlpServiceServer struct {
}

func (UnimplementedDlpServiceServer) InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InspectContent not implemented")
}
func (UnimplementedDlpServiceServer) RedactImage(context.Context, *RedactImageRequest) (*RedactImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RedactImage not implemented")
}
func (UnimplementedDlpServiceServer) DeidentifyContent(context.Context, *DeidentifyContentRequest) (*DeidentifyContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeidentifyContent not implemented")
}
func (UnimplementedDlpServiceServer) ReidentifyContent(context.Context, *ReidentifyContentRequest) (*ReidentifyContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReidentifyContent not implemented")
}
func (UnimplementedDlpServiceServer) ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInfoTypes not implemented")
}
func (UnimplementedDlpServiceServer) CreateInspectTemplate(context.Context, *CreateInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInspectTemplate not implemented")
}
func (UnimplementedDlpServiceServer) UpdateInspectTemplate(context.Context, *UpdateInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInspectTemplate not implemented")
}
func (UnimplementedDlpServiceServer) GetInspectTemplate(context.Context, *GetInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInspectTemplate not implemented")
}
func (UnimplementedDlpServiceServer) ListInspectTemplates(context.Context, *ListInspectTemplatesRequest) (*ListInspectTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInspectTemplates not implemented")
}
func (UnimplementedDlpServiceServer) DeleteInspectTemplate(context.Context, *DeleteInspectTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInspectTemplate not implemented")
}
func (UnimplementedDlpServiceServer) CreateDeidentifyTemplate(context.Context, *CreateDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeidentifyTemplate not implemented")
}
func (UnimplementedDlpServiceServer) UpdateDeidentifyTemplate(context.Context, *UpdateDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeidentifyTemplate not implemented")
}
func (UnimplementedDlpServiceServer) GetDeidentifyTemplate(context.Context, *GetDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeidentifyTemplate not implemented")
}
func (UnimplementedDlpServiceServer) ListDeidentifyTemplates(context.Context, *ListDeidentifyTemplatesRequest) (*ListDeidentifyTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeidentifyTemplates not implemented")
}
func (UnimplementedDlpServiceServer) DeleteDeidentifyTemplate(context.Context, *DeleteDeidentifyTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeidentifyTemplate not implemented")
}
func (UnimplementedDlpServiceServer) CreateJobTrigger(context.Context, *CreateJobTriggerRequest) (*JobTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) UpdateJobTrigger(context.Context, *UpdateJobTriggerRequest) (*JobTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) HybridInspectJobTrigger(context.Context, *HybridInspectJobTriggerRequest) (*HybridInspectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HybridInspectJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) GetJobTrigger(context.Context, *GetJobTriggerRequest) (*JobTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) ListJobTriggers(context.Context, *ListJobTriggersRequest) (*ListJobTriggersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobTriggers not implemented")
}
func (UnimplementedDlpServiceServer) DeleteJobTrigger(context.Context, *DeleteJobTriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) ActivateJobTrigger(context.Context, *ActivateJobTriggerRequest) (*DlpJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateJobTrigger not implemented")
}
func (UnimplementedDlpServiceServer) CreateDiscoveryConfig(context.Context, *CreateDiscoveryConfigRequest) (*DiscoveryConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDiscoveryConfig not implemented")
}
func (UnimplementedDlpServiceServer) UpdateDiscoveryConfig(context.Context, *UpdateDiscoveryConfigRequest) (*DiscoveryConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDiscoveryConfig not implemented")
}
func (UnimplementedDlpServiceServer) GetDiscoveryConfig(context.Context, *GetDiscoveryConfigRequest) (*DiscoveryConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDiscoveryConfig not implemented")
}
func (UnimplementedDlpServiceServer) ListDiscoveryConfigs(context.Context, *ListDiscoveryConfigsRequest) (*ListDiscoveryConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDiscoveryConfigs not implemented")
}
func (UnimplementedDlpServiceServer) DeleteDiscoveryConfig(context.Context, *DeleteDiscoveryConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDiscoveryConfig not implemented")
}
func (UnimplementedDlpServiceServer) CreateDlpJob(context.Context, *CreateDlpJobRequest) (*DlpJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) ListDlpJobs(context.Context, *ListDlpJobsRequest) (*ListDlpJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDlpJobs not implemented")
}
func (UnimplementedDlpServiceServer) GetDlpJob(context.Context, *GetDlpJobRequest) (*DlpJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) DeleteDlpJob(context.Context, *DeleteDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) CancelDlpJob(context.Context, *CancelDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) CreateStoredInfoType(context.Context, *CreateStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateStoredInfoType not implemented")
}
func (UnimplementedDlpServiceServer) UpdateStoredInfoType(context.Context, *UpdateStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateStoredInfoType not implemented")
}
func (UnimplementedDlpServiceServer) GetStoredInfoType(context.Context, *GetStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStoredInfoType not implemented")
}
func (UnimplementedDlpServiceServer) ListStoredInfoTypes(context.Context, *ListStoredInfoTypesRequest) (*ListStoredInfoTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStoredInfoTypes not implemented")
}
func (UnimplementedDlpServiceServer) DeleteStoredInfoType(context.Context, *DeleteStoredInfoTypeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteStoredInfoType not implemented")
}
func (UnimplementedDlpServiceServer) ListProjectDataProfiles(context.Context, *ListProjectDataProfilesRequest) (*ListProjectDataProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjectDataProfiles not implemented")
}
func (UnimplementedDlpServiceServer) ListTableDataProfiles(context.Context, *ListTableDataProfilesRequest) (*ListTableDataProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTableDataProfiles not implemented")
}
func (UnimplementedDlpServiceServer) ListColumnDataProfiles(context.Context, *ListColumnDataProfilesRequest) (*ListColumnDataProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListColumnDataProfiles not implemented")
}
func (UnimplementedDlpServiceServer) GetProjectDataProfile(context.Context, *GetProjectDataProfileRequest) (*ProjectDataProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) ListFileStoreDataProfiles(context.Context, *ListFileStoreDataProfilesRequest) (*ListFileStoreDataProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFileStoreDataProfiles not implemented")
}
func (UnimplementedDlpServiceServer) GetFileStoreDataProfile(context.Context, *GetFileStoreDataProfileRequest) (*FileStoreDataProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFileStoreDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) DeleteFileStoreDataProfile(context.Context, *DeleteFileStoreDataProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFileStoreDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) GetTableDataProfile(context.Context, *GetTableDataProfileRequest) (*TableDataProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTableDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) GetColumnDataProfile(context.Context, *GetColumnDataProfileRequest) (*ColumnDataProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetColumnDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) DeleteTableDataProfile(context.Context, *DeleteTableDataProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTableDataProfile not implemented")
}
func (UnimplementedDlpServiceServer) HybridInspectDlpJob(context.Context, *HybridInspectDlpJobRequest) (*HybridInspectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HybridInspectDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) FinishDlpJob(context.Context, *FinishDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinishDlpJob not implemented")
}
func (UnimplementedDlpServiceServer) CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (UnimplementedDlpServiceServer) GetConnection(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (UnimplementedDlpServiceServer) ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (UnimplementedDlpServiceServer) SearchConnections(context.Context, *SearchConnectionsRequest) (*SearchConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchConnections not implemented")
}
func (UnimplementedDlpServiceServer) DeleteConnection(context.Context, *DeleteConnectionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (UnimplementedDlpServiceServer) UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}

// UnsafeDlpServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DlpServiceServer will
// result in compilation errors.
type UnsafeDlpServiceServer interface {
	mustEmbedUnimplementedDlpServiceServer()
}

func RegisterDlpServiceServer(s grpc.ServiceRegistrar, srv DlpServiceServer) {
	s.RegisterService(&DlpService_ServiceDesc, srv)
}

func _DlpService_InspectContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).InspectContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_InspectContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).InspectContent(ctx, req.(*InspectContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_RedactImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RedactImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).RedactImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_RedactImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).RedactImage(ctx, req.(*RedactImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeidentifyContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, req.(*DeidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ReidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ReidentifyContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, req.(*ReidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListInfoTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, req.(*ListInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateInspectTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, req.(*CreateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateInspectTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, req.(*UpdateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetInspectTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, req.(*GetInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInspectTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInspectTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListInspectTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, req.(*ListInspectTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteInspectTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, req.(*DeleteInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateDeidentifyTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, req.(*CreateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateDeidentifyTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, req.(*UpdateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetDeidentifyTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, req.(*GetDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDeidentifyTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeidentifyTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListDeidentifyTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, req.(*ListDeidentifyTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteDeidentifyTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, req.(*DeleteDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, req.(*CreateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, req.(*UpdateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_HybridInspectJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HybridInspectJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).HybridInspectJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_HybridInspectJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).HybridInspectJobTrigger(ctx, req.(*HybridInspectJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, req.(*GetJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListJobTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListJobTriggers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, req.(*ListJobTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, req.(*DeleteJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ActivateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ActivateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ActivateJobTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ActivateJobTrigger(ctx, req.(*ActivateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDiscoveryConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDiscoveryConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDiscoveryConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateDiscoveryConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDiscoveryConfig(ctx, req.(*CreateDiscoveryConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateDiscoveryConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDiscoveryConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateDiscoveryConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateDiscoveryConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateDiscoveryConfig(ctx, req.(*UpdateDiscoveryConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDiscoveryConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiscoveryConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDiscoveryConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetDiscoveryConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDiscoveryConfig(ctx, req.(*GetDiscoveryConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDiscoveryConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDiscoveryConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDiscoveryConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListDiscoveryConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDiscoveryConfigs(ctx, req.(*ListDiscoveryConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDiscoveryConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDiscoveryConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDiscoveryConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteDiscoveryConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDiscoveryConfig(ctx, req.(*DeleteDiscoveryConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDlpJob(ctx, req.(*CreateDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDlpJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDlpJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListDlpJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, req.(*ListDlpJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDlpJob(ctx, req.(*GetDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, req.(*DeleteDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CancelDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CancelDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, req.(*CancelDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateStoredInfoType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateStoredInfoType(ctx, req.(*CreateStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateStoredInfoType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateStoredInfoType(ctx, req.(*UpdateStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetStoredInfoType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetStoredInfoType(ctx, req.(*GetStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListStoredInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStoredInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListStoredInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListStoredInfoTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListStoredInfoTypes(ctx, req.(*ListStoredInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteStoredInfoType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteStoredInfoType(ctx, req.(*DeleteStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListProjectDataProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectDataProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListProjectDataProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListProjectDataProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListProjectDataProfiles(ctx, req.(*ListProjectDataProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListTableDataProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTableDataProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListTableDataProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListTableDataProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListTableDataProfiles(ctx, req.(*ListTableDataProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListColumnDataProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListColumnDataProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListColumnDataProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListColumnDataProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListColumnDataProfiles(ctx, req.(*ListColumnDataProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetProjectDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetProjectDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetProjectDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetProjectDataProfile(ctx, req.(*GetProjectDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListFileStoreDataProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFileStoreDataProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListFileStoreDataProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListFileStoreDataProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListFileStoreDataProfiles(ctx, req.(*ListFileStoreDataProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetFileStoreDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileStoreDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetFileStoreDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetFileStoreDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetFileStoreDataProfile(ctx, req.(*GetFileStoreDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteFileStoreDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFileStoreDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteFileStoreDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteFileStoreDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteFileStoreDataProfile(ctx, req.(*DeleteFileStoreDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetTableDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetTableDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetTableDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetTableDataProfile(ctx, req.(*GetTableDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetColumnDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetColumnDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetColumnDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetColumnDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetColumnDataProfile(ctx, req.(*GetColumnDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteTableDataProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableDataProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteTableDataProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteTableDataProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteTableDataProfile(ctx, req.(*DeleteTableDataProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_HybridInspectDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HybridInspectDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).HybridInspectDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_HybridInspectDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).HybridInspectDlpJob(ctx, req.(*HybridInspectDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_FinishDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).FinishDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_FinishDlpJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).FinishDlpJob(ctx, req.(*FinishDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_CreateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_GetConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_ListConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_SearchConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).SearchConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_SearchConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).SearchConnections(ctx, req.(*SearchConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_DeleteConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DlpService_UpdateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DlpService_ServiceDesc is the grpc.ServiceDesc for DlpService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DlpService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.privacy.dlp.v2.DlpService",
	HandlerType: (*DlpServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InspectContent",
			Handler:    _DlpService_InspectContent_Handler,
		},
		{
			MethodName: "RedactImage",
			Handler:    _DlpService_RedactImage_Handler,
		},
		{
			MethodName: "DeidentifyContent",
			Handler:    _DlpService_DeidentifyContent_Handler,
		},
		{
			MethodName: "ReidentifyContent",
			Handler:    _DlpService_ReidentifyContent_Handler,
		},
		{
			MethodName: "ListInfoTypes",
			Handler:    _DlpService_ListInfoTypes_Handler,
		},
		{
			MethodName: "CreateInspectTemplate",
			Handler:    _DlpService_CreateInspectTemplate_Handler,
		},
		{
			MethodName: "UpdateInspectTemplate",
			Handler:    _DlpService_UpdateInspectTemplate_Handler,
		},
		{
			MethodName: "GetInspectTemplate",
			Handler:    _DlpService_GetInspectTemplate_Handler,
		},
		{
			MethodName: "ListInspectTemplates",
			Handler:    _DlpService_ListInspectTemplates_Handler,
		},
		{
			MethodName: "DeleteInspectTemplate",
			Handler:    _DlpService_DeleteInspectTemplate_Handler,
		},
		{
			MethodName: "CreateDeidentifyTemplate",
			Handler:    _DlpService_CreateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "UpdateDeidentifyTemplate",
			Handler:    _DlpService_UpdateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "GetDeidentifyTemplate",
			Handler:    _DlpService_GetDeidentifyTemplate_Handler,
		},
		{
			MethodName: "ListDeidentifyTemplates",
			Handler:    _DlpService_ListDeidentifyTemplates_Handler,
		},
		{
			MethodName: "DeleteDeidentifyTemplate",
			Handler:    _DlpService_DeleteDeidentifyTemplate_Handler,
		},
		{
			MethodName: "CreateJobTrigger",
			Handler:    _DlpService_CreateJobTrigger_Handler,
		},
		{
			MethodName: "UpdateJobTrigger",
			Handler:    _DlpService_UpdateJobTrigger_Handler,
		},
		{
			MethodName: "HybridInspectJobTrigger",
			Handler:    _DlpService_HybridInspectJobTrigger_Handler,
		},
		{
			MethodName: "GetJobTrigger",
			Handler:    _DlpService_GetJobTrigger_Handler,
		},
		{
			MethodName: "ListJobTriggers",
			Handler:    _DlpService_ListJobTriggers_Handler,
		},
		{
			MethodName: "DeleteJobTrigger",
			Handler:    _DlpService_DeleteJobTrigger_Handler,
		},
		{
			MethodName: "ActivateJobTrigger",
			Handler:    _DlpService_ActivateJobTrigger_Handler,
		},
		{
			MethodName: "CreateDiscoveryConfig",
			Handler:    _DlpService_CreateDiscoveryConfig_Handler,
		},
		{
			MethodName: "UpdateDiscoveryConfig",
			Handler:    _DlpService_UpdateDiscoveryConfig_Handler,
		},
		{
			MethodName: "GetDiscoveryConfig",
			Handler:    _DlpService_GetDiscoveryConfig_Handler,
		},
		{
			MethodName: "ListDiscoveryConfigs",
			Handler:    _DlpService_ListDiscoveryConfigs_Handler,
		},
		{
			MethodName: "DeleteDiscoveryConfig",
			Handler:    _DlpService_DeleteDiscoveryConfig_Handler,
		},
		{
			MethodName: "CreateDlpJob",
			Handler:    _DlpService_CreateDlpJob_Handler,
		},
		{
			MethodName: "ListDlpJobs",
			Handler:    _DlpService_ListDlpJobs_Handler,
		},
		{
			MethodName: "GetDlpJob",
			Handler:    _DlpService_GetDlpJob_Handler,
		},
		{
			MethodName: "DeleteDlpJob",
			Handler:    _DlpService_DeleteDlpJob_Handler,
		},
		{
			MethodName: "CancelDlpJob",
			Handler:    _DlpService_CancelDlpJob_Handler,
		},
		{
			MethodName: "CreateStoredInfoType",
			Handler:    _DlpService_CreateStoredInfoType_Handler,
		},
		{
			MethodName: "UpdateStoredInfoType",
			Handler:    _DlpService_UpdateStoredInfoType_Handler,
		},
		{
			MethodName: "GetStoredInfoType",
			Handler:    _DlpService_GetStoredInfoType_Handler,
		},
		{
			MethodName: "ListStoredInfoTypes",
			Handler:    _DlpService_ListStoredInfoTypes_Handler,
		},
		{
			MethodName: "DeleteStoredInfoType",
			Handler:    _DlpService_DeleteStoredInfoType_Handler,
		},
		{
			MethodName: "ListProjectDataProfiles",
			Handler:    _DlpService_ListProjectDataProfiles_Handler,
		},
		{
			MethodName: "ListTableDataProfiles",
			Handler:    _DlpService_ListTableDataProfiles_Handler,
		},
		{
			MethodName: "ListColumnDataProfiles",
			Handler:    _DlpService_ListColumnDataProfiles_Handler,
		},
		{
			MethodName: "GetProjectDataProfile",
			Handler:    _DlpService_GetProjectDataProfile_Handler,
		},
		{
			MethodName: "ListFileStoreDataProfiles",
			Handler:    _DlpService_ListFileStoreDataProfiles_Handler,
		},
		{
			MethodName: "GetFileStoreDataProfile",
			Handler:    _DlpService_GetFileStoreDataProfile_Handler,
		},
		{
			MethodName: "DeleteFileStoreDataProfile",
			Handler:    _DlpService_DeleteFileStoreDataProfile_Handler,
		},
		{
			MethodName: "GetTableDataProfile",
			Handler:    _DlpService_GetTableDataProfile_Handler,
		},
		{
			MethodName: "GetColumnDataProfile",
			Handler:    _DlpService_GetColumnDataProfile_Handler,
		},
		{
			MethodName: "DeleteTableDataProfile",
			Handler:    _DlpService_DeleteTableDataProfile_Handler,
		},
		{
			MethodName: "HybridInspectDlpJob",
			Handler:    _DlpService_HybridInspectDlpJob_Handler,
		},
		{
			MethodName: "FinishDlpJob",
			Handler:    _DlpService_FinishDlpJob_Handler,
		},
		{
			MethodName: "CreateConnection",
			Handler:    _DlpService_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _DlpService_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _DlpService_ListConnections_Handler,
		},
		{
			MethodName: "SearchConnections",
			Handler:    _DlpService_SearchConnections_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _DlpService_DeleteConnection_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _DlpService_UpdateConnection_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/privacy/dlp/v2/dlp.proto",
}
