// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/gkemulticloud/v1/attached_resources.proto

package gkemulticloudpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The lifecycle state of the cluster.
type AttachedCluster_State int32

const (
	// Not set.
	AttachedCluster_STATE_UNSPECIFIED AttachedCluster_State = 0
	// The PROVISIONING state indicates the cluster is being registered.
	AttachedCluster_PROVISIONING AttachedCluster_State = 1
	// The RUNNING state indicates the cluster has been register and is fully
	// usable.
	AttachedCluster_RUNNING AttachedCluster_State = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading software components.
	AttachedCluster_RECONCILING AttachedCluster_State = 3
	// The STOPPING state indicates the cluster is being de-registered.
	AttachedCluster_STOPPING AttachedCluster_State = 4
	// The ERROR state indicates the cluster is in a broken unrecoverable
	// state.
	AttachedCluster_ERROR AttachedCluster_State = 5
	// The DEGRADED state indicates the cluster requires user action to
	// restore full functionality.
	AttachedCluster_DEGRADED AttachedCluster_State = 6
)

// Enum value maps for AttachedCluster_State.
var (
	AttachedCluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	AttachedCluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           2,
		"RECONCILING":       3,
		"STOPPING":          4,
		"ERROR":             5,
		"DEGRADED":          6,
	}
)

func (x AttachedCluster_State) Enum() *AttachedCluster_State {
	p := new(AttachedCluster_State)
	*p = x
	return p
}

func (x AttachedCluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedCluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[0].Descriptor()
}

func (AttachedCluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[0]
}

func (x AttachedCluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedCluster_State.Descriptor instead.
func (AttachedCluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{0, 0}
}

// KeyOperator represents a key's relationship to the value e.g. 'Equal'.
type Toleration_KeyOperator int32

const (
	// Operator is not specified.
	Toleration_KEY_OPERATOR_UNSPECIFIED Toleration_KeyOperator = 0
	// Operator maps to 'Equal'.
	Toleration_KEY_OPERATOR_EQUAL Toleration_KeyOperator = 1
	// Operator maps to 'Exists'.
	Toleration_KEY_OPERATOR_EXISTS Toleration_KeyOperator = 2
)

// Enum value maps for Toleration_KeyOperator.
var (
	Toleration_KeyOperator_name = map[int32]string{
		0: "KEY_OPERATOR_UNSPECIFIED",
		1: "KEY_OPERATOR_EQUAL",
		2: "KEY_OPERATOR_EXISTS",
	}
	Toleration_KeyOperator_value = map[string]int32{
		"KEY_OPERATOR_UNSPECIFIED": 0,
		"KEY_OPERATOR_EQUAL":       1,
		"KEY_OPERATOR_EXISTS":      2,
	}
)

func (x Toleration_KeyOperator) Enum() *Toleration_KeyOperator {
	p := new(Toleration_KeyOperator)
	*p = x
	return p
}

func (x Toleration_KeyOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Toleration_KeyOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[1].Descriptor()
}

func (Toleration_KeyOperator) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[1]
}

func (x Toleration_KeyOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Toleration_KeyOperator.Descriptor instead.
func (Toleration_KeyOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{11, 0}
}

// Effect indicates the taint effect to match e.g. 'NoSchedule'.
type Toleration_Effect int32

const (
	// Effect is not specified.
	Toleration_EFFECT_UNSPECIFIED Toleration_Effect = 0
	// Effect maps to 'NoSchedule'.
	Toleration_EFFECT_NO_SCHEDULE Toleration_Effect = 1
	// Effect maps to 'PreferNoSchedule'.
	Toleration_EFFECT_PREFER_NO_SCHEDULE Toleration_Effect = 2
	// Effect maps to 'NoExecute'.
	Toleration_EFFECT_NO_EXECUTE Toleration_Effect = 3
)

// Enum value maps for Toleration_Effect.
var (
	Toleration_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "EFFECT_NO_SCHEDULE",
		2: "EFFECT_PREFER_NO_SCHEDULE",
		3: "EFFECT_NO_EXECUTE",
	}
	Toleration_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED":        0,
		"EFFECT_NO_SCHEDULE":        1,
		"EFFECT_PREFER_NO_SCHEDULE": 2,
		"EFFECT_NO_EXECUTE":         3,
	}
)

func (x Toleration_Effect) Enum() *Toleration_Effect {
	p := new(Toleration_Effect)
	*p = x
	return p
}

func (x Toleration_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Toleration_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[2].Descriptor()
}

func (Toleration_Effect) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes[2]
}

func (x Toleration_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Toleration_Effect.Descriptor instead.
func (Toleration_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{11, 1}
}

// An Anthos cluster running on customer own infrastructure.
type AttachedCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// Cluster names are formatted as
	// `projects/<project-number>/locations/<region>/attachedClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human readable description of this cluster.
	// Cannot be longer than 255 UTF-8 encoded bytes.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. OpenID Connect (OIDC) configuration for the cluster.
	OidcConfig *AttachedOidcConfig `protobuf:"bytes,3,opt,name=oidc_config,json=oidcConfig,proto3" json:"oidc_config,omitempty"`
	// Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig].
	PlatformVersion string `protobuf:"bytes,4,opt,name=platform_version,json=platformVersion,proto3" json:"platform_version,omitempty"`
	// Required. The Kubernetes distribution of the underlying attached cluster.
	//
	// Supported values: ["eks", "aks", "generic"].
	Distribution string `protobuf:"bytes,16,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Output only. The region where this cluster runs.
	//
	// For EKS clusters, this is a AWS region. For AKS clusters,
	// this is an Azure region.
	ClusterRegion string `protobuf:"bytes,22,opt,name=cluster_region,json=clusterRegion,proto3" json:"cluster_region,omitempty"`
	// Required. Fleet configuration.
	Fleet *Fleet `protobuf:"bytes,5,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Output only. The current state of the cluster.
	State AttachedCluster_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.gkemulticloud.v1.AttachedCluster_State" json:"state,omitempty"`
	// Output only. A globally unique identifier for the cluster.
	Uid string `protobuf:"bytes,7,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. If set, there are currently changes in flight to the cluster.
	Reconciling bool `protobuf:"varint,8,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The time at which this cluster was registered.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this cluster was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	//
	// Can be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The Kubernetes version of the cluster.
	KubernetesVersion string `protobuf:"bytes,12,opt,name=kubernetes_version,json=kubernetesVersion,proto3" json:"kubernetes_version,omitempty"`
	// Optional. Annotations on the cluster.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Key can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Workload Identity settings.
	WorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,14,opt,name=workload_identity_config,json=workloadIdentityConfig,proto3" json:"workload_identity_config,omitempty"`
	// Optional. Logging configuration for this cluster.
	LoggingConfig *LoggingConfig `protobuf:"bytes,15,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Output only. A set of errors found in the cluster.
	Errors []*AttachedClusterError `protobuf:"bytes,20,rep,name=errors,proto3" json:"errors,omitempty"`
	// Optional. Configuration related to the cluster RBAC settings.
	Authorization *AttachedClustersAuthorization `protobuf:"bytes,21,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Optional. Monitoring configuration for this cluster.
	MonitoringConfig *MonitoringConfig `protobuf:"bytes,23,opt,name=monitoring_config,json=monitoringConfig,proto3" json:"monitoring_config,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AttachedProxyConfig `protobuf:"bytes,24,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
	// Optional. Binary Authorization configuration for this cluster.
	BinaryAuthorization *BinaryAuthorization `protobuf:"bytes,25,opt,name=binary_authorization,json=binaryAuthorization,proto3" json:"binary_authorization,omitempty"`
	// Optional. Security Posture configuration for this cluster.
	SecurityPostureConfig *SecurityPostureConfig `protobuf:"bytes,26,opt,name=security_posture_config,json=securityPostureConfig,proto3" json:"security_posture_config,omitempty"`
	// Optional. Input only. Tag keys and values directly bound to this resource.
	//
	// The tag key must be specified in the format
	// `<tag namespace>/<tag key name>,`
	// where the tag namespace is the ID of the organization or name of the
	// project that the tag key is defined in. The short name of a tag key or
	// value can have a maximum length of 256 characters. The permitted character
	// set for the short name includes UTF-8 encoded Unicode characters except
	// single quotation marks (`'`), double quotation marks (`"`), backslashes
	// (`\`), and forward slashes (`/`).
	//
	// See
	// [Tags](https://cloud.google.com/resource-manager/docs/tags/tags-overview)
	// for more details on Google Cloud Platform tags.
	Tags map[string]string `protobuf:"bytes,27,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Kubernetes configurations for auto-installed components on the
	// cluster.
	SystemComponentsConfig *SystemComponentsConfig `protobuf:"bytes,28,opt,name=system_components_config,json=systemComponentsConfig,proto3" json:"system_components_config,omitempty"`
}

func (x *AttachedCluster) Reset() {
	*x = AttachedCluster{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedCluster) ProtoMessage() {}

func (x *AttachedCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedCluster.ProtoReflect.Descriptor instead.
func (*AttachedCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{0}
}

func (x *AttachedCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttachedCluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AttachedCluster) GetOidcConfig() *AttachedOidcConfig {
	if x != nil {
		return x.OidcConfig
	}
	return nil
}

func (x *AttachedCluster) GetPlatformVersion() string {
	if x != nil {
		return x.PlatformVersion
	}
	return ""
}

func (x *AttachedCluster) GetDistribution() string {
	if x != nil {
		return x.Distribution
	}
	return ""
}

func (x *AttachedCluster) GetClusterRegion() string {
	if x != nil {
		return x.ClusterRegion
	}
	return ""
}

func (x *AttachedCluster) GetFleet() *Fleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *AttachedCluster) GetState() AttachedCluster_State {
	if x != nil {
		return x.State
	}
	return AttachedCluster_STATE_UNSPECIFIED
}

func (x *AttachedCluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AttachedCluster) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AttachedCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AttachedCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AttachedCluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AttachedCluster) GetKubernetesVersion() string {
	if x != nil {
		return x.KubernetesVersion
	}
	return ""
}

func (x *AttachedCluster) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AttachedCluster) GetWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.WorkloadIdentityConfig
	}
	return nil
}

func (x *AttachedCluster) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *AttachedCluster) GetErrors() []*AttachedClusterError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *AttachedCluster) GetAuthorization() *AttachedClustersAuthorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *AttachedCluster) GetMonitoringConfig() *MonitoringConfig {
	if x != nil {
		return x.MonitoringConfig
	}
	return nil
}

func (x *AttachedCluster) GetProxyConfig() *AttachedProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

func (x *AttachedCluster) GetBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.BinaryAuthorization
	}
	return nil
}

func (x *AttachedCluster) GetSecurityPostureConfig() *SecurityPostureConfig {
	if x != nil {
		return x.SecurityPostureConfig
	}
	return nil
}

func (x *AttachedCluster) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AttachedCluster) GetSystemComponentsConfig() *SystemComponentsConfig {
	if x != nil {
		return x.SystemComponentsConfig
	}
	return nil
}

// Configuration related to the cluster RBAC settings.
type AttachedClustersAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Users that can perform operations as a cluster admin. A managed
	// ClusterRoleBinding will be created to grant the `cluster-admin` ClusterRole
	// to the users. Up to ten admin users can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminUsers []*AttachedClusterUser `protobuf:"bytes,1,rep,name=admin_users,json=adminUsers,proto3" json:"admin_users,omitempty"`
	// Optional. Groups of users that can perform operations as a cluster admin. A
	// managed ClusterRoleBinding will be created to grant the `cluster-admin`
	// ClusterRole to the groups. Up to ten admin groups can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminGroups []*AttachedClusterGroup `protobuf:"bytes,2,rep,name=admin_groups,json=adminGroups,proto3" json:"admin_groups,omitempty"`
}

func (x *AttachedClustersAuthorization) Reset() {
	*x = AttachedClustersAuthorization{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedClustersAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedClustersAuthorization) ProtoMessage() {}

func (x *AttachedClustersAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedClustersAuthorization.ProtoReflect.Descriptor instead.
func (*AttachedClustersAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{1}
}

func (x *AttachedClustersAuthorization) GetAdminUsers() []*AttachedClusterUser {
	if x != nil {
		return x.AdminUsers
	}
	return nil
}

func (x *AttachedClustersAuthorization) GetAdminGroups() []*AttachedClusterGroup {
	if x != nil {
		return x.AdminGroups
	}
	return nil
}

// Identities of a user-type subject for Attached clusters.
type AttachedClusterUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the user, e.g. `my-gcp-id@gmail.com`.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *AttachedClusterUser) Reset() {
	*x = AttachedClusterUser{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedClusterUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedClusterUser) ProtoMessage() {}

func (x *AttachedClusterUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedClusterUser.ProtoReflect.Descriptor instead.
func (*AttachedClusterUser) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{2}
}

func (x *AttachedClusterUser) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Identities of a group-type subject for Attached clusters.
type AttachedClusterGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the group, e.g. `my-group@domain.com`.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *AttachedClusterGroup) Reset() {
	*x = AttachedClusterGroup{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedClusterGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedClusterGroup) ProtoMessage() {}

func (x *AttachedClusterGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedClusterGroup.ProtoReflect.Descriptor instead.
func (*AttachedClusterGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{3}
}

func (x *AttachedClusterGroup) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// OIDC discovery information of the target cluster.
//
// Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
// API server. This fields indicates how Google Cloud Platform services
// validate KSA tokens in order to allow system workloads (such as GKE Connect
// and telemetry agents) to authenticate back to Google Cloud Platform.
//
// Both clusters with public and private issuer URLs are supported.
// Clusters with public issuers only need to specify the `issuer_url` field
// while clusters with private issuers need to provide both
// `issuer_url` and `oidc_jwks`.
type AttachedOidcConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://`.
	IssuerUrl string `protobuf:"bytes,1,opt,name=issuer_url,json=issuerUrl,proto3" json:"issuer_url,omitempty"`
	// Optional. OIDC verification keys in JWKS format (RFC 7517).
	// It contains a list of OIDC verification keys that can be used to verify
	// OIDC JWTs.
	//
	// This field is required for cluster that doesn't have a publicly available
	// discovery endpoint. When provided, it will be directly used
	// to verify the OIDC JWT asserted by the IDP.
	Jwks []byte `protobuf:"bytes,2,opt,name=jwks,proto3" json:"jwks,omitempty"`
}

func (x *AttachedOidcConfig) Reset() {
	*x = AttachedOidcConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedOidcConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedOidcConfig) ProtoMessage() {}

func (x *AttachedOidcConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedOidcConfig.ProtoReflect.Descriptor instead.
func (*AttachedOidcConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{4}
}

func (x *AttachedOidcConfig) GetIssuerUrl() string {
	if x != nil {
		return x.IssuerUrl
	}
	return ""
}

func (x *AttachedOidcConfig) GetJwks() []byte {
	if x != nil {
		return x.Jwks
	}
	return nil
}

// AttachedServerConfig provides information about supported
// Kubernetes versions
type AttachedServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the config.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// List of valid platform versions.
	ValidVersions []*AttachedPlatformVersionInfo `protobuf:"bytes,2,rep,name=valid_versions,json=validVersions,proto3" json:"valid_versions,omitempty"`
}

func (x *AttachedServerConfig) Reset() {
	*x = AttachedServerConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedServerConfig) ProtoMessage() {}

func (x *AttachedServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedServerConfig.ProtoReflect.Descriptor instead.
func (*AttachedServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{5}
}

func (x *AttachedServerConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttachedServerConfig) GetValidVersions() []*AttachedPlatformVersionInfo {
	if x != nil {
		return x.ValidVersions
	}
	return nil
}

// Information about a supported Attached Clusters platform version.
type AttachedPlatformVersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Platform version name.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. True if the version is available for attachedcluster creation. If
	// a version is enabled, it can be used to attach new clusters.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. True if this cluster version belongs to a minor version that has
	// reached its end of life and is no longer in scope to receive security and
	// bug fixes.
	EndOfLife bool `protobuf:"varint,4,opt,name=end_of_life,json=endOfLife,proto3" json:"end_of_life,omitempty"`
	// Optional. The estimated date (in Pacific Time) when this cluster version
	// will reach its end of life. Or if this version is no longer supported (the
	// `end_of_life` field is true), this is the actual date (in Pacific time)
	// when the version reached its end of life.
	EndOfLifeDate *date.Date `protobuf:"bytes,5,opt,name=end_of_life_date,json=endOfLifeDate,proto3" json:"end_of_life_date,omitempty"`
	// Optional. The date (in Pacific Time) when the cluster version was released.
	ReleaseDate *date.Date `protobuf:"bytes,6,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
}

func (x *AttachedPlatformVersionInfo) Reset() {
	*x = AttachedPlatformVersionInfo{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedPlatformVersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedPlatformVersionInfo) ProtoMessage() {}

func (x *AttachedPlatformVersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedPlatformVersionInfo.ProtoReflect.Descriptor instead.
func (*AttachedPlatformVersionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AttachedPlatformVersionInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AttachedPlatformVersionInfo) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AttachedPlatformVersionInfo) GetEndOfLife() bool {
	if x != nil {
		return x.EndOfLife
	}
	return false
}

func (x *AttachedPlatformVersionInfo) GetEndOfLifeDate() *date.Date {
	if x != nil {
		return x.EndOfLifeDate
	}
	return nil
}

func (x *AttachedPlatformVersionInfo) GetReleaseDate() *date.Date {
	if x != nil {
		return x.ReleaseDate
	}
	return nil
}

// AttachedClusterError describes errors found on attached clusters.
type AttachedClusterError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-friendly description of the error.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AttachedClusterError) Reset() {
	*x = AttachedClusterError{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedClusterError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedClusterError) ProtoMessage() {}

func (x *AttachedClusterError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedClusterError.ProtoReflect.Descriptor instead.
func (*AttachedClusterError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{7}
}

func (x *AttachedClusterError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Details of a proxy config.
type AttachedProxyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Kubernetes Secret resource that contains the HTTP(S) proxy
	// configuration. The secret must be a JSON encoded proxy configuration
	// as described in
	// https://cloud.google.com/kubernetes-engine/multi-cloud/docs/attached/eks/how-to/use-a-proxy#configure-proxy-support
	// for EKS clusters and
	// https://cloud.google.com/kubernetes-engine/multi-cloud/docs/attached/aks/how-to/use-a-proxy#configure-proxy-support
	// for AKS clusters.
	KubernetesSecret *KubernetesSecret `protobuf:"bytes,1,opt,name=kubernetes_secret,json=kubernetesSecret,proto3" json:"kubernetes_secret,omitempty"`
}

func (x *AttachedProxyConfig) Reset() {
	*x = AttachedProxyConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedProxyConfig) ProtoMessage() {}

func (x *AttachedProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedProxyConfig.ProtoReflect.Descriptor instead.
func (*AttachedProxyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{8}
}

func (x *AttachedProxyConfig) GetKubernetesSecret() *KubernetesSecret {
	if x != nil {
		return x.KubernetesSecret
	}
	return nil
}

// Information about a Kubernetes Secret
type KubernetesSecret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the kubernetes secret.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace in which the kubernetes secret is stored.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (x *KubernetesSecret) Reset() {
	*x = KubernetesSecret{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KubernetesSecret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesSecret) ProtoMessage() {}

func (x *KubernetesSecret) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesSecret.ProtoReflect.Descriptor instead.
func (*KubernetesSecret) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{9}
}

func (x *KubernetesSecret) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KubernetesSecret) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// SystemComponentsConfig defines the fields for customizing configurations for
// auto-installed components.
type SystemComponentsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets custom tolerations for pods created by auto-installed components.
	Tolerations []*Toleration `protobuf:"bytes,1,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// Sets custom labels for pods created by auto-installed components.
	Labels []*Label `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *SystemComponentsConfig) Reset() {
	*x = SystemComponentsConfig{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SystemComponentsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemComponentsConfig) ProtoMessage() {}

func (x *SystemComponentsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemComponentsConfig.ProtoReflect.Descriptor instead.
func (*SystemComponentsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{10}
}

func (x *SystemComponentsConfig) GetTolerations() []*Toleration {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

func (x *SystemComponentsConfig) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Toleration defines the fields for tolerations for pods created by
// auto-installed components.
type Toleration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key is the taint key that the toleration applies to.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value is the taint value that the toleration applies to.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// KeyOperator represents a key's relationship to the value e.g. 'Exist'.
	KeyOperator Toleration_KeyOperator `protobuf:"varint,3,opt,name=key_operator,json=keyOperator,proto3,enum=google.cloud.gkemulticloud.v1.Toleration_KeyOperator" json:"key_operator,omitempty"`
	// Effect indicates the taint effect to match e.g. 'NoSchedule'
	Effect Toleration_Effect `protobuf:"varint,4,opt,name=effect,proto3,enum=google.cloud.gkemulticloud.v1.Toleration_Effect" json:"effect,omitempty"`
}

func (x *Toleration) Reset() {
	*x = Toleration{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Toleration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Toleration) ProtoMessage() {}

func (x *Toleration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Toleration.ProtoReflect.Descriptor instead.
func (*Toleration) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{11}
}

func (x *Toleration) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Toleration) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Toleration) GetKeyOperator() Toleration_KeyOperator {
	if x != nil {
		return x.KeyOperator
	}
	return Toleration_KEY_OPERATOR_UNSPECIFIED
}

func (x *Toleration) GetEffect() Toleration_Effect {
	if x != nil {
		return x.Effect
	}
	return Toleration_EFFECT_UNSPECIFIED
}

// Label defines the additional fields for labels for pods created by
// auto-installed components.
type Label struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the key of the label.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// This is the value of the label.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Label) Reset() {
	*x = Label{}
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label.ProtoReflect.Descriptor instead.
func (*Label) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP(), []int{12}
}

func (x *Label) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Label) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_attached_resources_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x93, 0x11, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x57, 0x0a, 0x0b, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x4f,
	0x69, 0x64, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6f, 0x69, 0x64, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12,
	0x3f, 0x0a, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x6c, 0x65, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x32, 0x0a, 0x12, 0x6b, 0x75, 0x62, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x74, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x14, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x67, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5a, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a,
	0x14, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x17, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x04, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x74, 0x0a, 0x18, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x2c, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0xd6, 0x01, 0x0a, 0x1d, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0b, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x55,
	0x73, 0x65, 0x72, 0x73, 0x12, 0x5b, 0x0a, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0x36, 0x0a, 0x13, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x31, 0x0a, 0x14, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x19, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x4c, 0x0a, 0x12,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x4f, 0x69, 0x64, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x55, 0x72,
	0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6a, 0x77, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6a, 0x77, 0x6b, 0x73, 0x22, 0x83, 0x02, 0x0a, 0x14, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a,
	0x31, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xf7, 0x01, 0x0a, 0x1b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0b, 0x65, 0x6e, 0x64,
	0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69, 0x66, 0x65, 0x12, 0x3f,
	0x0a, 0x10, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69, 0x66, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x39, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x44, 0x61, 0x74, 0x65, 0x22, 0x30, 0x0a, 0x14, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x73, 0x0a, 0x13,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x11, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52,
	0x10, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x22, 0x44, 0x0a, 0x10, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x16, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0b, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0xa6, 0x03,
	0x0a, 0x0a, 0x54, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x58, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x48,
	0x0a, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x52, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x22, 0x5c, 0x0a, 0x0b, 0x4b, 0x65, 0x79, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x1c, 0x0a, 0x18, 0x4b, 0x45, 0x59, 0x5f, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x4b, 0x45, 0x59, 0x5f, 0x4f, 0x50, 0x45,
	0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x4b, 0x45, 0x59, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x45, 0x58,
	0x49, 0x53, 0x54, 0x53, 0x10, 0x02, 0x22, 0x6e, 0x0a, 0x06, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46, 0x45,
	0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x01,
	0x12, 0x1d, 0x0a, 0x19, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45,
	0x52, 0x5f, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x15, 0x0a, 0x11, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x45,
	0x43, 0x55, 0x54, 0x45, 0x10, 0x03, 0x22, 0x2f, 0x0a, 0x05, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0xe9, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62,
	0x3b, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62,
	0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescData = file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_gkemulticloud_v1_attached_resources_proto_goTypes = []any{
	(AttachedCluster_State)(0),            // 0: google.cloud.gkemulticloud.v1.AttachedCluster.State
	(Toleration_KeyOperator)(0),           // 1: google.cloud.gkemulticloud.v1.Toleration.KeyOperator
	(Toleration_Effect)(0),                // 2: google.cloud.gkemulticloud.v1.Toleration.Effect
	(*AttachedCluster)(nil),               // 3: google.cloud.gkemulticloud.v1.AttachedCluster
	(*AttachedClustersAuthorization)(nil), // 4: google.cloud.gkemulticloud.v1.AttachedClustersAuthorization
	(*AttachedClusterUser)(nil),           // 5: google.cloud.gkemulticloud.v1.AttachedClusterUser
	(*AttachedClusterGroup)(nil),          // 6: google.cloud.gkemulticloud.v1.AttachedClusterGroup
	(*AttachedOidcConfig)(nil),            // 7: google.cloud.gkemulticloud.v1.AttachedOidcConfig
	(*AttachedServerConfig)(nil),          // 8: google.cloud.gkemulticloud.v1.AttachedServerConfig
	(*AttachedPlatformVersionInfo)(nil),   // 9: google.cloud.gkemulticloud.v1.AttachedPlatformVersionInfo
	(*AttachedClusterError)(nil),          // 10: google.cloud.gkemulticloud.v1.AttachedClusterError
	(*AttachedProxyConfig)(nil),           // 11: google.cloud.gkemulticloud.v1.AttachedProxyConfig
	(*KubernetesSecret)(nil),              // 12: google.cloud.gkemulticloud.v1.KubernetesSecret
	(*SystemComponentsConfig)(nil),        // 13: google.cloud.gkemulticloud.v1.SystemComponentsConfig
	(*Toleration)(nil),                    // 14: google.cloud.gkemulticloud.v1.Toleration
	(*Label)(nil),                         // 15: google.cloud.gkemulticloud.v1.Label
	nil,                                   // 16: google.cloud.gkemulticloud.v1.AttachedCluster.AnnotationsEntry
	nil,                                   // 17: google.cloud.gkemulticloud.v1.AttachedCluster.TagsEntry
	(*Fleet)(nil),                         // 18: google.cloud.gkemulticloud.v1.Fleet
	(*timestamppb.Timestamp)(nil),         // 19: google.protobuf.Timestamp
	(*WorkloadIdentityConfig)(nil),        // 20: google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	(*LoggingConfig)(nil),                 // 21: google.cloud.gkemulticloud.v1.LoggingConfig
	(*MonitoringConfig)(nil),              // 22: google.cloud.gkemulticloud.v1.MonitoringConfig
	(*BinaryAuthorization)(nil),           // 23: google.cloud.gkemulticloud.v1.BinaryAuthorization
	(*SecurityPostureConfig)(nil),         // 24: google.cloud.gkemulticloud.v1.SecurityPostureConfig
	(*date.Date)(nil),                     // 25: google.type.Date
}
var file_google_cloud_gkemulticloud_v1_attached_resources_proto_depIdxs = []int32{
	7,  // 0: google.cloud.gkemulticloud.v1.AttachedCluster.oidc_config:type_name -> google.cloud.gkemulticloud.v1.AttachedOidcConfig
	18, // 1: google.cloud.gkemulticloud.v1.AttachedCluster.fleet:type_name -> google.cloud.gkemulticloud.v1.Fleet
	0,  // 2: google.cloud.gkemulticloud.v1.AttachedCluster.state:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster.State
	19, // 3: google.cloud.gkemulticloud.v1.AttachedCluster.create_time:type_name -> google.protobuf.Timestamp
	19, // 4: google.cloud.gkemulticloud.v1.AttachedCluster.update_time:type_name -> google.protobuf.Timestamp
	16, // 5: google.cloud.gkemulticloud.v1.AttachedCluster.annotations:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster.AnnotationsEntry
	20, // 6: google.cloud.gkemulticloud.v1.AttachedCluster.workload_identity_config:type_name -> google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	21, // 7: google.cloud.gkemulticloud.v1.AttachedCluster.logging_config:type_name -> google.cloud.gkemulticloud.v1.LoggingConfig
	10, // 8: google.cloud.gkemulticloud.v1.AttachedCluster.errors:type_name -> google.cloud.gkemulticloud.v1.AttachedClusterError
	4,  // 9: google.cloud.gkemulticloud.v1.AttachedCluster.authorization:type_name -> google.cloud.gkemulticloud.v1.AttachedClustersAuthorization
	22, // 10: google.cloud.gkemulticloud.v1.AttachedCluster.monitoring_config:type_name -> google.cloud.gkemulticloud.v1.MonitoringConfig
	11, // 11: google.cloud.gkemulticloud.v1.AttachedCluster.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AttachedProxyConfig
	23, // 12: google.cloud.gkemulticloud.v1.AttachedCluster.binary_authorization:type_name -> google.cloud.gkemulticloud.v1.BinaryAuthorization
	24, // 13: google.cloud.gkemulticloud.v1.AttachedCluster.security_posture_config:type_name -> google.cloud.gkemulticloud.v1.SecurityPostureConfig
	17, // 14: google.cloud.gkemulticloud.v1.AttachedCluster.tags:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster.TagsEntry
	13, // 15: google.cloud.gkemulticloud.v1.AttachedCluster.system_components_config:type_name -> google.cloud.gkemulticloud.v1.SystemComponentsConfig
	5,  // 16: google.cloud.gkemulticloud.v1.AttachedClustersAuthorization.admin_users:type_name -> google.cloud.gkemulticloud.v1.AttachedClusterUser
	6,  // 17: google.cloud.gkemulticloud.v1.AttachedClustersAuthorization.admin_groups:type_name -> google.cloud.gkemulticloud.v1.AttachedClusterGroup
	9,  // 18: google.cloud.gkemulticloud.v1.AttachedServerConfig.valid_versions:type_name -> google.cloud.gkemulticloud.v1.AttachedPlatformVersionInfo
	25, // 19: google.cloud.gkemulticloud.v1.AttachedPlatformVersionInfo.end_of_life_date:type_name -> google.type.Date
	25, // 20: google.cloud.gkemulticloud.v1.AttachedPlatformVersionInfo.release_date:type_name -> google.type.Date
	12, // 21: google.cloud.gkemulticloud.v1.AttachedProxyConfig.kubernetes_secret:type_name -> google.cloud.gkemulticloud.v1.KubernetesSecret
	14, // 22: google.cloud.gkemulticloud.v1.SystemComponentsConfig.tolerations:type_name -> google.cloud.gkemulticloud.v1.Toleration
	15, // 23: google.cloud.gkemulticloud.v1.SystemComponentsConfig.labels:type_name -> google.cloud.gkemulticloud.v1.Label
	1,  // 24: google.cloud.gkemulticloud.v1.Toleration.key_operator:type_name -> google.cloud.gkemulticloud.v1.Toleration.KeyOperator
	2,  // 25: google.cloud.gkemulticloud.v1.Toleration.effect:type_name -> google.cloud.gkemulticloud.v1.Toleration.Effect
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_attached_resources_proto_init() }
func file_google_cloud_gkemulticloud_v1_attached_resources_proto_init() {
	if File_google_cloud_gkemulticloud_v1_attached_resources_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_attached_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_attached_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkemulticloud_v1_attached_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_attached_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_attached_resources_proto = out.File
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_depIdxs = nil
}
