// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/lifesciences/v2beta/workflows.proto

package lifesciencespb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WorkflowsServiceV2Beta_RunPipeline_FullMethodName = "/google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta/RunPipeline"
)

// WorkflowsServiceV2BetaClient is the client API for WorkflowsServiceV2Beta service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkflowsServiceV2BetaClient interface {
	// Runs a pipeline.  The returned Operation's [metadata]
	// [google.longrunning.Operation.metadata] field will contain a
	// [google.cloud.lifesciences.v2beta.Metadata][google.cloud.lifesciences.v2beta.Metadata]
	// object describing the status of the pipeline execution. The
	// [response][google.longrunning.Operation.response] field will contain a
	// [google.cloud.lifesciences.v2beta.RunPipelineResponse][google.cloud.lifesciences.v2beta.RunPipelineResponse]
	// object if the pipeline completes successfully.
	//
	// **Note:** Before you can use this method, the *Life Sciences Service Agent*
	// must have access to your project. This is done automatically when the
	// Cloud Life Sciences API is first enabled, but if you delete this permission
	// you must disable and re-enable the API to grant the Life Sciences
	// Service Agent the required permissions.
	// Authorization requires the following [Google
	// IAM](https://cloud.google.com/iam/) permission:
	//
	// * `lifesciences.workflows.run`
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type workflowsServiceV2BetaClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkflowsServiceV2BetaClient(cc grpc.ClientConnInterface) WorkflowsServiceV2BetaClient {
	return &workflowsServiceV2BetaClient{cc}
}

func (c *workflowsServiceV2BetaClient) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, WorkflowsServiceV2Beta_RunPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkflowsServiceV2BetaServer is the server API for WorkflowsServiceV2Beta service.
// All implementations should embed UnimplementedWorkflowsServiceV2BetaServer
// for forward compatibility
type WorkflowsServiceV2BetaServer interface {
	// Runs a pipeline.  The returned Operation's [metadata]
	// [google.longrunning.Operation.metadata] field will contain a
	// [google.cloud.lifesciences.v2beta.Metadata][google.cloud.lifesciences.v2beta.Metadata]
	// object describing the status of the pipeline execution. The
	// [response][google.longrunning.Operation.response] field will contain a
	// [google.cloud.lifesciences.v2beta.RunPipelineResponse][google.cloud.lifesciences.v2beta.RunPipelineResponse]
	// object if the pipeline completes successfully.
	//
	// **Note:** Before you can use this method, the *Life Sciences Service Agent*
	// must have access to your project. This is done automatically when the
	// Cloud Life Sciences API is first enabled, but if you delete this permission
	// you must disable and re-enable the API to grant the Life Sciences
	// Service Agent the required permissions.
	// Authorization requires the following [Google
	// IAM](https://cloud.google.com/iam/) permission:
	//
	// * `lifesciences.workflows.run`
	RunPipeline(context.Context, *RunPipelineRequest) (*longrunningpb.Operation, error)
}

// UnimplementedWorkflowsServiceV2BetaServer should be embedded to have forward compatible implementations.
type UnimplementedWorkflowsServiceV2BetaServer struct {
}

func (UnimplementedWorkflowsServiceV2BetaServer) RunPipeline(context.Context, *RunPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPipeline not implemented")
}

// UnsafeWorkflowsServiceV2BetaServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkflowsServiceV2BetaServer will
// result in compilation errors.
type UnsafeWorkflowsServiceV2BetaServer interface {
	mustEmbedUnimplementedWorkflowsServiceV2BetaServer()
}

func RegisterWorkflowsServiceV2BetaServer(s grpc.ServiceRegistrar, srv WorkflowsServiceV2BetaServer) {
	s.RegisterService(&WorkflowsServiceV2Beta_ServiceDesc, srv)
}

func _WorkflowsServiceV2Beta_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowsServiceV2BetaServer).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkflowsServiceV2Beta_RunPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowsServiceV2BetaServer).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WorkflowsServiceV2Beta_ServiceDesc is the grpc.ServiceDesc for WorkflowsServiceV2Beta service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WorkflowsServiceV2Beta_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta",
	HandlerType: (*WorkflowsServiceV2BetaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunPipeline",
			Handler:    _WorkflowsServiceV2Beta_RunPipeline_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/lifesciences/v2beta/workflows.proto",
}
