// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/metastore/v1/metastore_federation.proto

package metastorepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataprocMetastoreFederation_ListFederations_FullMethodName  = "/google.cloud.metastore.v1.DataprocMetastoreFederation/ListFederations"
	DataprocMetastoreFederation_GetFederation_FullMethodName    = "/google.cloud.metastore.v1.DataprocMetastoreFederation/GetFederation"
	DataprocMetastoreFederation_CreateFederation_FullMethodName = "/google.cloud.metastore.v1.DataprocMetastoreFederation/CreateFederation"
	DataprocMetastoreFederation_UpdateFederation_FullMethodName = "/google.cloud.metastore.v1.DataprocMetastoreFederation/UpdateFederation"
	DataprocMetastoreFederation_DeleteFederation_FullMethodName = "/google.cloud.metastore.v1.DataprocMetastoreFederation/DeleteFederation"
)

// DataprocMetastoreFederationClient is the client API for DataprocMetastoreFederation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataprocMetastoreFederationClient interface {
	// Lists federations in a project and location.
	ListFederations(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error)
	// Gets the details of a single federation.
	GetFederation(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error)
	// Creates a metastore federation in a project and location.
	CreateFederation(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the fields of a federation.
	UpdateFederation(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single federation.
	DeleteFederation(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type dataprocMetastoreFederationClient struct {
	cc grpc.ClientConnInterface
}

func NewDataprocMetastoreFederationClient(cc grpc.ClientConnInterface) DataprocMetastoreFederationClient {
	return &dataprocMetastoreFederationClient{cc}
}

func (c *dataprocMetastoreFederationClient) ListFederations(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error) {
	out := new(ListFederationsResponse)
	err := c.cc.Invoke(ctx, DataprocMetastoreFederation_ListFederations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) GetFederation(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error) {
	out := new(Federation)
	err := c.cc.Invoke(ctx, DataprocMetastoreFederation_GetFederation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) CreateFederation(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastoreFederation_CreateFederation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) UpdateFederation(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastoreFederation_UpdateFederation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) DeleteFederation(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastoreFederation_DeleteFederation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataprocMetastoreFederationServer is the server API for DataprocMetastoreFederation service.
// All implementations should embed UnimplementedDataprocMetastoreFederationServer
// for forward compatibility
type DataprocMetastoreFederationServer interface {
	// Lists federations in a project and location.
	ListFederations(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error)
	// Gets the details of a single federation.
	GetFederation(context.Context, *GetFederationRequest) (*Federation, error)
	// Creates a metastore federation in a project and location.
	CreateFederation(context.Context, *CreateFederationRequest) (*longrunningpb.Operation, error)
	// Updates the fields of a federation.
	UpdateFederation(context.Context, *UpdateFederationRequest) (*longrunningpb.Operation, error)
	// Deletes a single federation.
	DeleteFederation(context.Context, *DeleteFederationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDataprocMetastoreFederationServer should be embedded to have forward compatible implementations.
type UnimplementedDataprocMetastoreFederationServer struct {
}

func (UnimplementedDataprocMetastoreFederationServer) ListFederations(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFederations not implemented")
}
func (UnimplementedDataprocMetastoreFederationServer) GetFederation(context.Context, *GetFederationRequest) (*Federation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFederation not implemented")
}
func (UnimplementedDataprocMetastoreFederationServer) CreateFederation(context.Context, *CreateFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFederation not implemented")
}
func (UnimplementedDataprocMetastoreFederationServer) UpdateFederation(context.Context, *UpdateFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFederation not implemented")
}
func (UnimplementedDataprocMetastoreFederationServer) DeleteFederation(context.Context, *DeleteFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFederation not implemented")
}

// UnsafeDataprocMetastoreFederationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataprocMetastoreFederationServer will
// result in compilation errors.
type UnsafeDataprocMetastoreFederationServer interface {
	mustEmbedUnimplementedDataprocMetastoreFederationServer()
}

func RegisterDataprocMetastoreFederationServer(s grpc.ServiceRegistrar, srv DataprocMetastoreFederationServer) {
	s.RegisterService(&DataprocMetastoreFederation_ServiceDesc, srv)
}

func _DataprocMetastoreFederation_ListFederations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).ListFederations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastoreFederation_ListFederations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).ListFederations(ctx, req.(*ListFederationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_GetFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).GetFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastoreFederation_GetFederation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).GetFederation(ctx, req.(*GetFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_CreateFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).CreateFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastoreFederation_CreateFederation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).CreateFederation(ctx, req.(*CreateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_UpdateFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).UpdateFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastoreFederation_UpdateFederation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).UpdateFederation(ctx, req.(*UpdateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_DeleteFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).DeleteFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastoreFederation_DeleteFederation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).DeleteFederation(ctx, req.(*DeleteFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataprocMetastoreFederation_ServiceDesc is the grpc.ServiceDesc for DataprocMetastoreFederation service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataprocMetastoreFederation_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.metastore.v1.DataprocMetastoreFederation",
	HandlerType: (*DataprocMetastoreFederationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFederations",
			Handler:    _DataprocMetastoreFederation_ListFederations_Handler,
		},
		{
			MethodName: "GetFederation",
			Handler:    _DataprocMetastoreFederation_GetFederation_Handler,
		},
		{
			MethodName: "CreateFederation",
			Handler:    _DataprocMetastoreFederation_CreateFederation_Handler,
		},
		{
			MethodName: "UpdateFederation",
			Handler:    _DataprocMetastoreFederation_UpdateFederation_Handler,
		},
		{
			MethodName: "DeleteFederation",
			Handler:    _DataprocMetastoreFederation_DeleteFederation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/metastore/v1/metastore_federation.proto",
}
