// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

package metricsscopepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetricsScopes_GetMetricsScope_FullMethodName                     = "/google.monitoring.metricsscope.v1.MetricsScopes/GetMetricsScope"
	MetricsScopes_ListMetricsScopesByMonitoredProject_FullMethodName = "/google.monitoring.metricsscope.v1.MetricsScopes/ListMetricsScopesByMonitoredProject"
	MetricsScopes_CreateMonitoredProject_FullMethodName              = "/google.monitoring.metricsscope.v1.MetricsScopes/CreateMonitoredProject"
	MetricsScopes_DeleteMonitoredProject_FullMethodName              = "/google.monitoring.metricsscope.v1.MetricsScopes/DeleteMonitoredProject"
)

// MetricsScopesClient is the client API for MetricsScopes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetricsScopesClient interface {
	// Returns a specific `Metrics Scope`.
	GetMetricsScope(ctx context.Context, in *GetMetricsScopeRequest, opts ...grpc.CallOption) (*MetricsScope, error)
	// Returns a list of every `Metrics Scope` that a specific `MonitoredProject`
	// has been added to. The metrics scope representing the specified monitored
	// project will always be the first entry in the response.
	ListMetricsScopesByMonitoredProject(ctx context.Context, in *ListMetricsScopesByMonitoredProjectRequest, opts ...grpc.CallOption) (*ListMetricsScopesByMonitoredProjectResponse, error)
	// Adds a `MonitoredProject` with the given project ID
	// to the specified `Metrics Scope`.
	CreateMonitoredProject(ctx context.Context, in *CreateMonitoredProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `MonitoredProject` from the specified `Metrics Scope`.
	DeleteMonitoredProject(ctx context.Context, in *DeleteMonitoredProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type metricsScopesClient struct {
	cc grpc.ClientConnInterface
}

func NewMetricsScopesClient(cc grpc.ClientConnInterface) MetricsScopesClient {
	return &metricsScopesClient{cc}
}

func (c *metricsScopesClient) GetMetricsScope(ctx context.Context, in *GetMetricsScopeRequest, opts ...grpc.CallOption) (*MetricsScope, error) {
	out := new(MetricsScope)
	err := c.cc.Invoke(ctx, MetricsScopes_GetMetricsScope_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsScopesClient) ListMetricsScopesByMonitoredProject(ctx context.Context, in *ListMetricsScopesByMonitoredProjectRequest, opts ...grpc.CallOption) (*ListMetricsScopesByMonitoredProjectResponse, error) {
	out := new(ListMetricsScopesByMonitoredProjectResponse)
	err := c.cc.Invoke(ctx, MetricsScopes_ListMetricsScopesByMonitoredProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsScopesClient) CreateMonitoredProject(ctx context.Context, in *CreateMonitoredProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetricsScopes_CreateMonitoredProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsScopesClient) DeleteMonitoredProject(ctx context.Context, in *DeleteMonitoredProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetricsScopes_DeleteMonitoredProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricsScopesServer is the server API for MetricsScopes service.
// All implementations should embed UnimplementedMetricsScopesServer
// for forward compatibility
type MetricsScopesServer interface {
	// Returns a specific `Metrics Scope`.
	GetMetricsScope(context.Context, *GetMetricsScopeRequest) (*MetricsScope, error)
	// Returns a list of every `Metrics Scope` that a specific `MonitoredProject`
	// has been added to. The metrics scope representing the specified monitored
	// project will always be the first entry in the response.
	ListMetricsScopesByMonitoredProject(context.Context, *ListMetricsScopesByMonitoredProjectRequest) (*ListMetricsScopesByMonitoredProjectResponse, error)
	// Adds a `MonitoredProject` with the given project ID
	// to the specified `Metrics Scope`.
	CreateMonitoredProject(context.Context, *CreateMonitoredProjectRequest) (*longrunningpb.Operation, error)
	// Deletes a `MonitoredProject` from the specified `Metrics Scope`.
	DeleteMonitoredProject(context.Context, *DeleteMonitoredProjectRequest) (*longrunningpb.Operation, error)
}

// UnimplementedMetricsScopesServer should be embedded to have forward compatible implementations.
type UnimplementedMetricsScopesServer struct {
}

func (UnimplementedMetricsScopesServer) GetMetricsScope(context.Context, *GetMetricsScopeRequest) (*MetricsScope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetricsScope not implemented")
}
func (UnimplementedMetricsScopesServer) ListMetricsScopesByMonitoredProject(context.Context, *ListMetricsScopesByMonitoredProjectRequest) (*ListMetricsScopesByMonitoredProjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetricsScopesByMonitoredProject not implemented")
}
func (UnimplementedMetricsScopesServer) CreateMonitoredProject(context.Context, *CreateMonitoredProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMonitoredProject not implemented")
}
func (UnimplementedMetricsScopesServer) DeleteMonitoredProject(context.Context, *DeleteMonitoredProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMonitoredProject not implemented")
}

// UnsafeMetricsScopesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetricsScopesServer will
// result in compilation errors.
type UnsafeMetricsScopesServer interface {
	mustEmbedUnimplementedMetricsScopesServer()
}

func RegisterMetricsScopesServer(s grpc.ServiceRegistrar, srv MetricsScopesServer) {
	s.RegisterService(&MetricsScopes_ServiceDesc, srv)
}

func _MetricsScopes_GetMetricsScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricsScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsScopesServer).GetMetricsScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsScopes_GetMetricsScope_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsScopesServer).GetMetricsScope(ctx, req.(*GetMetricsScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsScopes_ListMetricsScopesByMonitoredProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetricsScopesByMonitoredProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsScopesServer).ListMetricsScopesByMonitoredProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsScopes_ListMetricsScopesByMonitoredProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsScopesServer).ListMetricsScopesByMonitoredProject(ctx, req.(*ListMetricsScopesByMonitoredProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsScopes_CreateMonitoredProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMonitoredProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsScopesServer).CreateMonitoredProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsScopes_CreateMonitoredProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsScopesServer).CreateMonitoredProject(ctx, req.(*CreateMonitoredProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsScopes_DeleteMonitoredProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMonitoredProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsScopesServer).DeleteMonitoredProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsScopes_DeleteMonitoredProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsScopesServer).DeleteMonitoredProject(ctx, req.(*DeleteMonitoredProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetricsScopes_ServiceDesc is the grpc.ServiceDesc for MetricsScopes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetricsScopes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.metricsscope.v1.MetricsScopes",
	HandlerType: (*MetricsScopesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMetricsScope",
			Handler:    _MetricsScopes_GetMetricsScope_Handler,
		},
		{
			MethodName: "ListMetricsScopesByMonitoredProject",
			Handler:    _MetricsScopes_ListMetricsScopesByMonitoredProject_Handler,
		},
		{
			MethodName: "CreateMonitoredProject",
			Handler:    _MetricsScopes_CreateMonitoredProject_Handler,
		},
		{
			MethodName: "DeleteMonitoredProject",
			Handler:    _MetricsScopes_DeleteMonitoredProject_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/metricsscope/v1/metrics_scopes.proto",
}
