// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

package orgpolicypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	OrgPolicy_ListConstraints_FullMethodName        = "/google.cloud.orgpolicy.v2.OrgPolicy/ListConstraints"
	OrgPolicy_ListPolicies_FullMethodName           = "/google.cloud.orgpolicy.v2.OrgPolicy/ListPolicies"
	OrgPolicy_GetPolicy_FullMethodName              = "/google.cloud.orgpolicy.v2.OrgPolicy/GetPolicy"
	OrgPolicy_GetEffectivePolicy_FullMethodName     = "/google.cloud.orgpolicy.v2.OrgPolicy/GetEffectivePolicy"
	OrgPolicy_CreatePolicy_FullMethodName           = "/google.cloud.orgpolicy.v2.OrgPolicy/CreatePolicy"
	OrgPolicy_UpdatePolicy_FullMethodName           = "/google.cloud.orgpolicy.v2.OrgPolicy/UpdatePolicy"
	OrgPolicy_DeletePolicy_FullMethodName           = "/google.cloud.orgpolicy.v2.OrgPolicy/DeletePolicy"
	OrgPolicy_CreateCustomConstraint_FullMethodName = "/google.cloud.orgpolicy.v2.OrgPolicy/CreateCustomConstraint"
	OrgPolicy_UpdateCustomConstraint_FullMethodName = "/google.cloud.orgpolicy.v2.OrgPolicy/UpdateCustomConstraint"
	OrgPolicy_GetCustomConstraint_FullMethodName    = "/google.cloud.orgpolicy.v2.OrgPolicy/GetCustomConstraint"
	OrgPolicy_ListCustomConstraints_FullMethodName  = "/google.cloud.orgpolicy.v2.OrgPolicy/ListCustomConstraints"
	OrgPolicy_DeleteCustomConstraint_FullMethodName = "/google.cloud.orgpolicy.v2.OrgPolicy/DeleteCustomConstraint"
)

// OrgPolicyClient is the client API for OrgPolicy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OrgPolicyClient interface {
	// Lists constraints that could be applied on the specified resource.
	ListConstraints(ctx context.Context, in *ListConstraintsRequest, opts ...grpc.CallOption) (*ListConstraintsResponse, error)
	// Retrieves all of the policies that exist on a particular resource.
	ListPolicies(ctx context.Context, in *ListPoliciesRequest, opts ...grpc.CallOption) (*ListPoliciesResponse, error)
	// Gets a policy on a resource.
	//
	// If no policy is set on the resource, `NOT_FOUND` is returned. The
	// `etag` value can be used with `UpdatePolicy()` to update a
	// policy during read-modify-write.
	GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Gets the effective policy on a resource. This is the result of merging
	// policies in the resource hierarchy and evaluating conditions. The
	// returned policy will not have an `etag` or `condition` set because it is
	// an evaluated policy across multiple resources.
	// Subtrees of Resource Manager resource hierarchy with 'under:' prefix will
	// not be expanded.
	GetEffectivePolicy(ctx context.Context, in *GetEffectivePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// policy already exists on the given Google Cloud resource.
	CreatePolicy(ctx context.Context, in *CreatePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Updates a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint or the policy do not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the policy
	//
	// Note: the supplied policy will perform a full overwrite of all
	// fields.
	UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Deletes a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint or organization policy does not exist.
	DeletePolicy(ctx context.Context, in *DeletePolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// organization does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// constraint already exists on the given organization.
	CreateCustomConstraint(ctx context.Context, in *CreateCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error)
	// Updates a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	//
	// Note: the supplied policy will perform a full overwrite of all
	// fields.
	UpdateCustomConstraint(ctx context.Context, in *UpdateCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error)
	// Gets a custom or managed constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// custom or managed constraint does not exist.
	GetCustomConstraint(ctx context.Context, in *GetCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error)
	// Retrieves all of the custom constraints that exist on a particular
	// organization resource.
	ListCustomConstraints(ctx context.Context, in *ListCustomConstraintsRequest, opts ...grpc.CallOption) (*ListCustomConstraintsResponse, error)
	// Deletes a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	DeleteCustomConstraint(ctx context.Context, in *DeleteCustomConstraintRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type orgPolicyClient struct {
	cc grpc.ClientConnInterface
}

func NewOrgPolicyClient(cc grpc.ClientConnInterface) OrgPolicyClient {
	return &orgPolicyClient{cc}
}

func (c *orgPolicyClient) ListConstraints(ctx context.Context, in *ListConstraintsRequest, opts ...grpc.CallOption) (*ListConstraintsResponse, error) {
	out := new(ListConstraintsResponse)
	err := c.cc.Invoke(ctx, OrgPolicy_ListConstraints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) ListPolicies(ctx context.Context, in *ListPoliciesRequest, opts ...grpc.CallOption) (*ListPoliciesResponse, error) {
	out := new(ListPoliciesResponse)
	err := c.cc.Invoke(ctx, OrgPolicy_ListPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, OrgPolicy_GetPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) GetEffectivePolicy(ctx context.Context, in *GetEffectivePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, OrgPolicy_GetEffectivePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) CreatePolicy(ctx context.Context, in *CreatePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, OrgPolicy_CreatePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, OrgPolicy_UpdatePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) DeletePolicy(ctx context.Context, in *DeletePolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, OrgPolicy_DeletePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) CreateCustomConstraint(ctx context.Context, in *CreateCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error) {
	out := new(CustomConstraint)
	err := c.cc.Invoke(ctx, OrgPolicy_CreateCustomConstraint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) UpdateCustomConstraint(ctx context.Context, in *UpdateCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error) {
	out := new(CustomConstraint)
	err := c.cc.Invoke(ctx, OrgPolicy_UpdateCustomConstraint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) GetCustomConstraint(ctx context.Context, in *GetCustomConstraintRequest, opts ...grpc.CallOption) (*CustomConstraint, error) {
	out := new(CustomConstraint)
	err := c.cc.Invoke(ctx, OrgPolicy_GetCustomConstraint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) ListCustomConstraints(ctx context.Context, in *ListCustomConstraintsRequest, opts ...grpc.CallOption) (*ListCustomConstraintsResponse, error) {
	out := new(ListCustomConstraintsResponse)
	err := c.cc.Invoke(ctx, OrgPolicy_ListCustomConstraints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *orgPolicyClient) DeleteCustomConstraint(ctx context.Context, in *DeleteCustomConstraintRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, OrgPolicy_DeleteCustomConstraint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OrgPolicyServer is the server API for OrgPolicy service.
// All implementations should embed UnimplementedOrgPolicyServer
// for forward compatibility
type OrgPolicyServer interface {
	// Lists constraints that could be applied on the specified resource.
	ListConstraints(context.Context, *ListConstraintsRequest) (*ListConstraintsResponse, error)
	// Retrieves all of the policies that exist on a particular resource.
	ListPolicies(context.Context, *ListPoliciesRequest) (*ListPoliciesResponse, error)
	// Gets a policy on a resource.
	//
	// If no policy is set on the resource, `NOT_FOUND` is returned. The
	// `etag` value can be used with `UpdatePolicy()` to update a
	// policy during read-modify-write.
	GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error)
	// Gets the effective policy on a resource. This is the result of merging
	// policies in the resource hierarchy and evaluating conditions. The
	// returned policy will not have an `etag` or `condition` set because it is
	// an evaluated policy across multiple resources.
	// Subtrees of Resource Manager resource hierarchy with 'under:' prefix will
	// not be expanded.
	GetEffectivePolicy(context.Context, *GetEffectivePolicyRequest) (*Policy, error)
	// Creates a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// policy already exists on the given Google Cloud resource.
	CreatePolicy(context.Context, *CreatePolicyRequest) (*Policy, error)
	// Updates a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint or the policy do not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the policy
	//
	// Note: the supplied policy will perform a full overwrite of all
	// fields.
	UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error)
	// Deletes a policy.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint or organization policy does not exist.
	DeletePolicy(context.Context, *DeletePolicyRequest) (*emptypb.Empty, error)
	// Creates a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// organization does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// constraint already exists on the given organization.
	CreateCustomConstraint(context.Context, *CreateCustomConstraintRequest) (*CustomConstraint, error)
	// Updates a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	//
	// Note: the supplied policy will perform a full overwrite of all
	// fields.
	UpdateCustomConstraint(context.Context, *UpdateCustomConstraintRequest) (*CustomConstraint, error)
	// Gets a custom or managed constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// custom or managed constraint does not exist.
	GetCustomConstraint(context.Context, *GetCustomConstraintRequest) (*CustomConstraint, error)
	// Retrieves all of the custom constraints that exist on a particular
	// organization resource.
	ListCustomConstraints(context.Context, *ListCustomConstraintsRequest) (*ListCustomConstraintsResponse, error)
	// Deletes a custom constraint.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// constraint does not exist.
	DeleteCustomConstraint(context.Context, *DeleteCustomConstraintRequest) (*emptypb.Empty, error)
}

// UnimplementedOrgPolicyServer should be embedded to have forward compatible implementations.
type UnimplementedOrgPolicyServer struct {
}

func (UnimplementedOrgPolicyServer) ListConstraints(context.Context, *ListConstraintsRequest) (*ListConstraintsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConstraints not implemented")
}
func (UnimplementedOrgPolicyServer) ListPolicies(context.Context, *ListPoliciesRequest) (*ListPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicies not implemented")
}
func (UnimplementedOrgPolicyServer) GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicy not implemented")
}
func (UnimplementedOrgPolicyServer) GetEffectivePolicy(context.Context, *GetEffectivePolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectivePolicy not implemented")
}
func (UnimplementedOrgPolicyServer) CreatePolicy(context.Context, *CreatePolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicy not implemented")
}
func (UnimplementedOrgPolicyServer) UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicy not implemented")
}
func (UnimplementedOrgPolicyServer) DeletePolicy(context.Context, *DeletePolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicy not implemented")
}
func (UnimplementedOrgPolicyServer) CreateCustomConstraint(context.Context, *CreateCustomConstraintRequest) (*CustomConstraint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomConstraint not implemented")
}
func (UnimplementedOrgPolicyServer) UpdateCustomConstraint(context.Context, *UpdateCustomConstraintRequest) (*CustomConstraint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomConstraint not implemented")
}
func (UnimplementedOrgPolicyServer) GetCustomConstraint(context.Context, *GetCustomConstraintRequest) (*CustomConstraint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomConstraint not implemented")
}
func (UnimplementedOrgPolicyServer) ListCustomConstraints(context.Context, *ListCustomConstraintsRequest) (*ListCustomConstraintsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomConstraints not implemented")
}
func (UnimplementedOrgPolicyServer) DeleteCustomConstraint(context.Context, *DeleteCustomConstraintRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomConstraint not implemented")
}

// UnsafeOrgPolicyServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OrgPolicyServer will
// result in compilation errors.
type UnsafeOrgPolicyServer interface {
	mustEmbedUnimplementedOrgPolicyServer()
}

func RegisterOrgPolicyServer(s grpc.ServiceRegistrar, srv OrgPolicyServer) {
	s.RegisterService(&OrgPolicy_ServiceDesc, srv)
}

func _OrgPolicy_ListConstraints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConstraintsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).ListConstraints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_ListConstraints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).ListConstraints(ctx, req.(*ListConstraintsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_ListPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).ListPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_ListPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).ListPolicies(ctx, req.(*ListPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_GetPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).GetPolicy(ctx, req.(*GetPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_GetEffectivePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectivePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).GetEffectivePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_GetEffectivePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).GetEffectivePolicy(ctx, req.(*GetEffectivePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_CreatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).CreatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_CreatePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).CreatePolicy(ctx, req.(*CreatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_UpdatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).UpdatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_UpdatePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).UpdatePolicy(ctx, req.(*UpdatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_DeletePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).DeletePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_DeletePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).DeletePolicy(ctx, req.(*DeletePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_CreateCustomConstraint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomConstraintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).CreateCustomConstraint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_CreateCustomConstraint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).CreateCustomConstraint(ctx, req.(*CreateCustomConstraintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_UpdateCustomConstraint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomConstraintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).UpdateCustomConstraint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_UpdateCustomConstraint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).UpdateCustomConstraint(ctx, req.(*UpdateCustomConstraintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_GetCustomConstraint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomConstraintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).GetCustomConstraint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_GetCustomConstraint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).GetCustomConstraint(ctx, req.(*GetCustomConstraintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_ListCustomConstraints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomConstraintsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).ListCustomConstraints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_ListCustomConstraints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).ListCustomConstraints(ctx, req.(*ListCustomConstraintsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrgPolicy_DeleteCustomConstraint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomConstraintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrgPolicyServer).DeleteCustomConstraint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrgPolicy_DeleteCustomConstraint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrgPolicyServer).DeleteCustomConstraint(ctx, req.(*DeleteCustomConstraintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OrgPolicy_ServiceDesc is the grpc.ServiceDesc for OrgPolicy service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OrgPolicy_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.orgpolicy.v2.OrgPolicy",
	HandlerType: (*OrgPolicyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConstraints",
			Handler:    _OrgPolicy_ListConstraints_Handler,
		},
		{
			MethodName: "ListPolicies",
			Handler:    _OrgPolicy_ListPolicies_Handler,
		},
		{
			MethodName: "GetPolicy",
			Handler:    _OrgPolicy_GetPolicy_Handler,
		},
		{
			MethodName: "GetEffectivePolicy",
			Handler:    _OrgPolicy_GetEffectivePolicy_Handler,
		},
		{
			MethodName: "CreatePolicy",
			Handler:    _OrgPolicy_CreatePolicy_Handler,
		},
		{
			MethodName: "UpdatePolicy",
			Handler:    _OrgPolicy_UpdatePolicy_Handler,
		},
		{
			MethodName: "DeletePolicy",
			Handler:    _OrgPolicy_DeletePolicy_Handler,
		},
		{
			MethodName: "CreateCustomConstraint",
			Handler:    _OrgPolicy_CreateCustomConstraint_Handler,
		},
		{
			MethodName: "UpdateCustomConstraint",
			Handler:    _OrgPolicy_UpdateCustomConstraint_Handler,
		},
		{
			MethodName: "GetCustomConstraint",
			Handler:    _OrgPolicy_GetCustomConstraint_Handler,
		},
		{
			MethodName: "ListCustomConstraints",
			Handler:    _OrgPolicy_ListCustomConstraints_Handler,
		},
		{
			MethodName: "DeleteCustomConstraint",
			Handler:    _OrgPolicy_DeleteCustomConstraint_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/orgpolicy/v2/orgpolicy.proto",
}
