// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

package stitcherpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VideoStitcherService_CreateCdnKey_FullMethodName         = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateCdnKey"
	VideoStitcherService_ListCdnKeys_FullMethodName          = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListCdnKeys"
	VideoStitcherService_GetCdnKey_FullMethodName            = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetCdnKey"
	VideoStitcherService_DeleteCdnKey_FullMethodName         = "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteCdnKey"
	VideoStitcherService_UpdateCdnKey_FullMethodName         = "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateCdnKey"
	VideoStitcherService_CreateVodSession_FullMethodName     = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodSession"
	VideoStitcherService_GetVodSession_FullMethodName        = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodSession"
	VideoStitcherService_ListVodStitchDetails_FullMethodName = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodStitchDetails"
	VideoStitcherService_GetVodStitchDetail_FullMethodName   = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodStitchDetail"
	VideoStitcherService_ListVodAdTagDetails_FullMethodName  = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodAdTagDetails"
	VideoStitcherService_GetVodAdTagDetail_FullMethodName    = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodAdTagDetail"
	VideoStitcherService_ListLiveAdTagDetails_FullMethodName = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveAdTagDetails"
	VideoStitcherService_GetLiveAdTagDetail_FullMethodName   = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveAdTagDetail"
	VideoStitcherService_CreateSlate_FullMethodName          = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateSlate"
	VideoStitcherService_ListSlates_FullMethodName           = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListSlates"
	VideoStitcherService_GetSlate_FullMethodName             = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetSlate"
	VideoStitcherService_UpdateSlate_FullMethodName          = "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateSlate"
	VideoStitcherService_DeleteSlate_FullMethodName          = "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteSlate"
	VideoStitcherService_CreateLiveSession_FullMethodName    = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveSession"
	VideoStitcherService_GetLiveSession_FullMethodName       = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveSession"
	VideoStitcherService_CreateLiveConfig_FullMethodName     = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveConfig"
	VideoStitcherService_ListLiveConfigs_FullMethodName      = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveConfigs"
	VideoStitcherService_GetLiveConfig_FullMethodName        = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveConfig"
	VideoStitcherService_DeleteLiveConfig_FullMethodName     = "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteLiveConfig"
	VideoStitcherService_UpdateLiveConfig_FullMethodName     = "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateLiveConfig"
	VideoStitcherService_CreateVodConfig_FullMethodName      = "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodConfig"
	VideoStitcherService_ListVodConfigs_FullMethodName       = "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodConfigs"
	VideoStitcherService_GetVodConfig_FullMethodName         = "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodConfig"
	VideoStitcherService_DeleteVodConfig_FullMethodName      = "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteVodConfig"
	VideoStitcherService_UpdateVodConfig_FullMethodName      = "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateVodConfig"
)

// VideoStitcherServiceClient is the client API for VideoStitcherService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VideoStitcherServiceClient interface {
	// Creates a new CDN key.
	CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all slates in the specified project and location.
	ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified slate.
	DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new live session.
	CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
	// Registers the live config with the provided unique ID in
	// the specified region.
	CreateLiveConfig(ctx context.Context, in *CreateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all live configs managed by the Video Stitcher that
	// belong to the specified project and region.
	ListLiveConfigs(ctx context.Context, in *ListLiveConfigsRequest, opts ...grpc.CallOption) (*ListLiveConfigsResponse, error)
	// Returns the specified live config managed by the Video
	// Stitcher service.
	GetLiveConfig(ctx context.Context, in *GetLiveConfigRequest, opts ...grpc.CallOption) (*LiveConfig, error)
	// Deletes the specified live config.
	DeleteLiveConfig(ctx context.Context, in *DeleteLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified LiveConfig. Only update fields specified
	// in the call method body.
	UpdateLiveConfig(ctx context.Context, in *UpdateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Registers the VOD config with the provided unique ID in
	// the specified region.
	CreateVodConfig(ctx context.Context, in *CreateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all VOD configs managed by the Video Stitcher API that
	// belong to the specified project and region.
	ListVodConfigs(ctx context.Context, in *ListVodConfigsRequest, opts ...grpc.CallOption) (*ListVodConfigsResponse, error)
	// Returns the specified VOD config managed by the Video
	// Stitcher API service.
	GetVodConfig(ctx context.Context, in *GetVodConfigRequest, opts ...grpc.CallOption) (*VodConfig, error)
	// Deletes the specified VOD config.
	DeleteVodConfig(ctx context.Context, in *DeleteVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified VOD config. Only update fields specified
	// in the call method body.
	UpdateVodConfig(ctx context.Context, in *UpdateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type videoStitcherServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoStitcherServiceClient(cc grpc.ClientConnInterface) VideoStitcherServiceClient {
	return &videoStitcherServiceClient{cc}
}

func (c *videoStitcherServiceClient) CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateCdnKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error) {
	out := new(ListCdnKeysResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListCdnKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error) {
	out := new(CdnKey)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetCdnKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_DeleteCdnKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_UpdateCdnKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateVodSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetVodSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error) {
	out := new(ListVodStitchDetailsResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListVodStitchDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error) {
	out := new(VodStitchDetail)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetVodStitchDetail_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error) {
	out := new(ListVodAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListVodAdTagDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error) {
	out := new(VodAdTagDetail)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetVodAdTagDetail_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error) {
	out := new(ListLiveAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListLiveAdTagDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error) {
	out := new(LiveAdTagDetail)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetLiveAdTagDetail_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateSlate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error) {
	out := new(ListSlatesResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListSlates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error) {
	out := new(Slate)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetSlate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_UpdateSlate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_DeleteSlate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateLiveSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetLiveSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateLiveConfig(ctx context.Context, in *CreateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateLiveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListLiveConfigs(ctx context.Context, in *ListLiveConfigsRequest, opts ...grpc.CallOption) (*ListLiveConfigsResponse, error) {
	out := new(ListLiveConfigsResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListLiveConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveConfig(ctx context.Context, in *GetLiveConfigRequest, opts ...grpc.CallOption) (*LiveConfig, error) {
	out := new(LiveConfig)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetLiveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteLiveConfig(ctx context.Context, in *DeleteLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_DeleteLiveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateLiveConfig(ctx context.Context, in *UpdateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_UpdateLiveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateVodConfig(ctx context.Context, in *CreateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_CreateVodConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodConfigs(ctx context.Context, in *ListVodConfigsRequest, opts ...grpc.CallOption) (*ListVodConfigsResponse, error) {
	out := new(ListVodConfigsResponse)
	err := c.cc.Invoke(ctx, VideoStitcherService_ListVodConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodConfig(ctx context.Context, in *GetVodConfigRequest, opts ...grpc.CallOption) (*VodConfig, error) {
	out := new(VodConfig)
	err := c.cc.Invoke(ctx, VideoStitcherService_GetVodConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteVodConfig(ctx context.Context, in *DeleteVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_DeleteVodConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateVodConfig(ctx context.Context, in *UpdateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VideoStitcherService_UpdateVodConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoStitcherServiceServer is the server API for VideoStitcherService service.
// All implementations should embed UnimplementedVideoStitcherServiceServer
// for forward compatibility
type VideoStitcherServiceServer interface {
	// Creates a new CDN key.
	CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*longrunningpb.Operation, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*longrunningpb.Operation, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*longrunningpb.Operation, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(context.Context, *CreateSlateRequest) (*longrunningpb.Operation, error)
	// Lists all slates in the specified project and location.
	ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(context.Context, *GetSlateRequest) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(context.Context, *UpdateSlateRequest) (*longrunningpb.Operation, error)
	// Deletes the specified slate.
	DeleteSlate(context.Context, *DeleteSlateRequest) (*longrunningpb.Operation, error)
	// Creates a new live session.
	CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error)
	// Registers the live config with the provided unique ID in
	// the specified region.
	CreateLiveConfig(context.Context, *CreateLiveConfigRequest) (*longrunningpb.Operation, error)
	// Lists all live configs managed by the Video Stitcher that
	// belong to the specified project and region.
	ListLiveConfigs(context.Context, *ListLiveConfigsRequest) (*ListLiveConfigsResponse, error)
	// Returns the specified live config managed by the Video
	// Stitcher service.
	GetLiveConfig(context.Context, *GetLiveConfigRequest) (*LiveConfig, error)
	// Deletes the specified live config.
	DeleteLiveConfig(context.Context, *DeleteLiveConfigRequest) (*longrunningpb.Operation, error)
	// Updates the specified LiveConfig. Only update fields specified
	// in the call method body.
	UpdateLiveConfig(context.Context, *UpdateLiveConfigRequest) (*longrunningpb.Operation, error)
	// Registers the VOD config with the provided unique ID in
	// the specified region.
	CreateVodConfig(context.Context, *CreateVodConfigRequest) (*longrunningpb.Operation, error)
	// Lists all VOD configs managed by the Video Stitcher API that
	// belong to the specified project and region.
	ListVodConfigs(context.Context, *ListVodConfigsRequest) (*ListVodConfigsResponse, error)
	// Returns the specified VOD config managed by the Video
	// Stitcher API service.
	GetVodConfig(context.Context, *GetVodConfigRequest) (*VodConfig, error)
	// Deletes the specified VOD config.
	DeleteVodConfig(context.Context, *DeleteVodConfigRequest) (*longrunningpb.Operation, error)
	// Updates the specified VOD config. Only update fields specified
	// in the call method body.
	UpdateVodConfig(context.Context, *UpdateVodConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVideoStitcherServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVideoStitcherServiceServer struct {
}

func (UnimplementedVideoStitcherServiceServer) CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCdnKey not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCdnKeys not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCdnKey not implemented")
}
func (UnimplementedVideoStitcherServiceServer) DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCdnKey not implemented")
}
func (UnimplementedVideoStitcherServiceServer) UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCdnKey not implemented")
}
func (UnimplementedVideoStitcherServiceServer) CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVodSession not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodSession not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodStitchDetails not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodStitchDetail not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodAdTagDetails not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodAdTagDetail not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLiveAdTagDetails not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveAdTagDetail not implemented")
}
func (UnimplementedVideoStitcherServiceServer) CreateSlate(context.Context, *CreateSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSlate not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSlates not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetSlate(context.Context, *GetSlateRequest) (*Slate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSlate not implemented")
}
func (UnimplementedVideoStitcherServiceServer) UpdateSlate(context.Context, *UpdateSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSlate not implemented")
}
func (UnimplementedVideoStitcherServiceServer) DeleteSlate(context.Context, *DeleteSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSlate not implemented")
}
func (UnimplementedVideoStitcherServiceServer) CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLiveSession not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveSession not implemented")
}
func (UnimplementedVideoStitcherServiceServer) CreateLiveConfig(context.Context, *CreateLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLiveConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListLiveConfigs(context.Context, *ListLiveConfigsRequest) (*ListLiveConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLiveConfigs not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetLiveConfig(context.Context, *GetLiveConfigRequest) (*LiveConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) DeleteLiveConfig(context.Context, *DeleteLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLiveConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) UpdateLiveConfig(context.Context, *UpdateLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLiveConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) CreateVodConfig(context.Context, *CreateVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVodConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) ListVodConfigs(context.Context, *ListVodConfigsRequest) (*ListVodConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodConfigs not implemented")
}
func (UnimplementedVideoStitcherServiceServer) GetVodConfig(context.Context, *GetVodConfigRequest) (*VodConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) DeleteVodConfig(context.Context, *DeleteVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVodConfig not implemented")
}
func (UnimplementedVideoStitcherServiceServer) UpdateVodConfig(context.Context, *UpdateVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVodConfig not implemented")
}

// UnsafeVideoStitcherServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VideoStitcherServiceServer will
// result in compilation errors.
type UnsafeVideoStitcherServiceServer interface {
	mustEmbedUnimplementedVideoStitcherServiceServer()
}

func RegisterVideoStitcherServiceServer(s grpc.ServiceRegistrar, srv VideoStitcherServiceServer) {
	s.RegisterService(&VideoStitcherService_ServiceDesc, srv)
}

func _VideoStitcherService_CreateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateCdnKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, req.(*CreateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListCdnKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCdnKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListCdnKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, req.(*ListCdnKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetCdnKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, req.(*GetCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_DeleteCdnKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, req.(*DeleteCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_UpdateCdnKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, req.(*UpdateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateVodSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, req.(*CreateVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetVodSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, req.(*GetVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodStitchDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodStitchDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListVodStitchDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, req.(*ListVodStitchDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodStitchDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodStitchDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetVodStitchDetail_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, req.(*GetVodStitchDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListVodAdTagDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, req.(*ListVodAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetVodAdTagDetail_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, req.(*GetVodAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListLiveAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLiveAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListLiveAdTagDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, req.(*ListLiveAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetLiveAdTagDetail_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, req.(*GetLiveAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateSlate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, req.(*CreateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListSlates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSlatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListSlates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, req.(*ListSlatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetSlate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, req.(*GetSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_UpdateSlate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, req.(*UpdateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_DeleteSlate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, req.(*DeleteSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateLiveSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, req.(*CreateLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetLiveSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, req.(*GetLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateLiveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateLiveConfig(ctx, req.(*CreateLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListLiveConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLiveConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListLiveConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListLiveConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListLiveConfigs(ctx, req.(*ListLiveConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetLiveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveConfig(ctx, req.(*GetLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_DeleteLiveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteLiveConfig(ctx, req.(*DeleteLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_UpdateLiveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateLiveConfig(ctx, req.(*UpdateLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_CreateVodConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateVodConfig(ctx, req.(*CreateVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_ListVodConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodConfigs(ctx, req.(*ListVodConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_GetVodConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodConfig(ctx, req.(*GetVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_DeleteVodConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteVodConfig(ctx, req.(*DeleteVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoStitcherService_UpdateVodConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateVodConfig(ctx, req.(*UpdateVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VideoStitcherService_ServiceDesc is the grpc.ServiceDesc for VideoStitcherService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VideoStitcherService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.video.stitcher.v1.VideoStitcherService",
	HandlerType: (*VideoStitcherServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCdnKey",
			Handler:    _VideoStitcherService_CreateCdnKey_Handler,
		},
		{
			MethodName: "ListCdnKeys",
			Handler:    _VideoStitcherService_ListCdnKeys_Handler,
		},
		{
			MethodName: "GetCdnKey",
			Handler:    _VideoStitcherService_GetCdnKey_Handler,
		},
		{
			MethodName: "DeleteCdnKey",
			Handler:    _VideoStitcherService_DeleteCdnKey_Handler,
		},
		{
			MethodName: "UpdateCdnKey",
			Handler:    _VideoStitcherService_UpdateCdnKey_Handler,
		},
		{
			MethodName: "CreateVodSession",
			Handler:    _VideoStitcherService_CreateVodSession_Handler,
		},
		{
			MethodName: "GetVodSession",
			Handler:    _VideoStitcherService_GetVodSession_Handler,
		},
		{
			MethodName: "ListVodStitchDetails",
			Handler:    _VideoStitcherService_ListVodStitchDetails_Handler,
		},
		{
			MethodName: "GetVodStitchDetail",
			Handler:    _VideoStitcherService_GetVodStitchDetail_Handler,
		},
		{
			MethodName: "ListVodAdTagDetails",
			Handler:    _VideoStitcherService_ListVodAdTagDetails_Handler,
		},
		{
			MethodName: "GetVodAdTagDetail",
			Handler:    _VideoStitcherService_GetVodAdTagDetail_Handler,
		},
		{
			MethodName: "ListLiveAdTagDetails",
			Handler:    _VideoStitcherService_ListLiveAdTagDetails_Handler,
		},
		{
			MethodName: "GetLiveAdTagDetail",
			Handler:    _VideoStitcherService_GetLiveAdTagDetail_Handler,
		},
		{
			MethodName: "CreateSlate",
			Handler:    _VideoStitcherService_CreateSlate_Handler,
		},
		{
			MethodName: "ListSlates",
			Handler:    _VideoStitcherService_ListSlates_Handler,
		},
		{
			MethodName: "GetSlate",
			Handler:    _VideoStitcherService_GetSlate_Handler,
		},
		{
			MethodName: "UpdateSlate",
			Handler:    _VideoStitcherService_UpdateSlate_Handler,
		},
		{
			MethodName: "DeleteSlate",
			Handler:    _VideoStitcherService_DeleteSlate_Handler,
		},
		{
			MethodName: "CreateLiveSession",
			Handler:    _VideoStitcherService_CreateLiveSession_Handler,
		},
		{
			MethodName: "GetLiveSession",
			Handler:    _VideoStitcherService_GetLiveSession_Handler,
		},
		{
			MethodName: "CreateLiveConfig",
			Handler:    _VideoStitcherService_CreateLiveConfig_Handler,
		},
		{
			MethodName: "ListLiveConfigs",
			Handler:    _VideoStitcherService_ListLiveConfigs_Handler,
		},
		{
			MethodName: "GetLiveConfig",
			Handler:    _VideoStitcherService_GetLiveConfig_Handler,
		},
		{
			MethodName: "DeleteLiveConfig",
			Handler:    _VideoStitcherService_DeleteLiveConfig_Handler,
		},
		{
			MethodName: "UpdateLiveConfig",
			Handler:    _VideoStitcherService_UpdateLiveConfig_Handler,
		},
		{
			MethodName: "CreateVodConfig",
			Handler:    _VideoStitcherService_CreateVodConfig_Handler,
		},
		{
			MethodName: "ListVodConfigs",
			Handler:    _VideoStitcherService_ListVodConfigs_Handler,
		},
		{
			MethodName: "GetVodConfig",
			Handler:    _VideoStitcherService_GetVodConfig_Handler,
		},
		{
			MethodName: "DeleteVodConfig",
			Handler:    _VideoStitcherService_DeleteVodConfig_Handler,
		},
		{
			MethodName: "UpdateVodConfig",
			Handler:    _VideoStitcherService_UpdateVodConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/video/stitcher/v1/video_stitcher_service.proto",
}
