// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package securityposture provides access to the Security Posture API.
//
// For product documentation, see: https://cloud.google.com/security-command-center
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/securityposture/v1"
//	...
//	ctx := context.Background()
//	securitypostureService, err := securityposture.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	securitypostureService, err := securityposture.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	securitypostureService, err := securityposture.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package securityposture // import "google.golang.org/api/securityposture/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "securityposture:v1"
const apiName = "securityposture"
const apiVersion = "v1"
const basePath = "https://securityposture.googleapis.com/"
const basePathTemplate = "https://securityposture.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://securityposture.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.Operations = NewOrganizationsLocationsOperationsService(s)
	rs.PostureDeployments = NewOrganizationsLocationsPostureDeploymentsService(s)
	rs.PostureTemplates = NewOrganizationsLocationsPostureTemplatesService(s)
	rs.Postures = NewOrganizationsLocationsPosturesService(s)
	rs.Reports = NewOrganizationsLocationsReportsService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	Operations *OrganizationsLocationsOperationsService

	PostureDeployments *OrganizationsLocationsPostureDeploymentsService

	PostureTemplates *OrganizationsLocationsPostureTemplatesService

	Postures *OrganizationsLocationsPosturesService

	Reports *OrganizationsLocationsReportsService
}

func NewOrganizationsLocationsOperationsService(s *Service) *OrganizationsLocationsOperationsService {
	rs := &OrganizationsLocationsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsPostureDeploymentsService(s *Service) *OrganizationsLocationsPostureDeploymentsService {
	rs := &OrganizationsLocationsPostureDeploymentsService{s: s}
	return rs
}

type OrganizationsLocationsPostureDeploymentsService struct {
	s *Service
}

func NewOrganizationsLocationsPostureTemplatesService(s *Service) *OrganizationsLocationsPostureTemplatesService {
	rs := &OrganizationsLocationsPostureTemplatesService{s: s}
	return rs
}

type OrganizationsLocationsPostureTemplatesService struct {
	s *Service
}

func NewOrganizationsLocationsPosturesService(s *Service) *OrganizationsLocationsPosturesService {
	rs := &OrganizationsLocationsPosturesService{s: s}
	return rs
}

type OrganizationsLocationsPosturesService struct {
	s *Service
}

func NewOrganizationsLocationsReportsService(s *Service) *OrganizationsLocationsReportsService {
	rs := &OrganizationsLocationsReportsService{s: s}
	return rs
}

type OrganizationsLocationsReportsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	return rs
}

type ProjectsLocationsService struct {
	s *Service
}

// AssetDetails: Details of a Cloud Asset Inventory asset that caused a
// violation.
type AssetDetails struct {
	// Asset: Information about the Cloud Asset Inventory asset that violated a
	// policy. The format of this information can change at any time without prior
	// notice. Your application must not depend on this information in any way.
	Asset string `json:"asset,omitempty"`
	// AssetType: The type of Cloud Asset Inventory asset. For a list of asset
	// types, see Supported asset types
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types).
	AssetType string `json:"assetType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Asset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AssetDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// ComplianceStandard: Information about a compliance standard that the policy
// helps enforce.
type ComplianceStandard struct {
	// Control: Optional. The control in the compliance standard that the policy
	// helps enforce. For example, `AC-3`.
	Control string `json:"control,omitempty"`
	// Standard: Optional. The compliance standard that the policy helps enforce.
	// For example, `NIST SP 800-53`.
	Standard string `json:"standard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Control") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Control") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceStandard) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceStandard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Constraint: Metadata for a constraint in a Policy.
type Constraint struct {
	// OrgPolicyConstraint: Optional. A predefined organization policy constraint.
	OrgPolicyConstraint *OrgPolicyConstraint `json:"orgPolicyConstraint,omitempty"`
	// OrgPolicyConstraintCustom: Optional. A custom organization policy
	// constraint.
	OrgPolicyConstraintCustom *OrgPolicyConstraintCustom `json:"orgPolicyConstraintCustom,omitempty"`
	// SecurityHealthAnalyticsCustomModule: Optional. A custom module for Security
	// Health Analytics.
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `json:"securityHealthAnalyticsCustomModule,omitempty"`
	// SecurityHealthAnalyticsModule: Optional. A built-in detector for Security
	// Health Analytics.
	SecurityHealthAnalyticsModule *SecurityHealthAnalyticsModule `json:"securityHealthAnalyticsModule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OrgPolicyConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OrgPolicyConstraint") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Constraint) MarshalJSON() ([]byte, error) {
	type NoMethod Constraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateIaCValidationReportRequest: Request message for
// CreateIaCValidationReport.
type CreateIaCValidationReportRequest struct {
	// Iac: Required. The infrastructure-as-code (IaC) configuration to validate.
	Iac *IaC `json:"iac,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Iac") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Iac") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateIaCValidationReportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateIaCValidationReportRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomConfig: A custom module configuration for Security Health Analytics.
// Use `CustomConfig` to create custom detectors that generate custom findings
// for resources that you specify.
type CustomConfig struct {
	// CustomOutput: Optional. Definitions of custom source properties to include
	// in findings.
	CustomOutput *CustomOutputSpec `json:"customOutput,omitempty"`
	// Description: Optional. A description of the vulnerability or
	// misconfiguration that the custom module detects. The description appears in
	// each finding. Provide enough information to help an investigator understand
	// the finding. The value must be enclosed in quotation marks.
	Description string `json:"description,omitempty"`
	// Predicate: Required. The Common Expression Language (CEL) expression to
	// evaluate. When the expression evaluates to `true` for a resource, a finding
	// is generated.
	Predicate *Expr `json:"predicate,omitempty"`
	// Recommendation: Required. An explanation of the steps that security teams
	// can take to resolve the detected issue. The explanation appears in each
	// finding.
	Recommendation string `json:"recommendation,omitempty"`
	// ResourceSelector: Required. The resource types that the custom module
	// operates on.
	ResourceSelector *ResourceSelector `json:"resourceSelector,omitempty"`
	// Severity: Required. The severity of findings generated by the custom module.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value. This value is unused.
	//   "CRITICAL" - Critical severity.
	//   "HIGH" - High severity.
	//   "MEDIUM" - Medium severity.
	//   "LOW" - Low severity.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomOutput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CustomConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomOutputSpec: Definitions of custom source properties that can appear in
// findings.
type CustomOutputSpec struct {
	// Properties: Optional. The custom source properties that can appear in
	// findings.
	Properties []*Property `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomOutputSpec) MarshalJSON() ([]byte, error) {
	type NoMethod CustomOutputSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExtractPostureRequest: Request message for ExtractPosture.
type ExtractPostureRequest struct {
	// PostureId: Required. An identifier for the posture.
	PostureId string `json:"postureId,omitempty"`
	// Workload: Required. The organization, folder, or project from which policies
	// are extracted. Must be within the organization defined in parent. Use one of
	// the following formats: * `organization/{organization_number}` *
	// `folder/{folder_number}` * `project/{project_number}`
	Workload string `json:"workload,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostureId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostureId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtractPostureRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExtractPostureRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritypostureV1CustomConstraint: A custom, user-defined
// constraint. You can apply the constraint only to the resource types
// specified in the constraint, and only within the organization where the
// constraint is defined. _When you create a custom constraint, it is not
// enforced automatically._ You must use an organization policy to enforce the
// constraint
// (https://cloud.google.com/resource-manager/help/organization-policy/constraints/enforce).
type GoogleCloudSecuritypostureV1CustomConstraint struct {
	// ActionType: Whether to allow or deny the action.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "ALLOW" - Allow the action.
	//   "DENY" - Deny the action.
	ActionType string `json:"actionType,omitempty"`
	// Condition: A Common Expression Language (CEL) condition expression that must
	// evaluate to `true` for the constraint to be enforced. The maximum length is
	// 1000 characters. For example: +
	// `resource.instanceName.matches('(production|test)_(.+_)?[\d]+')`: Evaluates
	// to `true` if the resource's `instanceName` attribute contains the following:
	// + The prefix `production` or `test` + An underscore (`_`) + Optional: One or
	// more characters, followed by an underscore (`_`) + One or more digits +
	// `resource.management.auto_upgrade == true`: Evaluates to `true` if the
	// resource's `management.auto_upgrade` attribute is `true`.
	Condition string `json:"condition,omitempty"`
	// Description: A description of the constraint. The maximum length is 2000
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: A display name for the constraint. The maximum length is 200
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// MethodTypes: The types of operations that the constraint applies to.
	//
	// Possible values:
	//   "METHOD_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "CREATE" - Constraint applied when creating the resource.
	//   "UPDATE" - Constraint applied when updating the resource.
	//   "DELETE" - Not supported. Constraint applied when deleting the resource.
	MethodTypes []string `json:"methodTypes,omitempty"`
	// Name: Immutable. The name of the constraint, in the format
	// `organizations/{organization_id}/customConstraints/custom.{custom_constraint_
	// id}`. For example,
	// `organizations/123456789012/customConstraints/custom.createOnlyE2TypeVms`.
	// Must contain 1 to 62 characters, excluding the prefix
	// `organizations/{organization_id}/customConstraints/custom.`.
	Name string `json:"name,omitempty"`
	// ResourceTypes: Immutable. The resource type that the constraint applies to,
	// in the format `{canonical_service_name}/{resource_type_name}`. For example,
	// `compute.googleapis.com/Instance`.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// UpdateTime: Output only. The last time at which the constraint was updated
	// or created.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudSecuritypostureV1CustomConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritypostureV1CustomConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritypostureV1PolicyRule: A rule that defines the allowed and
// denied values for an organization policy constraint.
type GoogleCloudSecuritypostureV1PolicyRule struct {
	// AllowAll: Whether to allow any value for a list constraint. Valid only for
	// list constraints.
	AllowAll bool `json:"allowAll,omitempty"`
	// Condition: A condition that determines whether this rule is used to evaluate
	// the policy. When set, the google.type.Expr.expression field must contain 1
	// to 10 subexpressions, joined by the `||` or `&&` operators. Each
	// subexpression must use the `resource.matchTag()` or `resource.matchTagId()`
	// Common Expression Language (CEL) function. The `resource.matchTag()`
	// function takes the following arguments: * `key_name`: the namespaced name of
	// the tag key, with the organization ID and a slash (`/`) as a prefix; for
	// example, `123456789012/environment` * `value_name`: the short name of the
	// tag value For example: `resource.matchTag('123456789012/environment,
	// 'prod')` The `resource.matchTagId()` function takes the following arguments:
	// * `key_id`: the permanent ID of the tag key; for example,
	// `tagKeys/123456789012` * `value_id`: the permanent ID of the tag value; for
	// example, `tagValues/567890123456` For example:
	// `resource.matchTagId('tagKeys/123456789012', 'tagValues/567890123456')`
	Condition *Expr `json:"condition,omitempty"`
	// DenyAll: Whether to deny all values for a list constraint. Valid only for
	// list constraints.
	DenyAll bool `json:"denyAll,omitempty"`
	// Enforce: Whether to enforce the constraint. Valid only for boolean
	// constraints.
	Enforce bool `json:"enforce,omitempty"`
	// Parameters: Optional. Required for managed constraints if parameters are
	// defined. Passes parameter values when policy enforcement is enabled. Ensure
	// that parameter value types match those defined in the constraint definition.
	// For example: { "allowedLocations" : ["us-east1", "us-west1"], "allowAll" :
	// true }
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ResourceTypes: Optional. The resource types policies can support, only used
	// for managed constraints. Method type is `GOVERN_TAGS`.
	ResourceTypes *ResourceTypes `json:"resourceTypes,omitempty"`
	// Values: The allowed and denied values for a list constraint. Valid only for
	// list constraints.
	Values *GoogleCloudSecuritypostureV1PolicyRuleStringValues `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAll") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAll") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudSecuritypostureV1PolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritypostureV1PolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritypostureV1PolicyRuleStringValues: The allowed and denied
// values for a list constraint. For all constraints, these fields can contain
// literal values. Optionally, you can add the `is:` prefix to these values. If
// the value contains a colon (`:`), then the `is:` prefix is required. Some
// constraints allow you to specify a portion of the resource hierarchy, known
// as a _hierarchy subtree_
// (https://cloud.google.com/resource-manager/help/organization-policy/hierarchy-subtree),
// that the constraint applies to. To specify a hierarchy subtree, use the
// `under:` prefix, followed by a value with one of these formats: -
// `projects/{project_id}` (for example, `projects/tokyo-rain-123`) -
// `folders/{folder_id}` (for example, `folders/1234567890123`) -
// `organizations/{organization_id}` (for example,
// `organizations/123456789012`) A constraint's `supports_under` field
// indicates whether you can specify a hierarchy subtree. To learn which
// predefined constraints let you specify a hierarchy subtree, see the
// constraints reference
// (https://cloud.google.com/resource-manager/help/organization-policy/constraints/reference).
type GoogleCloudSecuritypostureV1PolicyRuleStringValues struct {
	// AllowedValues: The allowed values for the constraint.
	AllowedValues []string `json:"allowedValues,omitempty"`
	// DeniedValues: The denied values for the constraint.
	DeniedValues []string `json:"deniedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudSecuritypostureV1PolicyRuleStringValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritypostureV1PolicyRuleStringValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IaC: Details of an infrastructure-as-code (IaC) configuration.
type IaC struct {
	// TfPlan: Optional. A Terraform plan file, formatted as a stringified JSON
	// object. To learn how to generate a Terraform plan file in JSON format, see
	// JSON output format
	// (https://developer.hashicorp.com/terraform/internals/json-format) in the
	// Terraform documentation.
	TfPlan string `json:"tfPlan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TfPlan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TfPlan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IaC) MarshalJSON() ([]byte, error) {
	type NoMethod IaC
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IaCValidationReport: Details of an infrastructure-as-code (IaC) validation
// report.
type IaCValidationReport struct {
	// Note: Additional information about the report.
	Note string `json:"note,omitempty"`
	// Violations: A list of every Violation found in the IaC configuration.
	Violations []*Violation `json:"violations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Note") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Note") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IaCValidationReport) MarshalJSON() ([]byte, error) {
	type NoMethod IaCValidationReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPostureDeploymentsResponse: Response message for ListPostureDeployments.
type ListPostureDeploymentsResponse struct {
	// NextPageToken: A pagination token. To retrieve the next page of results,
	// call the method again with this token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PostureDeployments: The list of PostureDeployment resources.
	PostureDeployments []*PostureDeployment `json:"postureDeployments,omitempty"`
	// Unreachable: Locations that were temporarily unavailable and could not be
	// reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPostureDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPostureDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPostureRevisionsResponse: Response message for ListPostureRevisions.
type ListPostureRevisionsResponse struct {
	// NextPageToken: A pagination token. To retrieve the next page of results,
	// call the method again with this token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Revisions: The list of revisions for the Posture.
	Revisions []*Posture `json:"revisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPostureRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPostureRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPostureTemplatesResponse: Response message for ListPostureTemplates.
type ListPostureTemplatesResponse struct {
	// NextPageToken: A pagination token. To retrieve the next page of results,
	// call the method again with this token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PostureTemplates: The list of PostureTemplate resources.
	PostureTemplates []*PostureTemplate `json:"postureTemplates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPostureTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPostureTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPosturesResponse: Response message for ListPostures.
type ListPosturesResponse struct {
	// NextPageToken: A pagination token. To retrieve the next page of results,
	// call the method again with this token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Postures: The list of Posture resources.
	Postures []*Posture `json:"postures,omitempty"`
	// Unreachable: Locations that were temporarily unavailable and could not be
	// reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPosturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPosturesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReportsResponse: Response message for ListReports.
type ListReportsResponse struct {
	// NextPageToken: A pagination token. To retrieve the next page of results,
	// call the method again with this token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Reports: The list of Report resources.
	Reports []*Report `json:"reports,omitempty"`
	// Unreachable: Locations that were temporarily unavailable and could not be
	// reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReportsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Metadata for an Operation.
type OperationMetadata struct {
	// ApiVersion: Output only. The API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time at which the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time at which the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ErrorMessage: Output only. An error message. Returned when a
	// PostureDeployment enters a failure state like UPDATE_FAILED.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// RequestedCancellation: Output only. Whether a request to cancel the
	// operation has been received. For operations that have been cancelled
	// successfully, the Operation.error field contains the error code CANCELLED.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. The status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. The server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. The name of the action executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrgPolicyConstraint: A predefined organization policy constraint.
type OrgPolicyConstraint struct {
	// CannedConstraintId: Required. A unique identifier for the constraint.
	CannedConstraintId string `json:"cannedConstraintId,omitempty"`
	// PolicyRules: Required. The rules enforced by the constraint.
	PolicyRules []*GoogleCloudSecuritypostureV1PolicyRule `json:"policyRules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CannedConstraintId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CannedConstraintId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrgPolicyConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod OrgPolicyConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrgPolicyConstraintCustom: A custom organization policy constraint.
type OrgPolicyConstraintCustom struct {
	// CustomConstraint: Required. Metadata for the constraint.
	CustomConstraint *GoogleCloudSecuritypostureV1CustomConstraint `json:"customConstraint,omitempty"`
	// PolicyRules: Required. The rules enforced by the constraint.
	PolicyRules []*GoogleCloudSecuritypostureV1PolicyRule `json:"policyRules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrgPolicyConstraintCustom) MarshalJSON() ([]byte, error) {
	type NoMethod OrgPolicyConstraintCustom
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: The details of a policy, including the constraints that it includes.
type Policy struct {
	// ComplianceStandards: Optional. The compliance standards that the policy
	// helps enforce.
	ComplianceStandards []*ComplianceStandard `json:"complianceStandards,omitempty"`
	// Constraint: Required. The constraints that the policy includes.
	Constraint *Constraint `json:"constraint,omitempty"`
	// Description: Optional. A description of the policy.
	Description string `json:"description,omitempty"`
	// PolicyId: Required. A user-specified identifier for the policy. In a
	// PolicySet, each policy must have a unique identifier.
	PolicyId string `json:"policyId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceStandards") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceStandards") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyDetails: Details of a policy that was violated.
type PolicyDetails struct {
	// ComplianceStandards: The compliance standards that the policy maps to. For
	// example, `CIS-2.0 1.15`.
	ComplianceStandards []string `json:"complianceStandards,omitempty"`
	// Constraint: Information about the constraint that was violated. The format
	// of this information can change at any time without prior notice. Your
	// application must not depend on this information in any way.
	Constraint string `json:"constraint,omitempty"`
	// ConstraintType: The type of constraint that was violated.
	//
	// Possible values:
	//   "CONSTRAINT_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE" - A custom module for Security
	// Health Analytics.
	//   "ORG_POLICY_CUSTOM" - A custom organization policy constraint.
	//   "SECURITY_HEALTH_ANALYTICS_MODULE" - A built-in detector for Security
	// Health Analytics.
	//   "ORG_POLICY" - A predefined organization policy constraint.
	//   "REGO_POLICY" - A custom rego policy constraint.
	ConstraintType string `json:"constraintType,omitempty"`
	// Description: A description of the policy.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceStandards") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceStandards") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicySet: A group of one or more Policy resources.
type PolicySet struct {
	// Description: Optional. A description of the policy set.
	Description string `json:"description,omitempty"`
	// Policies: Required. The Policy resources in the policy set. Each policy must
	// have a policy_id that's unique within the policy set.
	Policies []*Policy `json:"policies,omitempty"`
	// PolicySetId: Required. An identifier for the policy set.
	PolicySetId string `json:"policySetId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicySet) MarshalJSON() ([]byte, error) {
	type NoMethod PolicySet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Posture: The details of a posture.
type Posture struct {
	// Annotations: Optional. The user-specified annotations for the posture. For
	// details about the values you can use in an annotation, see AIP-148: Standard
	// fields (https://google.aip.dev/148#annotations).
	Annotations map[string]string `json:"annotations,omitempty"`
	// Categories: Output only. The categories that the posture belongs to, as
	// determined by the Security Posture API.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Default value. This value is unused.
	//   "AI" - Artificial intelligence (AI).
	//   "AWS" - Amazon Web Services (AWS) policies.
	//   "GCP" - Google Cloud policies.
	//   "AZURE" - Microsoft Azure policies.
	Categories []string `json:"categories,omitempty"`
	// CreateTime: Output only. The time at which the posture was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A description of the posture.
	Description string `json:"description,omitempty"`
	// Etag: Optional. An opaque identifier for the current version of the posture
	// at the specified `revision_id`. To prevent concurrent updates from
	// overwriting each other, always provide the `etag` when you update a posture.
	// You can also provide the `etag` when you delete a posture, to help ensure
	// that you're deleting the intended version of the posture.
	Etag string `json:"etag,omitempty"`
	// Name: Required. Identifier. The name of the posture, in the format
	// `organizations/{organization}/locations/global/postures/{posture_id}`.
	Name string `json:"name,omitempty"`
	// PolicySets: Required. The PolicySet resources that the posture includes.
	PolicySets []*PolicySet `json:"policySets,omitempty"`
	// Reconciling: Output only. Whether the posture is in the process of being
	// updated.
	Reconciling bool `json:"reconciling,omitempty"`
	// RevisionId: Output only. Immutable. An opaque eight-character string that
	// identifies the revision of the posture. A posture can have multiple
	// revisions; when you deploy a posture, you deploy a specific revision of the
	// posture.
	RevisionId string `json:"revisionId,omitempty"`
	// State: Required. The state of the posture at the specified `revision_id`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "DEPRECATED" - The posture is deprecated and can no longer be deployed.
	//   "DRAFT" - The posture is a draft and is not ready to deploy.
	//   "ACTIVE" - The posture is complete and ready to deploy.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The time at which the posture was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Posture) MarshalJSON() ([]byte, error) {
	type NoMethod Posture
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostureDeployment: Details for a Posture deployment on an organization,
// folder, or project. You can deploy at most one posture to each organization,
// folder, or project. The parent resource for a posture deployment is always
// the organization, even if the deployment applies to a folder or project.
type PostureDeployment struct {
	// Annotations: Optional. The user-specified annotations for the posture
	// deployment. For details about the values you can use in an annotation, see
	// AIP-148: Standard fields (https://google.aip.dev/148#annotations).
	Annotations map[string]string `json:"annotations,omitempty"`
	// Categories: Output only. The categories that the posture deployment belongs
	// to, as determined by the Security Posture API.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Default value. This value is unused.
	//   "AI" - Artificial intelligence (AI).
	//   "AWS" - Amazon Web Services (AWS) policies.
	//   "GCP" - Google Cloud policies.
	//   "AZURE" - Microsoft Azure policies.
	Categories []string `json:"categories,omitempty"`
	// CreateTime: Output only. The time at which the posture deployment was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A description of the posture deployment.
	Description string `json:"description,omitempty"`
	// DesiredPostureId: Output only. The posture ID that was specified for the
	// deployment. Present only if the posture deployment is in a failed state.
	DesiredPostureId string `json:"desiredPostureId,omitempty"`
	// DesiredPostureRevisionId: Output only. The revision ID of the posture that
	// was specified for the deployment. Present only if the deployment is in a
	// failed state.
	DesiredPostureRevisionId string `json:"desiredPostureRevisionId,omitempty"`
	// Etag: Optional. An opaque identifier for the current version of the posture
	// deployment. To prevent concurrent updates from overwriting each other,
	// always provide the `etag` when you update a posture deployment. You can also
	// provide the `etag` when you delete a posture deployment, to help ensure that
	// you're deleting the intended posture deployment.
	Etag string `json:"etag,omitempty"`
	// FailureMessage: Output only. A description of why the posture deployment
	// failed. Present only if the deployment is in a failed state.
	FailureMessage string `json:"failureMessage,omitempty"`
	// Name: Required. Identifier. The name of the posture deployment, in the
	// format
	// `organizations/{organization}/locations/global/postureDeployments/{deployment
	// _id}`.
	Name string `json:"name,omitempty"`
	// PostureId: Required. The posture used in the deployment, in the format
	// `organizations/{organization}/locations/global/postures/{posture_id}`.
	PostureId string `json:"postureId,omitempty"`
	// PostureRevisionId: Required. The revision ID of the posture used in the
	// deployment.
	PostureRevisionId string `json:"postureRevisionId,omitempty"`
	// Reconciling: Output only. Whether the posture deployment is in the process
	// of being updated.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The state of the posture deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "CREATING" - The posture deployment is being created.
	//   "DELETING" - The posture deployment is being deleted.
	//   "UPDATING" - The posture deployment is being updated.
	//   "ACTIVE" - The posture deployment is active and in use.
	//   "CREATE_FAILED" - The posture deployment could not be created.
	//   "UPDATE_FAILED" - The posture deployment could not be updated.
	//   "DELETE_FAILED" - The posture deployment could not be deleted.
	State string `json:"state,omitempty"`
	// TargetResource: Required. The organization, folder, or project where the
	// posture is deployed. Uses one of the following formats: *
	// `organizations/{organization_number}` * `folders/{folder_number}` *
	// `projects/{project_number}`
	TargetResource string `json:"targetResource,omitempty"`
	// UpdateTime: Output only. The time at which the posture deployment was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostureDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod PostureDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostureDetails: Details of a posture deployment.
type PostureDetails struct {
	// PolicySet: The identifier for the PolicySet that the relevant policy belongs
	// to.
	PolicySet string `json:"policySet,omitempty"`
	// Posture: The posture used in the deployment, in the format
	// `organizations/{organization}/locations/global/postures/{posture_id}`.
	Posture string `json:"posture,omitempty"`
	// PostureDeployment: The name of the posture deployment, in the format
	// `organizations/{organization}/locations/global/postureDeployments/{deployment
	// _id}`.
	PostureDeployment string `json:"postureDeployment,omitempty"`
	// PostureDeploymentTargetResource: The organization, folder, or project where
	// the posture is deployed. Uses one of the following formats: *
	// `organizations/{organization_number}` * `folders/{folder_number}` *
	// `projects/{project_number}`
	PostureDeploymentTargetResource string `json:"postureDeploymentTargetResource,omitempty"`
	// PostureRevisionId: The revision ID of the posture used in the deployment.
	PostureRevisionId string `json:"postureRevisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicySet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicySet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostureDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PostureDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostureTemplate: The details of a posture template.
type PostureTemplate struct {
	// Categories: Output only. The categories that the posture template belongs
	// to, as determined by the Security Posture API.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Default value. This value is unused.
	//   "AI" - Artificial intelligence (AI).
	//   "AWS" - Amazon Web Services (AWS) policies.
	//   "GCP" - Google Cloud policies.
	//   "AZURE" - Microsoft Azure policies.
	Categories []string `json:"categories,omitempty"`
	// Description: Output only. A description of the posture template.
	Description string `json:"description,omitempty"`
	// Name: Output only. Identifier. The name of the posture template, in the
	// format
	// `organizations/{organization}/locations/global/postureTemplates/{posture_temp
	// late}`.
	Name string `json:"name,omitempty"`
	// PolicySets: Output only. The PolicySet resources that the posture template
	// includes.
	PolicySets []*PolicySet `json:"policySets,omitempty"`
	// RevisionId: Output only. A string that identifies the revision of the
	// posture template.
	RevisionId string `json:"revisionId,omitempty"`
	// State: Output only. The state of the posture template at the specified
	// `revision_id`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACTIVE" - The posture template follows the latest controls and standards.
	//   "DEPRECATED" - The posture template uses outdated controls and standards.
	// We recommend that you use a newer revision of the posture template.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostureTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod PostureTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Property: A name-value pair used as a custom source property.
type Property struct {
	// Name: Required. The name of the custom source property.
	Name string `json:"name,omitempty"`
	// ValueExpression: Optional. The CEL expression for the value of the custom
	// source property. For resource properties, you can return the value of the
	// property or a string enclosed in quotation marks.
	ValueExpression *Expr `json:"valueExpression,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Property) MarshalJSON() ([]byte, error) {
	type NoMethod Property
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Report: Details of a report.
type Report struct {
	// CreateTime: Output only. The time at which the report was created.
	CreateTime string `json:"createTime,omitempty"`
	// IacValidationReport: Output only. An infrastructure-as-code (IaC) validation
	// report.
	IacValidationReport *IaCValidationReport `json:"iacValidationReport,omitempty"`
	// Name: Required. The name of the report, in the format
	// `organizations/{organization}/locations/global/reports/{report_id}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The time at which the report was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Report) MarshalJSON() ([]byte, error) {
	type NoMethod Report
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceSelector: A selector for the resource types to run the detector on.
type ResourceSelector struct {
	// ResourceTypes: Required. The resource types to run the detector on. Each
	// custom module can specify up to 5 resource types.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceSelector) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceTypes: Set multiple resource types for one policy, for example:
// resourceTypes: included: - compute.googleapis.com/Instance -
// compute.googleapis.com/Disk Constraint definition contains an empty resource
// type in order to support multiple resource types in the policy. Only
// supports managed constraints. Method type is `GOVERN_TAGS`. Refer
// go/multi-resource-support-force-tags-gmc to get more details.
type ResourceTypes struct {
	// Included: Optional. The resource types we currently support.
	// cloud/orgpolicy/customconstraintconfig/prod/resource_types.prototext
	Included []string `json:"included,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Included") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Included") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceTypes) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityHealthAnalyticsCustomModule: A custom module for Security Health
// Analytics.
type SecurityHealthAnalyticsCustomModule struct {
	// Config: Required. Configuration settings for the custom module.
	Config *CustomConfig `json:"config,omitempty"`
	// DisplayName: Optional. The display name of the custom module. This value is
	// used as the finding category for all the asset violation findings that the
	// custom module returns. The display name must contain between 1 and 128
	// alphanumeric characters or underscores, and it must start with a lowercase
	// letter.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Output only. Immutable. The unique identifier for the custom module.
	// Contains 1 to 20 digits.
	Id string `json:"id,omitempty"`
	// ModuleEnablementState: Whether the custom module is enabled at a specified
	// level of the resource hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ENABLED" - The detector or custom module is enabled.
	//   "DISABLED" - The detector or custom module is disabled.
	ModuleEnablementState string `json:"moduleEnablementState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityHealthAnalyticsCustomModule) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityHealthAnalyticsCustomModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityHealthAnalyticsModule: A built-in detector for Security Health
// Analytics.
type SecurityHealthAnalyticsModule struct {
	// ModuleEnablementState: Whether the detector is enabled at a specified level
	// of the resource hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ENABLED" - The detector or custom module is enabled.
	//   "DISABLED" - The detector or custom module is disabled.
	ModuleEnablementState string `json:"moduleEnablementState,omitempty"`
	// ModuleName: Required. The name of the detector. For example,
	// `BIGQUERY_TABLE_CMEK_DISABLED`. This field is also used as the finding
	// category for all the asset violation findings that the detector returns.
	ModuleName string `json:"moduleName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModuleEnablementState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModuleEnablementState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityHealthAnalyticsModule) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityHealthAnalyticsModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Violation: Details of a violation.
type Violation struct {
	// AssetId: The full resource name of the asset that caused the violation. For
	// details about the format of the full resource name for each asset type, see
	// Resource name format
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format).
	AssetId string `json:"assetId,omitempty"`
	// NextSteps: A description of the steps that you can take to fix the
	// violation.
	NextSteps string `json:"nextSteps,omitempty"`
	// PolicyId: The policy that was violated.
	PolicyId string `json:"policyId,omitempty"`
	// Severity: The severity of the violation.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value. This value is unused.
	//   "CRITICAL" - Critical severity.
	//   "HIGH" - High severity.
	//   "MEDIUM" - Medium severity.
	//   "LOW" - Low severity.
	Severity string `json:"severity,omitempty"`
	// ViolatedAsset: Details of the Cloud Asset Inventory asset that caused the
	// violation.
	ViolatedAsset *AssetDetails `json:"violatedAsset,omitempty"`
	// ViolatedPolicy: Details of the policy that was violated.
	ViolatedPolicy *PolicyDetails `json:"violatedPolicy,omitempty"`
	// ViolatedPosture: Details for the posture that was violated. This field is
	// present only if the violated policy belongs to a deployed posture.
	ViolatedPosture *PostureDetails `json:"violatedPosture,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssetId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Violation) MarshalJSON() ([]byte, error) {
	type NoMethod Violation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrganizationsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *OrganizationsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *OrganizationsLocationsOperationsCancelCall {
	c := &OrganizationsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsCancelCall) Context(ctx context.Context) *OrganizationsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *OrganizationsLocationsOperationsService) Delete(name string) *OrganizationsLocationsOperationsDeleteCall {
	c := &OrganizationsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsOperationsService) Get(name string) *OrganizationsLocationsOperationsGetCall {
	c := &OrganizationsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *OrganizationsLocationsOperationsService) List(name string) *OrganizationsLocationsOperationsListCall {
	c := &OrganizationsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *OrganizationsLocationsOperationsListCall) Filter(filter string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *OrganizationsLocationsOperationsListCall) PageSize(pageSize int64) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *OrganizationsLocationsOperationsListCall) PageToken(pageToken string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOperationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsListCall) Context(ctx context.Context) *OrganizationsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsPostureDeploymentsCreateCall struct {
	s                 *Service
	parent            string
	posturedeployment *PostureDeployment
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new PostureDeployment in a given project and location.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPostureDeploymentsService) Create(parent string, posturedeployment *PostureDeployment) *OrganizationsLocationsPostureDeploymentsCreateCall {
	c := &OrganizationsLocationsPostureDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.posturedeployment = posturedeployment
	return c
}

// PostureDeploymentId sets the optional parameter "postureDeploymentId":
// Required. An identifier for the posture deployment.
func (c *OrganizationsLocationsPostureDeploymentsCreateCall) PostureDeploymentId(postureDeploymentId string) *OrganizationsLocationsPostureDeploymentsCreateCall {
	c.urlParams_.Set("postureDeploymentId", postureDeploymentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureDeploymentsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureDeploymentsCreateCall) Context(ctx context.Context) *OrganizationsLocationsPostureDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posturedeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postureDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureDeployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPostureDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPostureDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a PostureDeployment.
//
//   - name: The name of the posture deployment, in the format
//     `organizations/{organization}/locations/global/postureDeployments/{posture_
//     id}`.
func (r *OrganizationsLocationsPostureDeploymentsService) Delete(name string) *OrganizationsLocationsPostureDeploymentsDeleteCall {
	c := &OrganizationsLocationsPostureDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": An opaque identifier for the
// current version of the posture deployment. If you provide this value, then
// it must match the existing value. If the values don't match, then the
// request fails with an ABORTED error. If you omit this value, then the
// posture deployment is deleted regardless of its current `etag` value.
func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) Etag(etag string) *OrganizationsLocationsPostureDeploymentsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsPostureDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureDeployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPostureDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPostureDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details for a PostureDeployment.
//
//   - name: The name of the PostureDeployment, in the format
//     `organizations/{organization}/locations/global/postureDeployments/{posture_
//     deployment_id}`.
func (r *OrganizationsLocationsPostureDeploymentsService) Get(name string) *OrganizationsLocationsPostureDeploymentsGetCall {
	c := &OrganizationsLocationsPostureDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureDeploymentsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPostureDeploymentsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPostureDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureDeploymentsGetCall) Context(ctx context.Context) *OrganizationsLocationsPostureDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureDeployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PostureDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsPostureDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*PostureDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PostureDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPostureDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists every PostureDeployment in a project and location.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPostureDeploymentsService) List(parent string) *OrganizationsLocationsPostureDeploymentsListCall {
	c := &OrganizationsLocationsPostureDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply to the list
// of postures, in the format defined in AIP-160: Filtering
// (https://google.aip.dev/160).
func (c *OrganizationsLocationsPostureDeploymentsListCall) Filter(filter string) *OrganizationsLocationsPostureDeploymentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// posture deployments to return. The default value is `500`. If you exceed the
// maximum value of `1000`, then the service uses the maximum value.
func (c *OrganizationsLocationsPostureDeploymentsListCall) PageSize(pageSize int64) *OrganizationsLocationsPostureDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous request to list posture deployments. Provide this
// token to retrieve the next page of results.
func (c *OrganizationsLocationsPostureDeploymentsListCall) PageToken(pageToken string) *OrganizationsLocationsPostureDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureDeploymentsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPostureDeploymentsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPostureDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureDeploymentsListCall) Context(ctx context.Context) *OrganizationsLocationsPostureDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postureDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureDeployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPostureDeploymentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsPostureDeploymentsListCall) Do(opts ...googleapi.CallOption) (*ListPostureDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPostureDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsPostureDeploymentsListCall) Pages(ctx context.Context, f func(*ListPostureDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsPostureDeploymentsPatchCall struct {
	s                 *Service
	name              string
	posturedeployment *PostureDeployment
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates an existing PostureDeployment. To prevent concurrent updates
// from overwriting each other, always follow the read-modify-write pattern
// when you update a posture deployment: 1. Call GetPostureDeployment to get
// the current version of the deployment. 2. Update the fields in the
// deployment as needed. 3. Call UpdatePostureDeployment to update the
// deployment. Ensure that your request includes the `etag` value from the
// GetPostureDeployment response. **Important:** If you omit the `etag` when
// you call UpdatePostureDeployment, then the updated deployment
// unconditionally overwrites the existing deployment.
//
//   - name: Identifier. The name of the posture deployment, in the format
//     `organizations/{organization}/locations/global/postureDeployments/{deployme
//     nt_id}`.
func (r *OrganizationsLocationsPostureDeploymentsService) Patch(name string, posturedeployment *PostureDeployment) *OrganizationsLocationsPostureDeploymentsPatchCall {
	c := &OrganizationsLocationsPostureDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.posturedeployment = posturedeployment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields in
// the PostureDeployment to update. You can update only the following fields: *
// PostureDeployment.posture_id * PostureDeployment.posture_revision_id
func (c *OrganizationsLocationsPostureDeploymentsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsPostureDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureDeploymentsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureDeploymentsPatchCall) Context(ctx context.Context) *OrganizationsLocationsPostureDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posturedeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureDeployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPostureDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureDeployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPostureTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single revision of a PostureTemplate.
//
//   - name: The name of the PostureTemplate, in the format
//     `organizations/{organization}/locations/global/postureTemplates/{posture_te
//     mplate}`.
func (r *OrganizationsLocationsPostureTemplatesService) Get(name string) *OrganizationsLocationsPostureTemplatesGetCall {
	c := &OrganizationsLocationsPostureTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RevisionId sets the optional parameter "revisionId": The posture template
// revision to retrieve. If not specified, the most recently updated revision
// is retrieved.
func (c *OrganizationsLocationsPostureTemplatesGetCall) RevisionId(revisionId string) *OrganizationsLocationsPostureTemplatesGetCall {
	c.urlParams_.Set("revisionId", revisionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureTemplatesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPostureTemplatesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPostureTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureTemplatesGetCall) Context(ctx context.Context) *OrganizationsLocationsPostureTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PostureTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsPostureTemplatesGetCall) Do(opts ...googleapi.CallOption) (*PostureTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PostureTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPostureTemplatesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists every PostureTemplate in a given organization and location.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPostureTemplatesService) List(parent string) *OrganizationsLocationsPostureTemplatesListCall {
	c := &OrganizationsLocationsPostureTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply to the list
// of postures, in the format defined in AIP-160: Filtering
// (https://google.aip.dev/160).
func (c *OrganizationsLocationsPostureTemplatesListCall) Filter(filter string) *OrganizationsLocationsPostureTemplatesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// posture templates to return. The default value is `500`. If you exceed the
// maximum value of `1000`, then the service uses the maximum value.
func (c *OrganizationsLocationsPostureTemplatesListCall) PageSize(pageSize int64) *OrganizationsLocationsPostureTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous request to list posture templates. Provide this
// token to retrieve the next page of results.
func (c *OrganizationsLocationsPostureTemplatesListCall) PageToken(pageToken string) *OrganizationsLocationsPostureTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPostureTemplatesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPostureTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPostureTemplatesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPostureTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPostureTemplatesListCall) Context(ctx context.Context) *OrganizationsLocationsPostureTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPostureTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPostureTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postureTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postureTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPostureTemplatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsPostureTemplatesListCall) Do(opts ...googleapi.CallOption) (*ListPostureTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPostureTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postureTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsPostureTemplatesListCall) Pages(ctx context.Context, f func(*ListPostureTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsPosturesCreateCall struct {
	s          *Service
	parent     string
	posture    *Posture
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Posture.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPosturesService) Create(parent string, posture *Posture) *OrganizationsLocationsPosturesCreateCall {
	c := &OrganizationsLocationsPosturesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.posture = posture
	return c
}

// PostureId sets the optional parameter "postureId": Required. An identifier
// for the posture.
func (c *OrganizationsLocationsPosturesCreateCall) PostureId(postureId string) *OrganizationsLocationsPosturesCreateCall {
	c.urlParams_.Set("postureId", postureId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesCreateCall) Context(ctx context.Context) *OrganizationsLocationsPosturesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posture)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postures")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPosturesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes all revisions of a Posture. You can only delete a posture if
// none of its revisions are deployed.
//
//   - name: The name of the Posture, in the format
//     `organizations/{organization}/locations/global/postures/{posture_id}`.
func (r *OrganizationsLocationsPosturesService) Delete(name string) *OrganizationsLocationsPosturesDeleteCall {
	c := &OrganizationsLocationsPosturesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": An opaque identifier for the
// current version of the posture. If you provide this value, then it must
// match the existing value. If the values don't match, then the request fails
// with an ABORTED error. If you omit this value, then the posture is deleted
// regardless of its current `etag` value.
func (c *OrganizationsLocationsPosturesDeleteCall) Etag(etag string) *OrganizationsLocationsPosturesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsPosturesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPosturesExtractCall struct {
	s                     *Service
	parent                string
	extractposturerequest *ExtractPostureRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Extract: Extracts existing policies from an organization, folder, or
// project, and applies them to another organization, folder, or project as a
// Posture. If the other organization, folder, or project already has a
// posture, then the result of the long-running operation is an ALREADY_EXISTS
// error.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPosturesService) Extract(parent string, extractposturerequest *ExtractPostureRequest) *OrganizationsLocationsPosturesExtractCall {
	c := &OrganizationsLocationsPosturesExtractCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.extractposturerequest = extractposturerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesExtractCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesExtractCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesExtractCall) Context(ctx context.Context) *OrganizationsLocationsPosturesExtractCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesExtractCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesExtractCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.extractposturerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postures:extract")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.extract", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.extract" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesExtractCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.extract", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPosturesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single revision of a Posture.
//
//   - name: The name of the Posture, in the format
//     `organizations/{organization}/locations/global/postures/{posture_id}`.
func (r *OrganizationsLocationsPosturesService) Get(name string) *OrganizationsLocationsPosturesGetCall {
	c := &OrganizationsLocationsPosturesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RevisionId sets the optional parameter "revisionId": The posture revision to
// retrieve. If not specified, the most recently updated revision is retrieved.
func (c *OrganizationsLocationsPosturesGetCall) RevisionId(revisionId string) *OrganizationsLocationsPosturesGetCall {
	c.urlParams_.Set("revisionId", revisionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPosturesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPosturesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesGetCall) Context(ctx context.Context) *OrganizationsLocationsPosturesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Posture.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesGetCall) Do(opts ...googleapi.CallOption) (*Posture, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Posture{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsPosturesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the most recent revisions of all Posture resources in a
// specified organization and location.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsPosturesService) List(parent string) *OrganizationsLocationsPosturesListCall {
	c := &OrganizationsLocationsPosturesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply to the list
// of postures, in the format defined in AIP-160: Filtering
// (https://google.aip.dev/160).
func (c *OrganizationsLocationsPosturesListCall) Filter(filter string) *OrganizationsLocationsPosturesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// postures to return. The default value is `500`. If you exceed the maximum
// value of `1000`, then the service uses the maximum value.
func (c *OrganizationsLocationsPosturesListCall) PageSize(pageSize int64) *OrganizationsLocationsPosturesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous request to list postures. Provide this token to
// retrieve the next page of results.
func (c *OrganizationsLocationsPosturesListCall) PageToken(pageToken string) *OrganizationsLocationsPosturesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPosturesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPosturesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesListCall) Context(ctx context.Context) *OrganizationsLocationsPosturesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/postures")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPosturesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsPosturesListCall) Do(opts ...googleapi.CallOption) (*ListPosturesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPosturesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsPosturesListCall) Pages(ctx context.Context, f func(*ListPosturesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsPosturesListRevisionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListRevisions: Lists all revisions of a single Posture.
//
//   - name: The name of the Posture, in the format
//     `organizations/{organization}/locations/global/postures/{posture_id}`.
func (r *OrganizationsLocationsPosturesService) ListRevisions(name string) *OrganizationsLocationsPosturesListRevisionsCall {
	c := &OrganizationsLocationsPosturesListRevisionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// posture revisions to return. The default value is `500`. If you exceed the
// maximum value of `1000`, then the service uses the maximum value.
func (c *OrganizationsLocationsPosturesListRevisionsCall) PageSize(pageSize int64) *OrganizationsLocationsPosturesListRevisionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token from a
// previous request to list posture revisions. Provide this token to retrieve
// the next page of results.
func (c *OrganizationsLocationsPosturesListRevisionsCall) PageToken(pageToken string) *OrganizationsLocationsPosturesListRevisionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesListRevisionsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesListRevisionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsPosturesListRevisionsCall) IfNoneMatch(entityTag string) *OrganizationsLocationsPosturesListRevisionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesListRevisionsCall) Context(ctx context.Context) *OrganizationsLocationsPosturesListRevisionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesListRevisionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesListRevisionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:listRevisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.listRevisions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.listRevisions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPostureRevisionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesListRevisionsCall) Do(opts ...googleapi.CallOption) (*ListPostureRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPostureRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.listRevisions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsPosturesListRevisionsCall) Pages(ctx context.Context, f func(*ListPostureRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsPosturesPatchCall struct {
	s          *Service
	name       string
	posture    *Posture
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a revision of an existing Posture. If the posture revision
// that you update is currently deployed, then a new revision of the posture is
// created. To prevent concurrent updates from overwriting each other, always
// follow the read-modify-write pattern when you update a posture: 1. Call
// GetPosture to get the current version of the posture. 2. Update the fields
// in the posture as needed. 3. Call UpdatePosture to update the posture.
// Ensure that your request includes the `etag` value from the GetPosture
// response. **Important:** If you omit the `etag` when you call UpdatePosture,
// then the updated posture unconditionally overwrites the existing posture.
//
//   - name: Identifier. The name of the posture, in the format
//     `organizations/{organization}/locations/global/postures/{posture_id}`.
func (r *OrganizationsLocationsPosturesService) Patch(name string, posture *Posture) *OrganizationsLocationsPosturesPatchCall {
	c := &OrganizationsLocationsPosturesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.posture = posture
	return c
}

// RevisionId sets the optional parameter "revisionId": Required. The revision
// ID of the posture to update. If the posture revision that you update is
// currently deployed, then a new revision of the posture is created.
func (c *OrganizationsLocationsPosturesPatchCall) RevisionId(revisionId string) *OrganizationsLocationsPosturesPatchCall {
	c.urlParams_.Set("revisionId", revisionId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The fields in
// the Posture to update. You can update only the following fields: *
// Posture.description * Posture.policy_sets * Posture.state
func (c *OrganizationsLocationsPosturesPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsPosturesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsPosturesPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsPosturesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsPosturesPatchCall) Context(ctx context.Context) *OrganizationsLocationsPosturesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsPosturesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsPosturesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posture)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.postures.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsPosturesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.postures.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReportsCreateIaCValidationReportCall struct {
	s                                *Service
	parent                           string
	createiacvalidationreportrequest *CreateIaCValidationReportRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// CreateIaCValidationReport: Validates a specified infrastructure-as-code
// (IaC) configuration, and creates a Report with the validation results. Only
// Terraform configurations are supported. Only modified assets are validated.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsReportsService) CreateIaCValidationReport(parent string, createiacvalidationreportrequest *CreateIaCValidationReportRequest) *OrganizationsLocationsReportsCreateIaCValidationReportCall {
	c := &OrganizationsLocationsReportsCreateIaCValidationReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createiacvalidationreportrequest = createiacvalidationreportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReportsCreateIaCValidationReportCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReportsCreateIaCValidationReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReportsCreateIaCValidationReportCall) Context(ctx context.Context) *OrganizationsLocationsReportsCreateIaCValidationReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReportsCreateIaCValidationReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReportsCreateIaCValidationReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createiacvalidationreportrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reports:createIaCValidationReport")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.createIaCValidationReport", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.reports.createIaCValidationReport" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsReportsCreateIaCValidationReportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.createIaCValidationReport", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details for a Report.
//
//   - name: The name of the report, in the format
//     `organizations/{organization}/locations/global/reports/{report_id}`.
func (r *OrganizationsLocationsReportsService) Get(name string) *OrganizationsLocationsReportsGetCall {
	c := &OrganizationsLocationsReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReportsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReportsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReportsGetCall) Context(ctx context.Context) *OrganizationsLocationsReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.reports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Report.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsReportsGetCall) Do(opts ...googleapi.CallOption) (*Report, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Report{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists every Report in a given organization and location.
//
//   - parent: The parent resource name, in the format
//     `organizations/{organization}/locations/global`.
func (r *OrganizationsLocationsReportsService) List(parent string) *OrganizationsLocationsReportsListCall {
	c := &OrganizationsLocationsReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply to the list
// of reports, in the format defined in AIP-160: Filtering
// (https://google.aip.dev/160).
func (c *OrganizationsLocationsReportsListCall) Filter(filter string) *OrganizationsLocationsReportsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// reports to return. The default value is `500`. If you exceed the maximum
// value of `1000`, then the service uses the maximum value.
func (c *OrganizationsLocationsReportsListCall) PageSize(pageSize int64) *OrganizationsLocationsReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous request to list reports. Provide this token to
// retrieve the next page of results.
func (c *OrganizationsLocationsReportsListCall) PageToken(pageToken string) *OrganizationsLocationsReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReportsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReportsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReportsListCall) Context(ctx context.Context) *OrganizationsLocationsReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.organizations.locations.reports.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReportsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsReportsListCall) Do(opts ...googleapi.CallOption) (*ListReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.organizations.locations.reports.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsReportsListCall) Pages(ctx context.Context, f func(*ListReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "securityposture.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securityposture.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "securityposture.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
