// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/keyword_plan.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A Keyword Planner plan.
// Max number of saved keyword plans: 10000.
// It's possible to remove plans if limit is reached.
type KeywordPlan struct {
	// The resource name of the Keyword Planner plan.
	// KeywordPlan resource names have the form:
	//
	// `customers/{customer_id}/keywordPlans/{kp_plan_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the keyword plan.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the keyword plan.
	//
	// This field is required and should not be empty when creating new keyword
	// plans.
	Name *wrappers.StringValue `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The date period used for forecasting the plan.
	ForecastPeriod       *KeywordPlanForecastPeriod `protobuf:"bytes,4,opt,name=forecast_period,json=forecastPeriod,proto3" json:"forecast_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *KeywordPlan) Reset()         { *m = KeywordPlan{} }
func (m *KeywordPlan) String() string { return proto.CompactTextString(m) }
func (*KeywordPlan) ProtoMessage()    {}
func (*KeywordPlan) Descriptor() ([]byte, []int) {
	return fileDescriptor_keyword_plan_5cb815c94462019d, []int{0}
}
func (m *KeywordPlan) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlan.Unmarshal(m, b)
}
func (m *KeywordPlan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlan.Marshal(b, m, deterministic)
}
func (dst *KeywordPlan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlan.Merge(dst, src)
}
func (m *KeywordPlan) XXX_Size() int {
	return xxx_messageInfo_KeywordPlan.Size(m)
}
func (m *KeywordPlan) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlan.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlan proto.InternalMessageInfo

func (m *KeywordPlan) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *KeywordPlan) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *KeywordPlan) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *KeywordPlan) GetForecastPeriod() *KeywordPlanForecastPeriod {
	if m != nil {
		return m.ForecastPeriod
	}
	return nil
}

// The forecasting period associated with the keyword plan.
type KeywordPlanForecastPeriod struct {
	// Required. The date used for forecasting the Plan.
	//
	// Types that are valid to be assigned to Interval:
	//	*KeywordPlanForecastPeriod_DateInterval
	//	*KeywordPlanForecastPeriod_DateRange
	Interval             isKeywordPlanForecastPeriod_Interval `protobuf_oneof:"interval"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *KeywordPlanForecastPeriod) Reset()         { *m = KeywordPlanForecastPeriod{} }
func (m *KeywordPlanForecastPeriod) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanForecastPeriod) ProtoMessage()    {}
func (*KeywordPlanForecastPeriod) Descriptor() ([]byte, []int) {
	return fileDescriptor_keyword_plan_5cb815c94462019d, []int{1}
}
func (m *KeywordPlanForecastPeriod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanForecastPeriod.Unmarshal(m, b)
}
func (m *KeywordPlanForecastPeriod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanForecastPeriod.Marshal(b, m, deterministic)
}
func (dst *KeywordPlanForecastPeriod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanForecastPeriod.Merge(dst, src)
}
func (m *KeywordPlanForecastPeriod) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanForecastPeriod.Size(m)
}
func (m *KeywordPlanForecastPeriod) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanForecastPeriod.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanForecastPeriod proto.InternalMessageInfo

type isKeywordPlanForecastPeriod_Interval interface {
	isKeywordPlanForecastPeriod_Interval()
}

type KeywordPlanForecastPeriod_DateInterval struct {
	DateInterval enums.KeywordPlanForecastIntervalEnum_KeywordPlanForecastInterval `protobuf:"varint,1,opt,name=date_interval,json=dateInterval,proto3,enum=google.ads.googleads.v1.enums.KeywordPlanForecastIntervalEnum_KeywordPlanForecastInterval,oneof"`
}

type KeywordPlanForecastPeriod_DateRange struct {
	DateRange *common.DateRange `protobuf:"bytes,2,opt,name=date_range,json=dateRange,proto3,oneof"`
}

func (*KeywordPlanForecastPeriod_DateInterval) isKeywordPlanForecastPeriod_Interval() {}

func (*KeywordPlanForecastPeriod_DateRange) isKeywordPlanForecastPeriod_Interval() {}

func (m *KeywordPlanForecastPeriod) GetInterval() isKeywordPlanForecastPeriod_Interval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *KeywordPlanForecastPeriod) GetDateInterval() enums.KeywordPlanForecastIntervalEnum_KeywordPlanForecastInterval {
	if x, ok := m.GetInterval().(*KeywordPlanForecastPeriod_DateInterval); ok {
		return x.DateInterval
	}
	return enums.KeywordPlanForecastIntervalEnum_UNSPECIFIED
}

func (m *KeywordPlanForecastPeriod) GetDateRange() *common.DateRange {
	if x, ok := m.GetInterval().(*KeywordPlanForecastPeriod_DateRange); ok {
		return x.DateRange
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*KeywordPlanForecastPeriod) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _KeywordPlanForecastPeriod_OneofMarshaler, _KeywordPlanForecastPeriod_OneofUnmarshaler, _KeywordPlanForecastPeriod_OneofSizer, []interface{}{
		(*KeywordPlanForecastPeriod_DateInterval)(nil),
		(*KeywordPlanForecastPeriod_DateRange)(nil),
	}
}

func _KeywordPlanForecastPeriod_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*KeywordPlanForecastPeriod)
	// interval
	switch x := m.Interval.(type) {
	case *KeywordPlanForecastPeriod_DateInterval:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.DateInterval))
	case *KeywordPlanForecastPeriod_DateRange:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateRange); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("KeywordPlanForecastPeriod.Interval has unexpected type %T", x)
	}
	return nil
}

func _KeywordPlanForecastPeriod_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*KeywordPlanForecastPeriod)
	switch tag {
	case 1: // interval.date_interval
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Interval = &KeywordPlanForecastPeriod_DateInterval{enums.KeywordPlanForecastIntervalEnum_KeywordPlanForecastInterval(x)}
		return true, err
	case 2: // interval.date_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.DateRange)
		err := b.DecodeMessage(msg)
		m.Interval = &KeywordPlanForecastPeriod_DateRange{msg}
		return true, err
	default:
		return false, nil
	}
}

func _KeywordPlanForecastPeriod_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*KeywordPlanForecastPeriod)
	// interval
	switch x := m.Interval.(type) {
	case *KeywordPlanForecastPeriod_DateInterval:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.DateInterval))
	case *KeywordPlanForecastPeriod_DateRange:
		s := proto.Size(x.DateRange)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*KeywordPlan)(nil), "google.ads.googleads.v1.resources.KeywordPlan")
	proto.RegisterType((*KeywordPlanForecastPeriod)(nil), "google.ads.googleads.v1.resources.KeywordPlanForecastPeriod")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/keyword_plan.proto", fileDescriptor_keyword_plan_5cb815c94462019d)
}

var fileDescriptor_keyword_plan_5cb815c94462019d = []byte{
	// 486 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0xdd, 0x6a, 0xd4, 0x40,
	0x14, 0xc7, 0x9b, 0xb4, 0x88, 0x9d, 0x7e, 0x28, 0xb9, 0x5a, 0x6b, 0x91, 0xb6, 0x52, 0xa8, 0x0a,
	0x13, 0x53, 0x8b, 0x17, 0xd1, 0x9b, 0x2c, 0x6a, 0x3f, 0x04, 0x59, 0x22, 0xec, 0x45, 0x59, 0x58,
	0xa6, 0x3b, 0x67, 0x43, 0x30, 0x99, 0x09, 0x33, 0x93, 0x2d, 0x5e, 0xfa, 0x2a, 0x5e, 0xfa, 0x28,
	0x3e, 0x8a, 0x2f, 0xa0, 0x37, 0x82, 0x64, 0xbe, 0x68, 0xb1, 0x69, 0xef, 0xce, 0xd9, 0xf9, 0x9d,
	0xff, 0xff, 0x7c, 0x64, 0xd1, 0x51, 0xc1, 0x79, 0x51, 0x41, 0x4c, 0xa8, 0x8c, 0x4d, 0xd8, 0x45,
	0x8b, 0x24, 0x16, 0x20, 0x79, 0x2b, 0x66, 0x20, 0xe3, 0x2f, 0xf0, 0xf5, 0x92, 0x0b, 0x3a, 0x6d,
	0x2a, 0xc2, 0x70, 0x23, 0xb8, 0xe2, 0xd1, 0xae, 0x41, 0x31, 0xa1, 0x12, 0xfb, 0x2a, 0xbc, 0x48,
	0xb0, 0xaf, 0xda, 0x7a, 0xde, 0x27, 0x3c, 0xe3, 0x75, 0xcd, 0x59, 0x4c, 0x89, 0x02, 0x69, 0xe4,
	0xb6, 0x86, 0x7d, 0x2c, 0xb0, 0xb6, 0xbe, 0xde, 0xc0, 0x74, 0xce, 0x05, 0xcc, 0x88, 0x54, 0xd3,
	0x92, 0x29, 0x10, 0x0b, 0x52, 0x59, 0x8d, 0x27, 0x56, 0x43, 0x67, 0x17, 0xed, 0x3c, 0xbe, 0x14,
	0xa4, 0x69, 0x40, 0x38, 0x8f, 0x6d, 0xe7, 0xd1, 0x94, 0x31, 0x61, 0x8c, 0x2b, 0xa2, 0x4a, 0xce,
	0xec, 0xeb, 0xde, 0x9f, 0x00, 0xad, 0x7d, 0x34, 0x36, 0xa3, 0x8a, 0xb0, 0xe8, 0x29, 0xda, 0x70,
	0xa3, 0x4c, 0x19, 0xa9, 0x61, 0x10, 0xec, 0x04, 0x07, 0xab, 0xf9, 0xba, 0xfb, 0xf1, 0x13, 0xa9,
	0x21, 0x7a, 0x81, 0xc2, 0x92, 0x0e, 0xc2, 0x9d, 0xe0, 0x60, 0xed, 0xf0, 0xb1, 0xdd, 0x03, 0x76,
	0xfe, 0xf8, 0x94, 0xa9, 0xd7, 0x47, 0x63, 0x52, 0xb5, 0x90, 0x87, 0x25, 0x8d, 0x5e, 0xa2, 0x15,
	0x2d, 0xb4, 0xac, 0xf1, 0xed, 0xff, 0xf0, 0xcf, 0x4a, 0x94, 0xac, 0x30, 0xbc, 0x26, 0x23, 0x40,
	0x0f, 0xfc, 0xb0, 0x0d, 0x88, 0x92, 0xd3, 0xc1, 0x8a, 0x2e, 0x7e, 0x8b, 0xef, 0x5c, 0x3f, 0xbe,
	0x32, 0xcc, 0x07, 0x2b, 0x32, 0xd2, 0x1a, 0xf9, 0xe6, 0xfc, 0x5a, 0xbe, 0xf7, 0x3b, 0x40, 0x8f,
	0x7a, 0xe9, 0xe8, 0x5b, 0x80, 0x36, 0xba, 0x53, 0xf9, 0x75, 0xeb, 0x4d, 0x6c, 0x1e, 0x9e, 0xf7,
	0xf6, 0xa0, 0x6f, 0x76, 0x93, 0xff, 0xa9, 0x55, 0x78, 0xcf, 0xda, 0xfa, 0xb6, 0xf7, 0x93, 0xa5,
	0x7c, 0xbd, 0xb3, 0x74, 0x79, 0x74, 0x86, 0x90, 0x6e, 0x41, 0x10, 0x56, 0x80, 0xdd, 0xf7, 0xb3,
	0x5e, 0x7f, 0xf3, 0x7d, 0xe1, 0x77, 0x44, 0x41, 0xde, 0x15, 0x9c, 0x2c, 0xe5, 0xab, 0xd4, 0x25,
	0x43, 0x84, 0xee, 0xbb, 0x49, 0x86, 0x7f, 0x03, 0xb4, 0x3f, 0xe3, 0xf5, 0xdd, 0xdb, 0x1c, 0x3e,
	0xbc, 0xd2, 0xee, 0xa8, 0xbb, 0xd8, 0x28, 0x38, 0x3f, 0xb3, 0x65, 0x05, 0xaf, 0x08, 0x2b, 0x30,
	0x17, 0x45, 0x5c, 0x00, 0xd3, 0xf7, 0x74, 0x1f, 0x71, 0x53, 0xca, 0x5b, 0xfe, 0x58, 0x6f, 0x7c,
	0xf4, 0x3d, 0x5c, 0x3e, 0xce, 0xb2, 0x1f, 0xe1, 0xee, 0xb1, 0x91, 0xcc, 0xa8, 0xc4, 0x26, 0xec,
	0xa2, 0x71, 0x82, 0x73, 0x47, 0xfe, 0x74, 0xcc, 0x24, 0xa3, 0x72, 0xe2, 0x99, 0xc9, 0x38, 0x99,
	0x78, 0xe6, 0x57, 0xb8, 0x6f, 0x1e, 0xd2, 0x34, 0xa3, 0x32, 0x4d, 0x3d, 0x95, 0xa6, 0xe3, 0x24,
	0x4d, 0x3d, 0x77, 0x71, 0x4f, 0x37, 0xfb, 0xea, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x70, 0x62,
	0xd0, 0x7d, 0x04, 0x04, 0x00, 0x00,
}
