// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package contactcenterinsights

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the options for views of a conversation.
type ConversationView int32

const (
	// Not specified. Defaults to FULL on GetConversationRequest and BASIC for
	// ListConversationsRequest.
	ConversationView_CONVERSATION_VIEW_UNSPECIFIED ConversationView = 0
	// Transcript field is not populated in the response.
	ConversationView_BASIC ConversationView = 1
	// All fields are populated.
	ConversationView_FULL ConversationView = 2
)

// Enum value maps for ConversationView.
var (
	ConversationView_name = map[int32]string{
		0: "CONVERSATION_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	ConversationView_value = map[string]int32{
		"CONVERSATION_VIEW_UNSPECIFIED": 0,
		"BASIC":                         1,
		"FULL":                          2,
	}
)

func (x ConversationView) Enum() *ConversationView {
	p := new(ConversationView)
	*p = x
	return p
}

func (x ConversationView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0].Descriptor()
}

func (ConversationView) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0]
}

func (x ConversationView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationView.Descriptor instead.
func (ConversationView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

// The request for calculating conversation statistics.
type CalculateStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the conversations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// A filter to reduce results to a specific subset. This field is useful for
	// getting statistics about conversations with specific properties.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *CalculateStatsRequest) Reset() {
	*x = CalculateStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsRequest) ProtoMessage() {}

func (x *CalculateStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

func (x *CalculateStatsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CalculateStatsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for calculating conversation statistics.
type CalculateStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The average duration of all conversations. The average is calculated using
	// only conversations that have a time duration.
	AverageDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=average_duration,json=averageDuration,proto3" json:"average_duration,omitempty"`
	// The average number of turns per conversation.
	AverageTurnCount int32 `protobuf:"varint,2,opt,name=average_turn_count,json=averageTurnCount,proto3" json:"average_turn_count,omitempty"`
	// The total number of conversations.
	ConversationCount int32 `protobuf:"varint,3,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
	// A map associating each smart highlighter display name with its respective
	// number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int32 `protobuf:"bytes,4,rep,name=smart_highlighter_matches,json=smartHighlighterMatches,proto3" json:"smart_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each custom highlighter resource name with its respective
	// number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int32 `protobuf:"bytes,5,rep,name=custom_highlighter_matches,json=customHighlighterMatches,proto3" json:"custom_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each issue resource name with its respective number of
	// matches in the set of conversations. Key has the format:
	// `projects/<Project ID>/locations/<Location ID>/issueModels/<Issue Model
	// ID>/issues/<Issue ID>`
	// Deprecated, use `issue_matches_stats` field instead.
	//
	// Deprecated: Do not use.
	IssueMatches map[string]int32 `protobuf:"bytes,6,rep,name=issue_matches,json=issueMatches,proto3" json:"issue_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A time series representing the count of conversations created over time
	// that match that requested filter criteria.
	ConversationCountTimeSeries *CalculateStatsResponse_TimeSeries `protobuf:"bytes,7,opt,name=conversation_count_time_series,json=conversationCountTimeSeries,proto3" json:"conversation_count_time_series,omitempty"`
}

func (x *CalculateStatsResponse) Reset() {
	*x = CalculateStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse) ProtoMessage() {}

func (x *CalculateStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1}
}

func (x *CalculateStatsResponse) GetAverageDuration() *durationpb.Duration {
	if x != nil {
		return x.AverageDuration
	}
	return nil
}

func (x *CalculateStatsResponse) GetAverageTurnCount() int32 {
	if x != nil {
		return x.AverageTurnCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetSmartHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.SmartHighlighterMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetCustomHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.CustomHighlighterMatches
	}
	return nil
}

// Deprecated: Do not use.
func (x *CalculateStatsResponse) GetIssueMatches() map[string]int32 {
	if x != nil {
		return x.IssueMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetConversationCountTimeSeries() *CalculateStatsResponse_TimeSeries {
	if x != nil {
		return x.ConversationCountTimeSeries
	}
	return nil
}

// Metadata for a create analysis operation.
type CreateAnalysisOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The Conversation that this Analysis Operation belongs to.
	Conversation string `protobuf:"bytes,3,opt,name=conversation,proto3" json:"conversation,omitempty"`
}

func (x *CreateAnalysisOperationMetadata) Reset() {
	*x = CreateAnalysisOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnalysisOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisOperationMetadata) ProtoMessage() {}

func (x *CreateAnalysisOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateAnalysisOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{2}
}

func (x *CreateAnalysisOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

// Request to create a conversation.
type CreateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation resource to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// A unique ID for the new conversation. This ID will become the final
	// component of the conversation's resource name. If no ID is specified, a
	// server-generated ID will be used.
	//
	// This value should be 4-32 characters and must match the regular
	// expression /^[a-z0-9-]{4,32}$/. Valid characters are /[a-z][0-9]-/
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
}

func (x *CreateConversationRequest) Reset() {
	*x = CreateConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationRequest) ProtoMessage() {}

func (x *CreateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{3}
}

func (x *CreateConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *CreateConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

// Request to list conversations.
type ListConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of conversations to return in the response. A valid page
	// size ranges from 0 to 1,000 inclusive. If the page size is zero or
	// unspecified, a default page size of 100 will be chosen. Note that a call
	// might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListConversationsResponse`. This value
	// indicates that this is a continuation of a prior `ListConversations` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The level of details of the conversation. Default is `BASIC`.
	View ConversationView `protobuf:"varint,5,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *ListConversationsRequest) Reset() {
	*x = ListConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsRequest) ProtoMessage() {}

func (x *ListConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{4}
}

func (x *ListConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConversationsRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The response of listing conversations.
type ListConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversations that match the request.
	Conversations []*Conversation `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page. If
	// this field is set, it means there is another page available. If it is not
	// set, it means no other pages are available.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationsResponse) Reset() {
	*x = ListConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsResponse) ProtoMessage() {}

func (x *ListConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{5}
}

func (x *ListConversationsResponse) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

func (x *ListConversationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a conversation.
type GetConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The level of details of the conversation. Default is `FULL`.
	View ConversationView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *GetConversationRequest) Reset() {
	*x = GetConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationRequest) ProtoMessage() {}

func (x *GetConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{6}
}

func (x *GetConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConversationRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The request to update a conversation.
type UpdateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the conversation.
	Conversation *Conversation `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversationRequest) Reset() {
	*x = UpdateConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationRequest) ProtoMessage() {}

func (x *UpdateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *UpdateConversationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a conversation.
type DeleteConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, all of this conversation's analyses will also be deleted.
	// Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConversationRequest) Reset() {
	*x = DeleteConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationRequest) ProtoMessage() {}

func (x *DeleteConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConversationRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request to create an analysis.
type CreateAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analysis.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The analysis to create.
	Analysis *Analysis `protobuf:"bytes,2,opt,name=analysis,proto3" json:"analysis,omitempty"`
}

func (x *CreateAnalysisRequest) Reset() {
	*x = CreateAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisRequest) ProtoMessage() {}

func (x *CreateAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisRequest.ProtoReflect.Descriptor instead.
func (*CreateAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{9}
}

func (x *CreateAnalysisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnalysisRequest) GetAnalysis() *Analysis {
	if x != nil {
		return x.Analysis
	}
	return nil
}

// The request to list analyses.
type ListAnalysesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analyses.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of analyses to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListAnalysesResponse`; indicates
	// that this is a continuation of a prior `ListAnalyses` call and
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAnalysesRequest) Reset() {
	*x = ListAnalysesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesRequest) ProtoMessage() {}

func (x *ListAnalysesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesRequest.ProtoReflect.Descriptor instead.
func (*ListAnalysesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{10}
}

func (x *ListAnalysesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnalysesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnalysesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnalysesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response to list analyses.
type ListAnalysesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analyses that match the request.
	Analyses []*Analysis `protobuf:"bytes,1,rep,name=analyses,proto3" json:"analyses,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnalysesResponse) Reset() {
	*x = ListAnalysesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesResponse) ProtoMessage() {}

func (x *ListAnalysesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesResponse.ProtoReflect.Descriptor instead.
func (*ListAnalysesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11}
}

func (x *ListAnalysesResponse) GetAnalyses() []*Analysis {
	if x != nil {
		return x.Analyses
	}
	return nil
}

func (x *ListAnalysesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get an analysis.
type GetAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnalysisRequest) Reset() {
	*x = GetAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnalysisRequest) ProtoMessage() {}

func (x *GetAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnalysisRequest.ProtoReflect.Descriptor instead.
func (*GetAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{12}
}

func (x *GetAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an analysis.
type DeleteAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnalysisRequest) Reset() {
	*x = DeleteAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnalysisRequest) ProtoMessage() {}

func (x *DeleteAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnalysisRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to export insights.
type ExportInsightsDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exporter destination.
	//
	// Types that are assignable to Destination:
	//	*ExportInsightsDataRequest_BigQueryDestination_
	Destination isExportInsightsDataRequest_Destination `protobuf_oneof:"destination"`
	// Required. The parent resource to export data from.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter to reduce results to a specific subset. Useful for exporting
	// conversations with specific properties.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// A fully qualified KMS key name for BigQuery tables protected by CMEK.
	// Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
	KmsKey string `protobuf:"bytes,4,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *ExportInsightsDataRequest) Reset() {
	*x = ExportInsightsDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest) ProtoMessage() {}

func (x *ExportInsightsDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{14}
}

func (m *ExportInsightsDataRequest) GetDestination() isExportInsightsDataRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetBigQueryDestination() *ExportInsightsDataRequest_BigQueryDestination {
	if x, ok := x.GetDestination().(*ExportInsightsDataRequest_BigQueryDestination_); ok {
		return x.BigQueryDestination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

type isExportInsightsDataRequest_Destination interface {
	isExportInsightsDataRequest_Destination()
}

type ExportInsightsDataRequest_BigQueryDestination_ struct {
	// Specified if sink is a BigQuery table.
	BigQueryDestination *ExportInsightsDataRequest_BigQueryDestination `protobuf:"bytes,2,opt,name=big_query_destination,json=bigQueryDestination,proto3,oneof"`
}

func (*ExportInsightsDataRequest_BigQueryDestination_) isExportInsightsDataRequest_Destination() {}

// Metadata for an export insights operation.
type ExportInsightsDataMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for export.
	Request *ExportInsightsDataRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during export operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *ExportInsightsDataMetadata) Reset() {
	*x = ExportInsightsDataMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataMetadata) ProtoMessage() {}

func (x *ExportInsightsDataMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataMetadata.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{15}
}

func (x *ExportInsightsDataMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetRequest() *ExportInsightsDataRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// Response for an export insights operation.
type ExportInsightsDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportInsightsDataResponse) Reset() {
	*x = ExportInsightsDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataResponse) ProtoMessage() {}

func (x *ExportInsightsDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataResponse.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{16}
}

// The request to create an issue model.
type CreateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The issue model to create.
	IssueModel *IssueModel `protobuf:"bytes,2,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CreateIssueModelRequest) Reset() {
	*x = CreateIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelRequest) ProtoMessage() {}

func (x *CreateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*CreateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{17}
}

func (x *CreateIssueModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

// Metadata for creating an issue model.
type CreateIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for creation.
	Request *CreateIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *CreateIssueModelMetadata) Reset() {
	*x = CreateIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelMetadata) ProtoMessage() {}

func (x *CreateIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*CreateIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{18}
}

func (x *CreateIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetRequest() *CreateIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to update an issue model.
type UpdateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue model.
	IssueModel *IssueModel `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueModelRequest) Reset() {
	*x = UpdateIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueModelRequest) ProtoMessage() {}

func (x *UpdateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{19}
}

func (x *UpdateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

func (x *UpdateIssueModelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list issue models.
type ListIssueModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssueModelsRequest) Reset() {
	*x = ListIssueModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssueModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsRequest) ProtoMessage() {}

func (x *ListIssueModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsRequest.ProtoReflect.Descriptor instead.
func (*ListIssueModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{20}
}

func (x *ListIssueModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issue models.
type ListIssueModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issue models that match the request.
	IssueModels []*IssueModel `protobuf:"bytes,1,rep,name=issue_models,json=issueModels,proto3" json:"issue_models,omitempty"`
}

func (x *ListIssueModelsResponse) Reset() {
	*x = ListIssueModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssueModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsResponse) ProtoMessage() {}

func (x *ListIssueModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsResponse.ProtoReflect.Descriptor instead.
func (*ListIssueModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{21}
}

func (x *ListIssueModelsResponse) GetIssueModels() []*IssueModel {
	if x != nil {
		return x.IssueModels
	}
	return nil
}

// The request to get an issue model.
type GetIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueModelRequest) Reset() {
	*x = GetIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueModelRequest) ProtoMessage() {}

func (x *GetIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueModelRequest.ProtoReflect.Descriptor instead.
func (*GetIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{22}
}

func (x *GetIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an issue model.
type DeleteIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIssueModelRequest) Reset() {
	*x = DeleteIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelRequest) ProtoMessage() {}

func (x *DeleteIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata for deleting an issue model.
type DeleteIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deletion.
	Request *DeleteIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeleteIssueModelMetadata) Reset() {
	*x = DeleteIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelMetadata) ProtoMessage() {}

func (x *DeleteIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetRequest() *DeleteIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to deploy an issue model.
type DeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to deploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployIssueModelRequest) Reset() {
	*x = DeployIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelRequest) ProtoMessage() {}

func (x *DeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25}
}

func (x *DeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to deploy an issue model.
type DeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployIssueModelResponse) Reset() {
	*x = DeployIssueModelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelResponse) ProtoMessage() {}

func (x *DeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*DeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{26}
}

// Metadata for deploying an issue model.
type DeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deployment.
	Request *DeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeployIssueModelMetadata) Reset() {
	*x = DeployIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelMetadata) ProtoMessage() {}

func (x *DeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{27}
}

func (x *DeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetRequest() *DeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to undeploy an issue model.
type UndeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to undeploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployIssueModelRequest) Reset() {
	*x = UndeployIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelRequest) ProtoMessage() {}

func (x *UndeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{28}
}

func (x *UndeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to undeploy an issue model.
type UndeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployIssueModelResponse) Reset() {
	*x = UndeployIssueModelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelResponse) ProtoMessage() {}

func (x *UndeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{29}
}

// Metadata for undeploying an issue model.
type UndeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for undeployment.
	Request *UndeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *UndeployIssueModelMetadata) Reset() {
	*x = UndeployIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelMetadata) ProtoMessage() {}

func (x *UndeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{30}
}

func (x *UndeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetRequest() *UndeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to get an issue.
type GetIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueRequest) Reset() {
	*x = GetIssueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueRequest) ProtoMessage() {}

func (x *GetIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueRequest.ProtoReflect.Descriptor instead.
func (*GetIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{31}
}

func (x *GetIssueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list issues.
type ListIssuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssuesRequest) Reset() {
	*x = ListIssuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesRequest) ProtoMessage() {}

func (x *ListIssuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesRequest.ProtoReflect.Descriptor instead.
func (*ListIssuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{32}
}

func (x *ListIssuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issues.
type ListIssuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issues that match the request.
	Issues []*Issue `protobuf:"bytes,1,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (x *ListIssuesResponse) Reset() {
	*x = ListIssuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesResponse) ProtoMessage() {}

func (x *ListIssuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesResponse.ProtoReflect.Descriptor instead.
func (*ListIssuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{33}
}

func (x *ListIssuesResponse) GetIssues() []*Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

// The request to update an issue.
type UpdateIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue.
	Issue *Issue `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueRequest) Reset() {
	*x = UpdateIssueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueRequest) ProtoMessage() {}

func (x *UpdateIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{34}
}

func (x *UpdateIssueRequest) GetIssue() *Issue {
	if x != nil {
		return x.Issue
	}
	return nil
}

func (x *UpdateIssueRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to get statistics of an issue model.
type CalculateIssueModelStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the issue model to query against.
	IssueModel string `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CalculateIssueModelStatsRequest) Reset() {
	*x = CalculateIssueModelStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateIssueModelStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsRequest) ProtoMessage() {}

func (x *CalculateIssueModelStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{35}
}

func (x *CalculateIssueModelStatsRequest) GetIssueModel() string {
	if x != nil {
		return x.IssueModel
	}
	return ""
}

// Response of querying an issue model's statistics.
type CalculateIssueModelStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The latest label statistics for the queried issue model. Includes results
	// on both training data and data labeled after deployment.
	CurrentStats *IssueModelLabelStats `protobuf:"bytes,4,opt,name=current_stats,json=currentStats,proto3" json:"current_stats,omitempty"`
}

func (x *CalculateIssueModelStatsResponse) Reset() {
	*x = CalculateIssueModelStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateIssueModelStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsResponse) ProtoMessage() {}

func (x *CalculateIssueModelStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{36}
}

func (x *CalculateIssueModelStatsResponse) GetCurrentStats() *IssueModelLabelStats {
	if x != nil {
		return x.CurrentStats
	}
	return nil
}

// Request to create a phrase matcher.
type CreatePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher. Required. The location to create
	// a phrase matcher for.
	// Format: `projects/<Project ID>/locations/<Location ID>` or
	// `projects/<Project Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The phrase matcher resource to create.
	PhraseMatcher *PhraseMatcher `protobuf:"bytes,2,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
}

func (x *CreatePhraseMatcherRequest) Reset() {
	*x = CreatePhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhraseMatcherRequest) ProtoMessage() {}

func (x *CreatePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*CreatePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{37}
}

func (x *CreatePhraseMatcherRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePhraseMatcherRequest) GetPhraseMatcher() *PhraseMatcher {
	if x != nil {
		return x.PhraseMatcher
	}
	return nil
}

// Request to list phrase matchers.
type ListPhraseMatchersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of phrase matchers to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListPhraseMatchersResponse`. This value
	// indicates that this is a continuation of a prior `ListPhraseMatchers` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// phrase matchers with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPhraseMatchersRequest) Reset() {
	*x = ListPhraseMatchersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseMatchersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersRequest) ProtoMessage() {}

func (x *ListPhraseMatchersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersRequest.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{38}
}

func (x *ListPhraseMatchersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhraseMatchersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response of listing phrase matchers.
type ListPhraseMatchersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase matchers that match the request.
	PhraseMatchers []*PhraseMatcher `protobuf:"bytes,1,rep,name=phrase_matchers,json=phraseMatchers,proto3" json:"phrase_matchers,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhraseMatchersResponse) Reset() {
	*x = ListPhraseMatchersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseMatchersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersResponse) ProtoMessage() {}

func (x *ListPhraseMatchersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersResponse.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{39}
}

func (x *ListPhraseMatchersResponse) GetPhraseMatchers() []*PhraseMatcher {
	if x != nil {
		return x.PhraseMatchers
	}
	return nil
}

func (x *ListPhraseMatchersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a a phrase matcher.
type GetPhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPhraseMatcherRequest) Reset() {
	*x = GetPhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhraseMatcherRequest) ProtoMessage() {}

func (x *GetPhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*GetPhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{40}
}

func (x *GetPhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete a phrase matcher.
type DeletePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePhraseMatcherRequest) Reset() {
	*x = DeletePhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhraseMatcherRequest) ProtoMessage() {}

func (x *DeletePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*DeletePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{41}
}

func (x *DeletePhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to get project-level settings.
type GetSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSettingsRequest) Reset() {
	*x = GetSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingsRequest) ProtoMessage() {}

func (x *GetSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{42}
}

func (x *GetSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update project-level settings.
type UpdateSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new settings values.
	Settings *Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSettingsRequest) Reset() {
	*x = UpdateSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingsRequest) ProtoMessage() {}

func (x *UpdateSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{43}
}

func (x *UpdateSettingsRequest) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A time series representing conversations over time.
type CalculateStatsResponse_TimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration of each interval.
	IntervalDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=interval_duration,json=intervalDuration,proto3" json:"interval_duration,omitempty"`
	// An ordered list of intervals from earliest to latest, where each interval
	// represents the number of conversations that transpired during the time
	// window.
	Points []*CalculateStatsResponse_TimeSeries_Interval `protobuf:"bytes,2,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries) Reset() {
	*x = CalculateStatsResponse_TimeSeries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse_TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CalculateStatsResponse_TimeSeries) GetIntervalDuration() *durationpb.Duration {
	if x != nil {
		return x.IntervalDuration
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries) GetPoints() []*CalculateStatsResponse_TimeSeries_Interval {
	if x != nil {
		return x.Points
	}
	return nil
}

// A single interval in a time series.
type CalculateStatsResponse_TimeSeries_Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of this interval.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The number of conversations created in this interval.
	ConversationCount int32 `protobuf:"varint,2,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries_Interval) Reset() {
	*x = CalculateStatsResponse_TimeSeries_Interval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse_TimeSeries_Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries_Interval) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries_Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries_Interval.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries_Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

// A BigQuery Table Reference.
type ExportInsightsDataRequest_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise,
	// the resource project will be used.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the BigQuery dataset that the snapshot result should be
	// exported to. If this dataset does not exist, the export call returns an
	// INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *ExportInsightsDataRequest_BigQueryDestination) Reset() {
	*x = ExportInsightsDataRequest_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataRequest_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest_BigQueryDestination) ProtoMessage() {}

func (x *ExportInsightsDataRequest_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

var File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto protoreflect.FileDescriptor

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x76, 0x0a, 0x15, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8c, 0x0a, 0x0a,
	0x16, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a,
	0x12, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x19, 0x73,
	0x6d, 0x61, 0x72, 0x74, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6d,
	0x61, 0x72, 0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x73, 0x6d, 0x61, 0x72,
	0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x12, 0x99, 0x01, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x68,
	0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69,
	0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67,
	0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12,
	0x78, 0x0a, 0x0d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x1e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x1b, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xb5, 0x02, 0x0a, 0x0a, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x69, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x74, 0x0a, 0x08, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0x4a, 0x0a, 0x1c, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69,
	0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4b, 0x0a,
	0x1d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74,
	0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfe, 0x01, 0x0a, 0x1f,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x01, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0xfe, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb4, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xb6, 0x01,
	0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x80, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8b, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4b, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x03, 0x0a, 0x19, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8a, 0x01, 0x0a, 0x15, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x13, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x17, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x1a, 0x69, 0x0a, 0x13, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x02, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x5a, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xf2, 0x01,
	0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57,
	0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x22, 0x6f, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x22, 0x63, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xf2, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf2, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x68, 0x0a,
	0x19, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf6, 0x01, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x59,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22,
	0x5a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x12,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7b, 0x0a, 0x1f, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0b, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x84, 0x01, 0x0a, 0x20, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x0d, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0c,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0xc1, 0x01, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x22, 0xb2, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x69, 0x0a, 0x17, 0x47,
	0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x2a, 0x4a, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4e, 0x56, 0x45,
	0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41,
	0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x32,
	0xd6, 0x31, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0xfa, 0x01, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0xfc, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x32, 0x3e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0c, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x18, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb0, 0x01, 0x0a,
	0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xfe, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8e, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x3a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0xca, 0x41, 0x2b, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0xb3, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xfe, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41,
	0x38, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf6, 0x01, 0x0a, 0x10, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x3a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0xca, 0x41, 0x26, 0x0a, 0x0a, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4a, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0xda, 0x41, 0x17, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbf, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd2, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe5, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0xca, 0x41, 0x31, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf2, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xfd, 0x01, 0x0a, 0x12, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x85, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca,
	0x41, 0x38, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a,
	0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb9, 0x01, 0x0a, 0x08, 0x47,
	0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x22, 0x47, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcc, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x22, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x32, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0xda, 0x41, 0x11,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0x92, 0x02, 0x0a, 0x18, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0xda, 0x41, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0xf2, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x62, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x22,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x73, 0x3a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0xcb, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb3, 0x01, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xe4, 0x01, 0x0a, 0x0e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x63, 0x61,
	0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0xda, 0x41, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xb4, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdd,
	0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x08, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x14, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x1a, 0x58,
	0xca, 0x41, 0x24, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa0, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce sync.Once
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc
)

func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP() []byte {
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce.Do(func() {
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData)
	})
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData
}

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = []interface{}{
	(ConversationView)(0),                     // 0: google.cloud.contactcenterinsights.v1.ConversationView
	(*CalculateStatsRequest)(nil),             // 1: google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	(*CalculateStatsResponse)(nil),            // 2: google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	(*CreateAnalysisOperationMetadata)(nil),   // 3: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata
	(*CreateConversationRequest)(nil),         // 4: google.cloud.contactcenterinsights.v1.CreateConversationRequest
	(*ListConversationsRequest)(nil),          // 5: google.cloud.contactcenterinsights.v1.ListConversationsRequest
	(*ListConversationsResponse)(nil),         // 6: google.cloud.contactcenterinsights.v1.ListConversationsResponse
	(*GetConversationRequest)(nil),            // 7: google.cloud.contactcenterinsights.v1.GetConversationRequest
	(*UpdateConversationRequest)(nil),         // 8: google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	(*DeleteConversationRequest)(nil),         // 9: google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	(*CreateAnalysisRequest)(nil),             // 10: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	(*ListAnalysesRequest)(nil),               // 11: google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	(*ListAnalysesResponse)(nil),              // 12: google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	(*GetAnalysisRequest)(nil),                // 13: google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	(*DeleteAnalysisRequest)(nil),             // 14: google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	(*ExportInsightsDataRequest)(nil),         // 15: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	(*ExportInsightsDataMetadata)(nil),        // 16: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata
	(*ExportInsightsDataResponse)(nil),        // 17: google.cloud.contactcenterinsights.v1.ExportInsightsDataResponse
	(*CreateIssueModelRequest)(nil),           // 18: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	(*CreateIssueModelMetadata)(nil),          // 19: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata
	(*UpdateIssueModelRequest)(nil),           // 20: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	(*ListIssueModelsRequest)(nil),            // 21: google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	(*ListIssueModelsResponse)(nil),           // 22: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	(*GetIssueModelRequest)(nil),              // 23: google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	(*DeleteIssueModelRequest)(nil),           // 24: google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	(*DeleteIssueModelMetadata)(nil),          // 25: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata
	(*DeployIssueModelRequest)(nil),           // 26: google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	(*DeployIssueModelResponse)(nil),          // 27: google.cloud.contactcenterinsights.v1.DeployIssueModelResponse
	(*DeployIssueModelMetadata)(nil),          // 28: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata
	(*UndeployIssueModelRequest)(nil),         // 29: google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	(*UndeployIssueModelResponse)(nil),        // 30: google.cloud.contactcenterinsights.v1.UndeployIssueModelResponse
	(*UndeployIssueModelMetadata)(nil),        // 31: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata
	(*GetIssueRequest)(nil),                   // 32: google.cloud.contactcenterinsights.v1.GetIssueRequest
	(*ListIssuesRequest)(nil),                 // 33: google.cloud.contactcenterinsights.v1.ListIssuesRequest
	(*ListIssuesResponse)(nil),                // 34: google.cloud.contactcenterinsights.v1.ListIssuesResponse
	(*UpdateIssueRequest)(nil),                // 35: google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	(*CalculateIssueModelStatsRequest)(nil),   // 36: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	(*CalculateIssueModelStatsResponse)(nil),  // 37: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	(*CreatePhraseMatcherRequest)(nil),        // 38: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	(*ListPhraseMatchersRequest)(nil),         // 39: google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	(*ListPhraseMatchersResponse)(nil),        // 40: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	(*GetPhraseMatcherRequest)(nil),           // 41: google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	(*DeletePhraseMatcherRequest)(nil),        // 42: google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	(*GetSettingsRequest)(nil),                // 43: google.cloud.contactcenterinsights.v1.GetSettingsRequest
	(*UpdateSettingsRequest)(nil),             // 44: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	(*CalculateStatsResponse_TimeSeries)(nil), // 45: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	nil, // 46: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	nil, // 47: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	nil, // 48: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	(*CalculateStatsResponse_TimeSeries_Interval)(nil),    // 49: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	(*ExportInsightsDataRequest_BigQueryDestination)(nil), // 50: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	(*durationpb.Duration)(nil),                           // 51: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                         // 52: google.protobuf.Timestamp
	(*Conversation)(nil),                                  // 53: google.cloud.contactcenterinsights.v1.Conversation
	(*fieldmaskpb.FieldMask)(nil),                         // 54: google.protobuf.FieldMask
	(*Analysis)(nil),                                      // 55: google.cloud.contactcenterinsights.v1.Analysis
	(*status.Status)(nil),                                 // 56: google.rpc.Status
	(*IssueModel)(nil),                                    // 57: google.cloud.contactcenterinsights.v1.IssueModel
	(*Issue)(nil),                                         // 58: google.cloud.contactcenterinsights.v1.Issue
	(*IssueModelLabelStats)(nil),                          // 59: google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	(*PhraseMatcher)(nil),                                 // 60: google.cloud.contactcenterinsights.v1.PhraseMatcher
	(*Settings)(nil),                                      // 61: google.cloud.contactcenterinsights.v1.Settings
	(*emptypb.Empty)(nil),                                 // 62: google.protobuf.Empty
	(*longrunning.Operation)(nil),                         // 63: google.longrunning.Operation
}
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = []int32{
	51, // 0: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.average_duration:type_name -> google.protobuf.Duration
	46, // 1: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.smart_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	47, // 2: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.custom_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	48, // 3: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.issue_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	45, // 4: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.conversation_count_time_series:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	52, // 5: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 6: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	53, // 7: google.cloud.contactcenterinsights.v1.CreateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	0,  // 8: google.cloud.contactcenterinsights.v1.ListConversationsRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	53, // 9: google.cloud.contactcenterinsights.v1.ListConversationsResponse.conversations:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	0,  // 10: google.cloud.contactcenterinsights.v1.GetConversationRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	53, // 11: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	54, // 12: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.update_mask:type_name -> google.protobuf.FieldMask
	55, // 13: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest.analysis:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	55, // 14: google.cloud.contactcenterinsights.v1.ListAnalysesResponse.analyses:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	50, // 15: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.big_query_destination:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	52, // 16: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 17: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.end_time:type_name -> google.protobuf.Timestamp
	15, // 18: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	56, // 19: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.partial_errors:type_name -> google.rpc.Status
	57, // 20: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	52, // 21: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 22: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	18, // 23: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	57, // 24: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	54, // 25: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.update_mask:type_name -> google.protobuf.FieldMask
	57, // 26: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse.issue_models:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	52, // 27: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 28: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	24, // 29: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	52, // 30: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 31: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	26, // 32: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	52, // 33: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 34: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	29, // 35: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	58, // 36: google.cloud.contactcenterinsights.v1.ListIssuesResponse.issues:type_name -> google.cloud.contactcenterinsights.v1.Issue
	58, // 37: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.issue:type_name -> google.cloud.contactcenterinsights.v1.Issue
	54, // 38: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.update_mask:type_name -> google.protobuf.FieldMask
	59, // 39: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse.current_stats:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	60, // 40: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest.phrase_matcher:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	60, // 41: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse.phrase_matchers:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	61, // 42: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.settings:type_name -> google.cloud.contactcenterinsights.v1.Settings
	54, // 43: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 44: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.interval_duration:type_name -> google.protobuf.Duration
	49, // 45: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.points:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	52, // 46: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval.start_time:type_name -> google.protobuf.Timestamp
	4,  // 47: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:input_type -> google.cloud.contactcenterinsights.v1.CreateConversationRequest
	8,  // 48: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:input_type -> google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	7,  // 49: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:input_type -> google.cloud.contactcenterinsights.v1.GetConversationRequest
	5,  // 50: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:input_type -> google.cloud.contactcenterinsights.v1.ListConversationsRequest
	9,  // 51: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:input_type -> google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	10, // 52: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:input_type -> google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	13, // 53: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:input_type -> google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	11, // 54: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:input_type -> google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	14, // 55: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:input_type -> google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	15, // 56: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:input_type -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	18, // 57: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	20, // 58: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	23, // 59: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:input_type -> google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	21, // 60: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:input_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	24, // 61: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	26, // 62: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	29, // 63: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	32, // 64: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:input_type -> google.cloud.contactcenterinsights.v1.GetIssueRequest
	33, // 65: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:input_type -> google.cloud.contactcenterinsights.v1.ListIssuesRequest
	35, // 66: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	36, // 67: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	38, // 68: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	41, // 69: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	39, // 70: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:input_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	42, // 71: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	1,  // 72: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	43, // 73: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:input_type -> google.cloud.contactcenterinsights.v1.GetSettingsRequest
	44, // 74: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:input_type -> google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	53, // 75: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	53, // 76: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	53, // 77: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	6,  // 78: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:output_type -> google.cloud.contactcenterinsights.v1.ListConversationsResponse
	62, // 79: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:output_type -> google.protobuf.Empty
	63, // 80: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:output_type -> google.longrunning.Operation
	55, // 81: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:output_type -> google.cloud.contactcenterinsights.v1.Analysis
	12, // 82: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:output_type -> google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	62, // 83: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:output_type -> google.protobuf.Empty
	63, // 84: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:output_type -> google.longrunning.Operation
	63, // 85: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:output_type -> google.longrunning.Operation
	57, // 86: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	57, // 87: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	22, // 88: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:output_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	63, // 89: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:output_type -> google.longrunning.Operation
	63, // 90: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:output_type -> google.longrunning.Operation
	63, // 91: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:output_type -> google.longrunning.Operation
	58, // 92: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	34, // 93: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:output_type -> google.cloud.contactcenterinsights.v1.ListIssuesResponse
	58, // 94: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	37, // 95: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	60, // 96: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	60, // 97: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	40, // 98: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:output_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	62, // 99: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:output_type -> google.protobuf.Empty
	2,  // 100: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	61, // 101: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	61, // 102: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	75, // [75:103] is the sub-list for method output_type
	47, // [47:75] is the sub-list for method input_type
	47, // [47:47] is the sub-list for extension type_name
	47, // [47:47] is the sub-list for extension extendee
	0,  // [0:47] is the sub-list for field type_name
}

func init() { file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() }
func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() {
	if File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto != nil {
		return
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnalysisOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssueModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssueModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIssueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIssueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateIssueModelStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateIssueModelStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseMatchersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseMatchersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse_TimeSeries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse_TimeSeries_Interval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataRequest_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*ExportInsightsDataRequest_BigQueryDestination_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes,
		DependencyIndexes: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs,
		EnumInfos:         file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes,
		MessageInfos:      file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes,
	}.Build()
	File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto = out.File
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ContactCenterInsightsClient is the client API for ContactCenterInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContactCenterInsightsClient interface {
	// Creates a conversation.
	CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Updates a conversation.
	UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Gets a conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Lists conversations.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an analysis.
	GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates an issue model.
	CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an issue.
	GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Lists issues.
	ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets conversation statistics.
	CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
}

type contactCenterInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewContactCenterInsightsClient(cc grpc.ClientConnInterface) ContactCenterInsightsClient {
	return &contactCenterInsightsClient{cc}
}

func (c *contactCenterInsightsClient) CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error) {
	out := new(Analysis)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error) {
	out := new(ListAnalysesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalyses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportInsightsData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error) {
	out := new(ListIssueModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssueModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error) {
	out := new(ListIssuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error) {
	out := new(CalculateIssueModelStatsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateIssueModelStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreatePhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetPhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error) {
	out := new(ListPhraseMatchersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListPhraseMatchers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeletePhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error) {
	out := new(CalculateStatsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContactCenterInsightsServer is the server API for ContactCenterInsights service.
type ContactCenterInsightsServer interface {
	// Creates a conversation.
	CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error)
	// Updates a conversation.
	UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error)
	// Gets a conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Lists conversations.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunning.Operation, error)
	// Gets an analysis.
	GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunning.Operation, error)
	// Creates an issue model.
	CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunning.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunning.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunning.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunning.Operation, error)
	// Gets an issue.
	GetIssue(context.Context, *GetIssueRequest) (*Issue, error)
	// Lists issues.
	ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error)
	// Gets conversation statistics.
	CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
}

// UnimplementedContactCenterInsightsServer can be embedded to have forward compatible implementations.
type UnimplementedContactCenterInsightsServer struct {
}

func (*UnimplementedContactCenterInsightsServer) CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAnalyses not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportInsightsData not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIssueModels not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeployIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeployIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetIssue(context.Context, *GetIssueRequest) (*Issue, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIssue not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIssues not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIssue not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CalculateIssueModelStats not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreatePhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetPhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListPhraseMatchers not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeletePhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CalculateStats not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}

func RegisterContactCenterInsightsServer(s *grpc.Server, srv ContactCenterInsightsServer) {
	s.RegisterService(&_ContactCenterInsights_serviceDesc, srv)
}

func _ContactCenterInsights_CreateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, req.(*CreateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, req.(*UpdateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, req.(*DeleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, req.(*CreateAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, req.(*GetAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListAnalyses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnalysesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalyses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, req.(*ListAnalysesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, req.(*DeleteAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ExportInsightsData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInsightsDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportInsightsData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, req.(*ExportInsightsDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, req.(*CreateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, req.(*UpdateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, req.(*GetIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssueModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssueModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssueModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, req.(*ListIssueModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, req.(*DeleteIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, req.(*DeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UndeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, req.(*UndeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, req.(*GetIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, req.(*ListIssuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, req.(*UpdateIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateIssueModelStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateIssueModelStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateIssueModelStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, req.(*CalculateIssueModelStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreatePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreatePhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, req.(*CreatePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetPhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetPhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, req.(*GetPhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListPhraseMatchers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseMatchersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListPhraseMatchers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, req.(*ListPhraseMatchersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeletePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeletePhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, req.(*DeletePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, req.(*CalculateStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContactCenterInsights_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
	HandlerType: (*ContactCenterInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversation",
			Handler:    _ContactCenterInsights_CreateConversation_Handler,
		},
		{
			MethodName: "UpdateConversation",
			Handler:    _ContactCenterInsights_UpdateConversation_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _ContactCenterInsights_GetConversation_Handler,
		},
		{
			MethodName: "ListConversations",
			Handler:    _ContactCenterInsights_ListConversations_Handler,
		},
		{
			MethodName: "DeleteConversation",
			Handler:    _ContactCenterInsights_DeleteConversation_Handler,
		},
		{
			MethodName: "CreateAnalysis",
			Handler:    _ContactCenterInsights_CreateAnalysis_Handler,
		},
		{
			MethodName: "GetAnalysis",
			Handler:    _ContactCenterInsights_GetAnalysis_Handler,
		},
		{
			MethodName: "ListAnalyses",
			Handler:    _ContactCenterInsights_ListAnalyses_Handler,
		},
		{
			MethodName: "DeleteAnalysis",
			Handler:    _ContactCenterInsights_DeleteAnalysis_Handler,
		},
		{
			MethodName: "ExportInsightsData",
			Handler:    _ContactCenterInsights_ExportInsightsData_Handler,
		},
		{
			MethodName: "CreateIssueModel",
			Handler:    _ContactCenterInsights_CreateIssueModel_Handler,
		},
		{
			MethodName: "UpdateIssueModel",
			Handler:    _ContactCenterInsights_UpdateIssueModel_Handler,
		},
		{
			MethodName: "GetIssueModel",
			Handler:    _ContactCenterInsights_GetIssueModel_Handler,
		},
		{
			MethodName: "ListIssueModels",
			Handler:    _ContactCenterInsights_ListIssueModels_Handler,
		},
		{
			MethodName: "DeleteIssueModel",
			Handler:    _ContactCenterInsights_DeleteIssueModel_Handler,
		},
		{
			MethodName: "DeployIssueModel",
			Handler:    _ContactCenterInsights_DeployIssueModel_Handler,
		},
		{
			MethodName: "UndeployIssueModel",
			Handler:    _ContactCenterInsights_UndeployIssueModel_Handler,
		},
		{
			MethodName: "GetIssue",
			Handler:    _ContactCenterInsights_GetIssue_Handler,
		},
		{
			MethodName: "ListIssues",
			Handler:    _ContactCenterInsights_ListIssues_Handler,
		},
		{
			MethodName: "UpdateIssue",
			Handler:    _ContactCenterInsights_UpdateIssue_Handler,
		},
		{
			MethodName: "CalculateIssueModelStats",
			Handler:    _ContactCenterInsights_CalculateIssueModelStats_Handler,
		},
		{
			MethodName: "CreatePhraseMatcher",
			Handler:    _ContactCenterInsights_CreatePhraseMatcher_Handler,
		},
		{
			MethodName: "GetPhraseMatcher",
			Handler:    _ContactCenterInsights_GetPhraseMatcher_Handler,
		},
		{
			MethodName: "ListPhraseMatchers",
			Handler:    _ContactCenterInsights_ListPhraseMatchers_Handler,
		},
		{
			MethodName: "DeletePhraseMatcher",
			Handler:    _ContactCenterInsights_DeletePhraseMatcher_Handler,
		},
		{
			MethodName: "CalculateStats",
			Handler:    _ContactCenterInsights_CalculateStats_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _ContactCenterInsights_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _ContactCenterInsights_UpdateSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/contactcenterinsights/v1/contact_center_insights.proto",
}
