// automatically generated by stateify.

//go:build !check_invariants
// +build !check_invariants

package vfs

import (
	"gvisor.dev/gvisor/pkg/state"
)

func (a *anonFilesystemType) StateTypeName() string {
	return "pkg/sentry/vfs.anonFilesystemType"
}

func (a *anonFilesystemType) StateFields() []string {
	return []string{}
}

func (a *anonFilesystemType) beforeSave() {}

// +checklocksignore
func (a *anonFilesystemType) StateSave(stateSinkObject state.Sink) {
	a.beforeSave()
}

func (a *anonFilesystemType) afterLoad() {}

// +checklocksignore
func (a *anonFilesystemType) StateLoad(stateSourceObject state.Source) {
}

func (fs *anonFilesystem) StateTypeName() string {
	return "pkg/sentry/vfs.anonFilesystem"
}

func (fs *anonFilesystem) StateFields() []string {
	return []string{
		"vfsfs",
		"devMinor",
	}
}

func (fs *anonFilesystem) beforeSave() {}

// +checklocksignore
func (fs *anonFilesystem) StateSave(stateSinkObject state.Sink) {
	fs.beforeSave()
	stateSinkObject.Save(0, &fs.vfsfs)
	stateSinkObject.Save(1, &fs.devMinor)
}

func (fs *anonFilesystem) afterLoad() {}

// +checklocksignore
func (fs *anonFilesystem) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fs.vfsfs)
	stateSourceObject.Load(1, &fs.devMinor)
}

func (d *anonDentry) StateTypeName() string {
	return "pkg/sentry/vfs.anonDentry"
}

func (d *anonDentry) StateFields() []string {
	return []string{
		"vfsd",
		"name",
		"watches",
	}
}

func (d *anonDentry) beforeSave() {}

// +checklocksignore
func (d *anonDentry) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.vfsd)
	stateSinkObject.Save(1, &d.name)
	stateSinkObject.Save(2, &d.watches)
}

func (d *anonDentry) afterLoad() {}

// +checklocksignore
func (d *anonDentry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.vfsd)
	stateSourceObject.Load(1, &d.name)
	stateSourceObject.Load(2, &d.watches)
}

func (d *Dentry) StateTypeName() string {
	return "pkg/sentry/vfs.Dentry"
}

func (d *Dentry) StateFields() []string {
	return []string{
		"dead",
		"evictable",
		"mounts",
		"impl",
	}
}

func (d *Dentry) beforeSave() {}

// +checklocksignore
func (d *Dentry) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.dead)
	stateSinkObject.Save(1, &d.evictable)
	stateSinkObject.Save(2, &d.mounts)
	stateSinkObject.Save(3, &d.impl)
}

func (d *Dentry) afterLoad() {}

// +checklocksignore
func (d *Dentry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.dead)
	stateSourceObject.Load(1, &d.evictable)
	stateSourceObject.Load(2, &d.mounts)
	stateSourceObject.Load(3, &d.impl)
}

func (kind *DeviceKind) StateTypeName() string {
	return "pkg/sentry/vfs.DeviceKind"
}

func (kind *DeviceKind) StateFields() []string {
	return nil
}

func (d *devTuple) StateTypeName() string {
	return "pkg/sentry/vfs.devTuple"
}

func (d *devTuple) StateFields() []string {
	return []string{
		"kind",
		"major",
		"minor",
	}
}

func (d *devTuple) beforeSave() {}

// +checklocksignore
func (d *devTuple) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.kind)
	stateSinkObject.Save(1, &d.major)
	stateSinkObject.Save(2, &d.minor)
}

func (d *devTuple) afterLoad() {}

// +checklocksignore
func (d *devTuple) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.kind)
	stateSourceObject.Load(1, &d.major)
	stateSourceObject.Load(2, &d.minor)
}

func (r *registeredDevice) StateTypeName() string {
	return "pkg/sentry/vfs.registeredDevice"
}

func (r *registeredDevice) StateFields() []string {
	return []string{
		"dev",
		"opts",
	}
}

func (r *registeredDevice) beforeSave() {}

// +checklocksignore
func (r *registeredDevice) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.dev)
	stateSinkObject.Save(1, &r.opts)
}

func (r *registeredDevice) afterLoad() {}

// +checklocksignore
func (r *registeredDevice) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.dev)
	stateSourceObject.Load(1, &r.opts)
}

func (r *RegisterDeviceOptions) StateTypeName() string {
	return "pkg/sentry/vfs.RegisterDeviceOptions"
}

func (r *RegisterDeviceOptions) StateFields() []string {
	return []string{
		"GroupName",
	}
}

func (r *RegisterDeviceOptions) beforeSave() {}

// +checklocksignore
func (r *RegisterDeviceOptions) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.GroupName)
}

func (r *RegisterDeviceOptions) afterLoad() {}

// +checklocksignore
func (r *RegisterDeviceOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.GroupName)
}

func (ep *EpollInstance) StateTypeName() string {
	return "pkg/sentry/vfs.EpollInstance"
}

func (ep *EpollInstance) StateFields() []string {
	return []string{
		"vfsfd",
		"FileDescriptionDefaultImpl",
		"DentryMetadataFileDescriptionImpl",
		"NoLockFD",
		"q",
		"interest",
		"ready",
		"readySeq",
	}
}

func (ep *EpollInstance) beforeSave() {}

// +checklocksignore
func (ep *EpollInstance) StateSave(stateSinkObject state.Sink) {
	ep.beforeSave()
	stateSinkObject.Save(0, &ep.vfsfd)
	stateSinkObject.Save(1, &ep.FileDescriptionDefaultImpl)
	stateSinkObject.Save(2, &ep.DentryMetadataFileDescriptionImpl)
	stateSinkObject.Save(3, &ep.NoLockFD)
	stateSinkObject.Save(4, &ep.q)
	stateSinkObject.Save(5, &ep.interest)
	stateSinkObject.Save(6, &ep.ready)
	stateSinkObject.Save(7, &ep.readySeq)
}

func (ep *EpollInstance) afterLoad() {}

// +checklocksignore
func (ep *EpollInstance) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ep.vfsfd)
	stateSourceObject.Load(1, &ep.FileDescriptionDefaultImpl)
	stateSourceObject.Load(2, &ep.DentryMetadataFileDescriptionImpl)
	stateSourceObject.Load(3, &ep.NoLockFD)
	stateSourceObject.Load(4, &ep.q)
	stateSourceObject.Load(5, &ep.interest)
	stateSourceObject.Load(6, &ep.ready)
	stateSourceObject.Load(7, &ep.readySeq)
}

func (e *epollInterestKey) StateTypeName() string {
	return "pkg/sentry/vfs.epollInterestKey"
}

func (e *epollInterestKey) StateFields() []string {
	return []string{
		"file",
		"num",
	}
}

func (e *epollInterestKey) beforeSave() {}

// +checklocksignore
func (e *epollInterestKey) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.file)
	stateSinkObject.Save(1, &e.num)
}

func (e *epollInterestKey) afterLoad() {}

// +checklocksignore
func (e *epollInterestKey) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.file)
	stateSourceObject.Load(1, &e.num)
}

func (epi *epollInterest) StateTypeName() string {
	return "pkg/sentry/vfs.epollInterest"
}

func (epi *epollInterest) StateFields() []string {
	return []string{
		"epoll",
		"key",
		"waiter",
		"mask",
		"ready",
		"epollInterestEntry",
		"readySeq",
		"userData",
	}
}

func (epi *epollInterest) beforeSave() {}

// +checklocksignore
func (epi *epollInterest) StateSave(stateSinkObject state.Sink) {
	epi.beforeSave()
	stateSinkObject.Save(0, &epi.epoll)
	stateSinkObject.Save(1, &epi.key)
	stateSinkObject.Save(2, &epi.waiter)
	stateSinkObject.Save(3, &epi.mask)
	stateSinkObject.Save(4, &epi.ready)
	stateSinkObject.Save(5, &epi.epollInterestEntry)
	stateSinkObject.Save(6, &epi.readySeq)
	stateSinkObject.Save(7, &epi.userData)
}

// +checklocksignore
func (epi *epollInterest) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.LoadWait(0, &epi.epoll)
	stateSourceObject.Load(1, &epi.key)
	stateSourceObject.Load(2, &epi.waiter)
	stateSourceObject.Load(3, &epi.mask)
	stateSourceObject.Load(4, &epi.ready)
	stateSourceObject.Load(5, &epi.epollInterestEntry)
	stateSourceObject.Load(6, &epi.readySeq)
	stateSourceObject.Load(7, &epi.userData)
	stateSourceObject.AfterLoad(epi.afterLoad)
}

func (l *epollInterestList) StateTypeName() string {
	return "pkg/sentry/vfs.epollInterestList"
}

func (l *epollInterestList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *epollInterestList) beforeSave() {}

// +checklocksignore
func (l *epollInterestList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *epollInterestList) afterLoad() {}

// +checklocksignore
func (l *epollInterestList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *epollInterestEntry) StateTypeName() string {
	return "pkg/sentry/vfs.epollInterestEntry"
}

func (e *epollInterestEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *epollInterestEntry) beforeSave() {}

// +checklocksignore
func (e *epollInterestEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *epollInterestEntry) afterLoad() {}

// +checklocksignore
func (e *epollInterestEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (l *eventList) StateTypeName() string {
	return "pkg/sentry/vfs.eventList"
}

func (l *eventList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *eventList) beforeSave() {}

// +checklocksignore
func (l *eventList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *eventList) afterLoad() {}

// +checklocksignore
func (l *eventList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *eventEntry) StateTypeName() string {
	return "pkg/sentry/vfs.eventEntry"
}

func (e *eventEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *eventEntry) beforeSave() {}

// +checklocksignore
func (e *eventEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *eventEntry) afterLoad() {}

// +checklocksignore
func (e *eventEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (fd *FileDescription) StateTypeName() string {
	return "pkg/sentry/vfs.FileDescription"
}

func (fd *FileDescription) StateFields() []string {
	return []string{
		"FileDescriptionRefs",
		"statusFlags",
		"asyncHandler",
		"epolls",
		"vd",
		"opts",
		"readable",
		"writable",
		"usedLockBSD",
		"impl",
	}
}

func (fd *FileDescription) beforeSave() {}

// +checklocksignore
func (fd *FileDescription) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	stateSinkObject.Save(0, &fd.FileDescriptionRefs)
	stateSinkObject.Save(1, &fd.statusFlags)
	stateSinkObject.Save(2, &fd.asyncHandler)
	stateSinkObject.Save(3, &fd.epolls)
	stateSinkObject.Save(4, &fd.vd)
	stateSinkObject.Save(5, &fd.opts)
	stateSinkObject.Save(6, &fd.readable)
	stateSinkObject.Save(7, &fd.writable)
	stateSinkObject.Save(8, &fd.usedLockBSD)
	stateSinkObject.Save(9, &fd.impl)
}

func (fd *FileDescription) afterLoad() {}

// +checklocksignore
func (fd *FileDescription) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.FileDescriptionRefs)
	stateSourceObject.Load(1, &fd.statusFlags)
	stateSourceObject.Load(2, &fd.asyncHandler)
	stateSourceObject.Load(3, &fd.epolls)
	stateSourceObject.Load(4, &fd.vd)
	stateSourceObject.Load(5, &fd.opts)
	stateSourceObject.Load(6, &fd.readable)
	stateSourceObject.Load(7, &fd.writable)
	stateSourceObject.Load(8, &fd.usedLockBSD)
	stateSourceObject.Load(9, &fd.impl)
}

func (f *FileDescriptionOptions) StateTypeName() string {
	return "pkg/sentry/vfs.FileDescriptionOptions"
}

func (f *FileDescriptionOptions) StateFields() []string {
	return []string{
		"AllowDirectIO",
		"DenyPRead",
		"DenyPWrite",
		"UseDentryMetadata",
		"DenySpliceIn",
	}
}

func (f *FileDescriptionOptions) beforeSave() {}

// +checklocksignore
func (f *FileDescriptionOptions) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.AllowDirectIO)
	stateSinkObject.Save(1, &f.DenyPRead)
	stateSinkObject.Save(2, &f.DenyPWrite)
	stateSinkObject.Save(3, &f.UseDentryMetadata)
	stateSinkObject.Save(4, &f.DenySpliceIn)
}

func (f *FileDescriptionOptions) afterLoad() {}

// +checklocksignore
func (f *FileDescriptionOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.AllowDirectIO)
	stateSourceObject.Load(1, &f.DenyPRead)
	stateSourceObject.Load(2, &f.DenyPWrite)
	stateSourceObject.Load(3, &f.UseDentryMetadata)
	stateSourceObject.Load(4, &f.DenySpliceIn)
}

func (d *Dirent) StateTypeName() string {
	return "pkg/sentry/vfs.Dirent"
}

func (d *Dirent) StateFields() []string {
	return []string{
		"Name",
		"Type",
		"Ino",
		"NextOff",
	}
}

func (d *Dirent) beforeSave() {}

// +checklocksignore
func (d *Dirent) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.Name)
	stateSinkObject.Save(1, &d.Type)
	stateSinkObject.Save(2, &d.Ino)
	stateSinkObject.Save(3, &d.NextOff)
}

func (d *Dirent) afterLoad() {}

// +checklocksignore
func (d *Dirent) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.Name)
	stateSourceObject.Load(1, &d.Type)
	stateSourceObject.Load(2, &d.Ino)
	stateSourceObject.Load(3, &d.NextOff)
}

func (f *FileDescriptionDefaultImpl) StateTypeName() string {
	return "pkg/sentry/vfs.FileDescriptionDefaultImpl"
}

func (f *FileDescriptionDefaultImpl) StateFields() []string {
	return []string{}
}

func (f *FileDescriptionDefaultImpl) beforeSave() {}

// +checklocksignore
func (f *FileDescriptionDefaultImpl) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
}

func (f *FileDescriptionDefaultImpl) afterLoad() {}

// +checklocksignore
func (f *FileDescriptionDefaultImpl) StateLoad(stateSourceObject state.Source) {
}

func (d *DirectoryFileDescriptionDefaultImpl) StateTypeName() string {
	return "pkg/sentry/vfs.DirectoryFileDescriptionDefaultImpl"
}

func (d *DirectoryFileDescriptionDefaultImpl) StateFields() []string {
	return []string{}
}

func (d *DirectoryFileDescriptionDefaultImpl) beforeSave() {}

// +checklocksignore
func (d *DirectoryFileDescriptionDefaultImpl) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
}

func (d *DirectoryFileDescriptionDefaultImpl) afterLoad() {}

// +checklocksignore
func (d *DirectoryFileDescriptionDefaultImpl) StateLoad(stateSourceObject state.Source) {
}

func (d *DentryMetadataFileDescriptionImpl) StateTypeName() string {
	return "pkg/sentry/vfs.DentryMetadataFileDescriptionImpl"
}

func (d *DentryMetadataFileDescriptionImpl) StateFields() []string {
	return []string{}
}

func (d *DentryMetadataFileDescriptionImpl) beforeSave() {}

// +checklocksignore
func (d *DentryMetadataFileDescriptionImpl) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
}

func (d *DentryMetadataFileDescriptionImpl) afterLoad() {}

// +checklocksignore
func (d *DentryMetadataFileDescriptionImpl) StateLoad(stateSourceObject state.Source) {
}

func (s *StaticData) StateTypeName() string {
	return "pkg/sentry/vfs.StaticData"
}

func (s *StaticData) StateFields() []string {
	return []string{
		"Data",
	}
}

func (s *StaticData) beforeSave() {}

// +checklocksignore
func (s *StaticData) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.Data)
}

func (s *StaticData) afterLoad() {}

// +checklocksignore
func (s *StaticData) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.Data)
}

func (fd *DynamicBytesFileDescriptionImpl) StateTypeName() string {
	return "pkg/sentry/vfs.DynamicBytesFileDescriptionImpl"
}

func (fd *DynamicBytesFileDescriptionImpl) StateFields() []string {
	return []string{
		"vfsfd",
		"data",
		"buf",
		"off",
		"lastRead",
	}
}

func (fd *DynamicBytesFileDescriptionImpl) beforeSave() {}

// +checklocksignore
func (fd *DynamicBytesFileDescriptionImpl) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	var bufValue []byte
	bufValue = fd.saveBuf()
	stateSinkObject.SaveValue(2, bufValue)
	stateSinkObject.Save(0, &fd.vfsfd)
	stateSinkObject.Save(1, &fd.data)
	stateSinkObject.Save(3, &fd.off)
	stateSinkObject.Save(4, &fd.lastRead)
}

func (fd *DynamicBytesFileDescriptionImpl) afterLoad() {}

// +checklocksignore
func (fd *DynamicBytesFileDescriptionImpl) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.vfsfd)
	stateSourceObject.Load(1, &fd.data)
	stateSourceObject.Load(3, &fd.off)
	stateSourceObject.Load(4, &fd.lastRead)
	stateSourceObject.LoadValue(2, new([]byte), func(y any) { fd.loadBuf(y.([]byte)) })
}

func (fd *LockFD) StateTypeName() string {
	return "pkg/sentry/vfs.LockFD"
}

func (fd *LockFD) StateFields() []string {
	return []string{
		"locks",
	}
}

func (fd *LockFD) beforeSave() {}

// +checklocksignore
func (fd *LockFD) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	stateSinkObject.Save(0, &fd.locks)
}

func (fd *LockFD) afterLoad() {}

// +checklocksignore
func (fd *LockFD) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.locks)
}

func (n *NoLockFD) StateTypeName() string {
	return "pkg/sentry/vfs.NoLockFD"
}

func (n *NoLockFD) StateFields() []string {
	return []string{}
}

func (n *NoLockFD) beforeSave() {}

// +checklocksignore
func (n *NoLockFD) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
}

func (n *NoLockFD) afterLoad() {}

// +checklocksignore
func (n *NoLockFD) StateLoad(stateSourceObject state.Source) {
}

func (b *BadLockFD) StateTypeName() string {
	return "pkg/sentry/vfs.BadLockFD"
}

func (b *BadLockFD) StateFields() []string {
	return []string{}
}

func (b *BadLockFD) beforeSave() {}

// +checklocksignore
func (b *BadLockFD) StateSave(stateSinkObject state.Sink) {
	b.beforeSave()
}

func (b *BadLockFD) afterLoad() {}

// +checklocksignore
func (b *BadLockFD) StateLoad(stateSourceObject state.Source) {
}

func (r *FileDescriptionRefs) StateTypeName() string {
	return "pkg/sentry/vfs.FileDescriptionRefs"
}

func (r *FileDescriptionRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FileDescriptionRefs) beforeSave() {}

// +checklocksignore
func (r *FileDescriptionRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FileDescriptionRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (fs *Filesystem) StateTypeName() string {
	return "pkg/sentry/vfs.Filesystem"
}

func (fs *Filesystem) StateFields() []string {
	return []string{
		"FilesystemRefs",
		"vfs",
		"fsType",
		"impl",
	}
}

func (fs *Filesystem) beforeSave() {}

// +checklocksignore
func (fs *Filesystem) StateSave(stateSinkObject state.Sink) {
	fs.beforeSave()
	stateSinkObject.Save(0, &fs.FilesystemRefs)
	stateSinkObject.Save(1, &fs.vfs)
	stateSinkObject.Save(2, &fs.fsType)
	stateSinkObject.Save(3, &fs.impl)
}

func (fs *Filesystem) afterLoad() {}

// +checklocksignore
func (fs *Filesystem) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fs.FilesystemRefs)
	stateSourceObject.Load(1, &fs.vfs)
	stateSourceObject.Load(2, &fs.fsType)
	stateSourceObject.Load(3, &fs.impl)
}

func (p *PrependPathAtVFSRootError) StateTypeName() string {
	return "pkg/sentry/vfs.PrependPathAtVFSRootError"
}

func (p *PrependPathAtVFSRootError) StateFields() []string {
	return []string{}
}

func (p *PrependPathAtVFSRootError) beforeSave() {}

// +checklocksignore
func (p *PrependPathAtVFSRootError) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
}

func (p *PrependPathAtVFSRootError) afterLoad() {}

// +checklocksignore
func (p *PrependPathAtVFSRootError) StateLoad(stateSourceObject state.Source) {
}

func (p *PrependPathAtNonMountRootError) StateTypeName() string {
	return "pkg/sentry/vfs.PrependPathAtNonMountRootError"
}

func (p *PrependPathAtNonMountRootError) StateFields() []string {
	return []string{}
}

func (p *PrependPathAtNonMountRootError) beforeSave() {}

// +checklocksignore
func (p *PrependPathAtNonMountRootError) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
}

func (p *PrependPathAtNonMountRootError) afterLoad() {}

// +checklocksignore
func (p *PrependPathAtNonMountRootError) StateLoad(stateSourceObject state.Source) {
}

func (p *PrependPathSyntheticError) StateTypeName() string {
	return "pkg/sentry/vfs.PrependPathSyntheticError"
}

func (p *PrependPathSyntheticError) StateFields() []string {
	return []string{}
}

func (p *PrependPathSyntheticError) beforeSave() {}

// +checklocksignore
func (p *PrependPathSyntheticError) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
}

func (p *PrependPathSyntheticError) afterLoad() {}

// +checklocksignore
func (p *PrependPathSyntheticError) StateLoad(stateSourceObject state.Source) {
}

func (r *FilesystemRefs) StateTypeName() string {
	return "pkg/sentry/vfs.FilesystemRefs"
}

func (r *FilesystemRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FilesystemRefs) beforeSave() {}

// +checklocksignore
func (r *FilesystemRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FilesystemRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (r *registeredFilesystemType) StateTypeName() string {
	return "pkg/sentry/vfs.registeredFilesystemType"
}

func (r *registeredFilesystemType) StateFields() []string {
	return []string{
		"fsType",
		"opts",
	}
}

func (r *registeredFilesystemType) beforeSave() {}

// +checklocksignore
func (r *registeredFilesystemType) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.fsType)
	stateSinkObject.Save(1, &r.opts)
}

func (r *registeredFilesystemType) afterLoad() {}

// +checklocksignore
func (r *registeredFilesystemType) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.fsType)
	stateSourceObject.Load(1, &r.opts)
}

func (r *RegisterFilesystemTypeOptions) StateTypeName() string {
	return "pkg/sentry/vfs.RegisterFilesystemTypeOptions"
}

func (r *RegisterFilesystemTypeOptions) StateFields() []string {
	return []string{
		"AllowUserMount",
		"AllowUserList",
		"RequiresDevice",
	}
}

func (r *RegisterFilesystemTypeOptions) beforeSave() {}

// +checklocksignore
func (r *RegisterFilesystemTypeOptions) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.AllowUserMount)
	stateSinkObject.Save(1, &r.AllowUserList)
	stateSinkObject.Save(2, &r.RequiresDevice)
}

func (r *RegisterFilesystemTypeOptions) afterLoad() {}

// +checklocksignore
func (r *RegisterFilesystemTypeOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.AllowUserMount)
	stateSourceObject.Load(1, &r.AllowUserList)
	stateSourceObject.Load(2, &r.RequiresDevice)
}

func (e *EventType) StateTypeName() string {
	return "pkg/sentry/vfs.EventType"
}

func (e *EventType) StateFields() []string {
	return nil
}

func (i *Inotify) StateTypeName() string {
	return "pkg/sentry/vfs.Inotify"
}

func (i *Inotify) StateFields() []string {
	return []string{
		"vfsfd",
		"FileDescriptionDefaultImpl",
		"DentryMetadataFileDescriptionImpl",
		"NoLockFD",
		"id",
		"queue",
		"events",
		"scratch",
		"nextWatchMinusOne",
		"watches",
	}
}

func (i *Inotify) beforeSave() {}

// +checklocksignore
func (i *Inotify) StateSave(stateSinkObject state.Sink) {
	i.beforeSave()
	stateSinkObject.Save(0, &i.vfsfd)
	stateSinkObject.Save(1, &i.FileDescriptionDefaultImpl)
	stateSinkObject.Save(2, &i.DentryMetadataFileDescriptionImpl)
	stateSinkObject.Save(3, &i.NoLockFD)
	stateSinkObject.Save(4, &i.id)
	stateSinkObject.Save(5, &i.queue)
	stateSinkObject.Save(6, &i.events)
	stateSinkObject.Save(7, &i.scratch)
	stateSinkObject.Save(8, &i.nextWatchMinusOne)
	stateSinkObject.Save(9, &i.watches)
}

func (i *Inotify) afterLoad() {}

// +checklocksignore
func (i *Inotify) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &i.vfsfd)
	stateSourceObject.Load(1, &i.FileDescriptionDefaultImpl)
	stateSourceObject.Load(2, &i.DentryMetadataFileDescriptionImpl)
	stateSourceObject.Load(3, &i.NoLockFD)
	stateSourceObject.Load(4, &i.id)
	stateSourceObject.Load(5, &i.queue)
	stateSourceObject.Load(6, &i.events)
	stateSourceObject.Load(7, &i.scratch)
	stateSourceObject.Load(8, &i.nextWatchMinusOne)
	stateSourceObject.Load(9, &i.watches)
}

func (w *Watches) StateTypeName() string {
	return "pkg/sentry/vfs.Watches"
}

func (w *Watches) StateFields() []string {
	return []string{
		"ws",
	}
}

func (w *Watches) beforeSave() {}

// +checklocksignore
func (w *Watches) StateSave(stateSinkObject state.Sink) {
	w.beforeSave()
	stateSinkObject.Save(0, &w.ws)
}

func (w *Watches) afterLoad() {}

// +checklocksignore
func (w *Watches) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &w.ws)
}

func (w *Watch) StateTypeName() string {
	return "pkg/sentry/vfs.Watch"
}

func (w *Watch) StateFields() []string {
	return []string{
		"owner",
		"wd",
		"target",
		"mask",
		"expired",
	}
}

func (w *Watch) beforeSave() {}

// +checklocksignore
func (w *Watch) StateSave(stateSinkObject state.Sink) {
	w.beforeSave()
	stateSinkObject.Save(0, &w.owner)
	stateSinkObject.Save(1, &w.wd)
	stateSinkObject.Save(2, &w.target)
	stateSinkObject.Save(3, &w.mask)
	stateSinkObject.Save(4, &w.expired)
}

func (w *Watch) afterLoad() {}

// +checklocksignore
func (w *Watch) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &w.owner)
	stateSourceObject.Load(1, &w.wd)
	stateSourceObject.Load(2, &w.target)
	stateSourceObject.Load(3, &w.mask)
	stateSourceObject.Load(4, &w.expired)
}

func (e *Event) StateTypeName() string {
	return "pkg/sentry/vfs.Event"
}

func (e *Event) StateFields() []string {
	return []string{
		"eventEntry",
		"wd",
		"mask",
		"cookie",
		"len",
		"name",
	}
}

func (e *Event) beforeSave() {}

// +checklocksignore
func (e *Event) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.eventEntry)
	stateSinkObject.Save(1, &e.wd)
	stateSinkObject.Save(2, &e.mask)
	stateSinkObject.Save(3, &e.cookie)
	stateSinkObject.Save(4, &e.len)
	stateSinkObject.Save(5, &e.name)
}

func (e *Event) afterLoad() {}

// +checklocksignore
func (e *Event) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.eventEntry)
	stateSourceObject.Load(1, &e.wd)
	stateSourceObject.Load(2, &e.mask)
	stateSourceObject.Load(3, &e.cookie)
	stateSourceObject.Load(4, &e.len)
	stateSourceObject.Load(5, &e.name)
}

func (fl *FileLocks) StateTypeName() string {
	return "pkg/sentry/vfs.FileLocks"
}

func (fl *FileLocks) StateFields() []string {
	return []string{
		"bsd",
		"posix",
	}
}

func (fl *FileLocks) beforeSave() {}

// +checklocksignore
func (fl *FileLocks) StateSave(stateSinkObject state.Sink) {
	fl.beforeSave()
	stateSinkObject.Save(0, &fl.bsd)
	stateSinkObject.Save(1, &fl.posix)
}

func (fl *FileLocks) afterLoad() {}

// +checklocksignore
func (fl *FileLocks) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fl.bsd)
	stateSourceObject.Load(1, &fl.posix)
}

func (mnt *Mount) StateTypeName() string {
	return "pkg/sentry/vfs.Mount"
}

func (mnt *Mount) StateFields() []string {
	return []string{
		"vfs",
		"fs",
		"root",
		"ID",
		"Flags",
		"key",
		"ns",
		"refs",
		"children",
		"isShared",
		"sharedEntry",
		"groupID",
		"umounted",
		"writers",
		"pendingChildren",
	}
}

func (mnt *Mount) beforeSave() {}

// +checklocksignore
func (mnt *Mount) StateSave(stateSinkObject state.Sink) {
	mnt.beforeSave()
	var keyValue VirtualDentry
	keyValue = mnt.saveKey()
	stateSinkObject.SaveValue(5, keyValue)
	stateSinkObject.Save(0, &mnt.vfs)
	stateSinkObject.Save(1, &mnt.fs)
	stateSinkObject.Save(2, &mnt.root)
	stateSinkObject.Save(3, &mnt.ID)
	stateSinkObject.Save(4, &mnt.Flags)
	stateSinkObject.Save(6, &mnt.ns)
	stateSinkObject.Save(7, &mnt.refs)
	stateSinkObject.Save(8, &mnt.children)
	stateSinkObject.Save(9, &mnt.isShared)
	stateSinkObject.Save(10, &mnt.sharedEntry)
	stateSinkObject.Save(11, &mnt.groupID)
	stateSinkObject.Save(12, &mnt.umounted)
	stateSinkObject.Save(13, &mnt.writers)
	stateSinkObject.Save(14, &mnt.pendingChildren)
}

// +checklocksignore
func (mnt *Mount) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &mnt.vfs)
	stateSourceObject.Load(1, &mnt.fs)
	stateSourceObject.Load(2, &mnt.root)
	stateSourceObject.Load(3, &mnt.ID)
	stateSourceObject.Load(4, &mnt.Flags)
	stateSourceObject.Load(6, &mnt.ns)
	stateSourceObject.Load(7, &mnt.refs)
	stateSourceObject.Load(8, &mnt.children)
	stateSourceObject.Load(9, &mnt.isShared)
	stateSourceObject.Load(10, &mnt.sharedEntry)
	stateSourceObject.Load(11, &mnt.groupID)
	stateSourceObject.Load(12, &mnt.umounted)
	stateSourceObject.Load(13, &mnt.writers)
	stateSourceObject.Load(14, &mnt.pendingChildren)
	stateSourceObject.LoadValue(5, new(VirtualDentry), func(y any) { mnt.loadKey(y.(VirtualDentry)) })
	stateSourceObject.AfterLoad(mnt.afterLoad)
}

func (u *umountRecursiveOptions) StateTypeName() string {
	return "pkg/sentry/vfs.umountRecursiveOptions"
}

func (u *umountRecursiveOptions) StateFields() []string {
	return []string{
		"eager",
		"disconnectHierarchy",
	}
}

func (u *umountRecursiveOptions) beforeSave() {}

// +checklocksignore
func (u *umountRecursiveOptions) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.eager)
	stateSinkObject.Save(1, &u.disconnectHierarchy)
}

func (u *umountRecursiveOptions) afterLoad() {}

// +checklocksignore
func (u *umountRecursiveOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.eager)
	stateSourceObject.Load(1, &u.disconnectHierarchy)
}

func (r *namespaceRefs) StateTypeName() string {
	return "pkg/sentry/vfs.namespaceRefs"
}

func (r *namespaceRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *namespaceRefs) beforeSave() {}

// +checklocksignore
func (r *namespaceRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *namespaceRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (e *mountEntry) StateTypeName() string {
	return "pkg/sentry/vfs.mountEntry"
}

func (e *mountEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
		"container",
	}
}

func (e *mountEntry) beforeSave() {}

// +checklocksignore
func (e *mountEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
	stateSinkObject.Save(2, &e.container)
}

func (e *mountEntry) afterLoad() {}

// +checklocksignore
func (e *mountEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
	stateSourceObject.Load(2, &e.container)
}

func (mntns *MountNamespace) StateTypeName() string {
	return "pkg/sentry/vfs.MountNamespace"
}

func (mntns *MountNamespace) StateFields() []string {
	return []string{
		"Refs",
		"Owner",
		"root",
		"mountpoints",
		"mounts",
	}
}

func (mntns *MountNamespace) beforeSave() {}

// +checklocksignore
func (mntns *MountNamespace) StateSave(stateSinkObject state.Sink) {
	mntns.beforeSave()
	stateSinkObject.Save(0, &mntns.Refs)
	stateSinkObject.Save(1, &mntns.Owner)
	stateSinkObject.Save(2, &mntns.root)
	stateSinkObject.Save(3, &mntns.mountpoints)
	stateSinkObject.Save(4, &mntns.mounts)
}

func (mntns *MountNamespace) afterLoad() {}

// +checklocksignore
func (mntns *MountNamespace) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &mntns.Refs)
	stateSourceObject.Load(1, &mntns.Owner)
	stateSourceObject.Load(2, &mntns.root)
	stateSourceObject.Load(3, &mntns.mountpoints)
	stateSourceObject.Load(4, &mntns.mounts)
}

func (fd *opathFD) StateTypeName() string {
	return "pkg/sentry/vfs.opathFD"
}

func (fd *opathFD) StateFields() []string {
	return []string{
		"vfsfd",
		"FileDescriptionDefaultImpl",
		"BadLockFD",
	}
}

func (fd *opathFD) beforeSave() {}

// +checklocksignore
func (fd *opathFD) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	stateSinkObject.Save(0, &fd.vfsfd)
	stateSinkObject.Save(1, &fd.FileDescriptionDefaultImpl)
	stateSinkObject.Save(2, &fd.BadLockFD)
}

func (fd *opathFD) afterLoad() {}

// +checklocksignore
func (fd *opathFD) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.vfsfd)
	stateSourceObject.Load(1, &fd.FileDescriptionDefaultImpl)
	stateSourceObject.Load(2, &fd.BadLockFD)
}

func (g *GetDentryOptions) StateTypeName() string {
	return "pkg/sentry/vfs.GetDentryOptions"
}

func (g *GetDentryOptions) StateFields() []string {
	return []string{
		"CheckSearchable",
	}
}

func (g *GetDentryOptions) beforeSave() {}

// +checklocksignore
func (g *GetDentryOptions) StateSave(stateSinkObject state.Sink) {
	g.beforeSave()
	stateSinkObject.Save(0, &g.CheckSearchable)
}

func (g *GetDentryOptions) afterLoad() {}

// +checklocksignore
func (g *GetDentryOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &g.CheckSearchable)
}

func (m *MkdirOptions) StateTypeName() string {
	return "pkg/sentry/vfs.MkdirOptions"
}

func (m *MkdirOptions) StateFields() []string {
	return []string{
		"Mode",
		"ForSyntheticMountpoint",
	}
}

func (m *MkdirOptions) beforeSave() {}

// +checklocksignore
func (m *MkdirOptions) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.Mode)
	stateSinkObject.Save(1, &m.ForSyntheticMountpoint)
}

func (m *MkdirOptions) afterLoad() {}

// +checklocksignore
func (m *MkdirOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.Mode)
	stateSourceObject.Load(1, &m.ForSyntheticMountpoint)
}

func (m *MknodOptions) StateTypeName() string {
	return "pkg/sentry/vfs.MknodOptions"
}

func (m *MknodOptions) StateFields() []string {
	return []string{
		"Mode",
		"DevMajor",
		"DevMinor",
		"Endpoint",
	}
}

func (m *MknodOptions) beforeSave() {}

// +checklocksignore
func (m *MknodOptions) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.Mode)
	stateSinkObject.Save(1, &m.DevMajor)
	stateSinkObject.Save(2, &m.DevMinor)
	stateSinkObject.Save(3, &m.Endpoint)
}

func (m *MknodOptions) afterLoad() {}

// +checklocksignore
func (m *MknodOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.Mode)
	stateSourceObject.Load(1, &m.DevMajor)
	stateSourceObject.Load(2, &m.DevMinor)
	stateSourceObject.Load(3, &m.Endpoint)
}

func (m *MountFlags) StateTypeName() string {
	return "pkg/sentry/vfs.MountFlags"
}

func (m *MountFlags) StateFields() []string {
	return []string{
		"NoExec",
		"NoATime",
		"NoDev",
		"NoSUID",
	}
}

func (m *MountFlags) beforeSave() {}

// +checklocksignore
func (m *MountFlags) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.NoExec)
	stateSinkObject.Save(1, &m.NoATime)
	stateSinkObject.Save(2, &m.NoDev)
	stateSinkObject.Save(3, &m.NoSUID)
}

func (m *MountFlags) afterLoad() {}

// +checklocksignore
func (m *MountFlags) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.NoExec)
	stateSourceObject.Load(1, &m.NoATime)
	stateSourceObject.Load(2, &m.NoDev)
	stateSourceObject.Load(3, &m.NoSUID)
}

func (m *MountOptions) StateTypeName() string {
	return "pkg/sentry/vfs.MountOptions"
}

func (m *MountOptions) StateFields() []string {
	return []string{
		"Flags",
		"ReadOnly",
		"GetFilesystemOptions",
		"InternalMount",
	}
}

func (m *MountOptions) beforeSave() {}

// +checklocksignore
func (m *MountOptions) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.Flags)
	stateSinkObject.Save(1, &m.ReadOnly)
	stateSinkObject.Save(2, &m.GetFilesystemOptions)
	stateSinkObject.Save(3, &m.InternalMount)
}

func (m *MountOptions) afterLoad() {}

// +checklocksignore
func (m *MountOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.Flags)
	stateSourceObject.Load(1, &m.ReadOnly)
	stateSourceObject.Load(2, &m.GetFilesystemOptions)
	stateSourceObject.Load(3, &m.InternalMount)
}

func (o *OpenOptions) StateTypeName() string {
	return "pkg/sentry/vfs.OpenOptions"
}

func (o *OpenOptions) StateFields() []string {
	return []string{
		"Flags",
		"Mode",
		"FileExec",
	}
}

func (o *OpenOptions) beforeSave() {}

// +checklocksignore
func (o *OpenOptions) StateSave(stateSinkObject state.Sink) {
	o.beforeSave()
	stateSinkObject.Save(0, &o.Flags)
	stateSinkObject.Save(1, &o.Mode)
	stateSinkObject.Save(2, &o.FileExec)
}

func (o *OpenOptions) afterLoad() {}

// +checklocksignore
func (o *OpenOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &o.Flags)
	stateSourceObject.Load(1, &o.Mode)
	stateSourceObject.Load(2, &o.FileExec)
}

func (r *ReadOptions) StateTypeName() string {
	return "pkg/sentry/vfs.ReadOptions"
}

func (r *ReadOptions) StateFields() []string {
	return []string{
		"Flags",
	}
}

func (r *ReadOptions) beforeSave() {}

// +checklocksignore
func (r *ReadOptions) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.Flags)
}

func (r *ReadOptions) afterLoad() {}

// +checklocksignore
func (r *ReadOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.Flags)
}

func (r *RenameOptions) StateTypeName() string {
	return "pkg/sentry/vfs.RenameOptions"
}

func (r *RenameOptions) StateFields() []string {
	return []string{
		"Flags",
		"MustBeDir",
	}
}

func (r *RenameOptions) beforeSave() {}

// +checklocksignore
func (r *RenameOptions) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.Flags)
	stateSinkObject.Save(1, &r.MustBeDir)
}

func (r *RenameOptions) afterLoad() {}

// +checklocksignore
func (r *RenameOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.Flags)
	stateSourceObject.Load(1, &r.MustBeDir)
}

func (s *SetStatOptions) StateTypeName() string {
	return "pkg/sentry/vfs.SetStatOptions"
}

func (s *SetStatOptions) StateFields() []string {
	return []string{
		"Stat",
		"NeedWritePerm",
	}
}

func (s *SetStatOptions) beforeSave() {}

// +checklocksignore
func (s *SetStatOptions) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.Stat)
	stateSinkObject.Save(1, &s.NeedWritePerm)
}

func (s *SetStatOptions) afterLoad() {}

// +checklocksignore
func (s *SetStatOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.Stat)
	stateSourceObject.Load(1, &s.NeedWritePerm)
}

func (b *BoundEndpointOptions) StateTypeName() string {
	return "pkg/sentry/vfs.BoundEndpointOptions"
}

func (b *BoundEndpointOptions) StateFields() []string {
	return []string{
		"Addr",
	}
}

func (b *BoundEndpointOptions) beforeSave() {}

// +checklocksignore
func (b *BoundEndpointOptions) StateSave(stateSinkObject state.Sink) {
	b.beforeSave()
	stateSinkObject.Save(0, &b.Addr)
}

func (b *BoundEndpointOptions) afterLoad() {}

// +checklocksignore
func (b *BoundEndpointOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &b.Addr)
}

func (g *GetXattrOptions) StateTypeName() string {
	return "pkg/sentry/vfs.GetXattrOptions"
}

func (g *GetXattrOptions) StateFields() []string {
	return []string{
		"Name",
		"Size",
	}
}

func (g *GetXattrOptions) beforeSave() {}

// +checklocksignore
func (g *GetXattrOptions) StateSave(stateSinkObject state.Sink) {
	g.beforeSave()
	stateSinkObject.Save(0, &g.Name)
	stateSinkObject.Save(1, &g.Size)
}

func (g *GetXattrOptions) afterLoad() {}

// +checklocksignore
func (g *GetXattrOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &g.Name)
	stateSourceObject.Load(1, &g.Size)
}

func (s *SetXattrOptions) StateTypeName() string {
	return "pkg/sentry/vfs.SetXattrOptions"
}

func (s *SetXattrOptions) StateFields() []string {
	return []string{
		"Name",
		"Value",
		"Flags",
	}
}

func (s *SetXattrOptions) beforeSave() {}

// +checklocksignore
func (s *SetXattrOptions) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.Name)
	stateSinkObject.Save(1, &s.Value)
	stateSinkObject.Save(2, &s.Flags)
}

func (s *SetXattrOptions) afterLoad() {}

// +checklocksignore
func (s *SetXattrOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.Name)
	stateSourceObject.Load(1, &s.Value)
	stateSourceObject.Load(2, &s.Flags)
}

func (s *StatOptions) StateTypeName() string {
	return "pkg/sentry/vfs.StatOptions"
}

func (s *StatOptions) StateFields() []string {
	return []string{
		"Mask",
		"Sync",
	}
}

func (s *StatOptions) beforeSave() {}

// +checklocksignore
func (s *StatOptions) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.Mask)
	stateSinkObject.Save(1, &s.Sync)
}

func (s *StatOptions) afterLoad() {}

// +checklocksignore
func (s *StatOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.Mask)
	stateSourceObject.Load(1, &s.Sync)
}

func (u *UmountOptions) StateTypeName() string {
	return "pkg/sentry/vfs.UmountOptions"
}

func (u *UmountOptions) StateFields() []string {
	return []string{
		"Flags",
	}
}

func (u *UmountOptions) beforeSave() {}

// +checklocksignore
func (u *UmountOptions) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.Flags)
}

func (u *UmountOptions) afterLoad() {}

// +checklocksignore
func (u *UmountOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.Flags)
}

func (w *WriteOptions) StateTypeName() string {
	return "pkg/sentry/vfs.WriteOptions"
}

func (w *WriteOptions) StateFields() []string {
	return []string{
		"Flags",
	}
}

func (w *WriteOptions) beforeSave() {}

// +checklocksignore
func (w *WriteOptions) StateSave(stateSinkObject state.Sink) {
	w.beforeSave()
	stateSinkObject.Save(0, &w.Flags)
}

func (w *WriteOptions) afterLoad() {}

// +checklocksignore
func (w *WriteOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &w.Flags)
}

func (a *AccessTypes) StateTypeName() string {
	return "pkg/sentry/vfs.AccessTypes"
}

func (a *AccessTypes) StateFields() []string {
	return nil
}

func (rp *ResolvingPath) StateTypeName() string {
	return "pkg/sentry/vfs.ResolvingPath"
}

func (rp *ResolvingPath) StateFields() []string {
	return []string{
		"vfs",
		"root",
		"mount",
		"start",
		"pit",
		"flags",
		"mustBeDir",
		"symlinks",
		"curPart",
		"creds",
		"nextMount",
		"nextStart",
		"absSymlinkTarget",
		"parts",
	}
}

func (rp *ResolvingPath) beforeSave() {}

// +checklocksignore
func (rp *ResolvingPath) StateSave(stateSinkObject state.Sink) {
	rp.beforeSave()
	stateSinkObject.Save(0, &rp.vfs)
	stateSinkObject.Save(1, &rp.root)
	stateSinkObject.Save(2, &rp.mount)
	stateSinkObject.Save(3, &rp.start)
	stateSinkObject.Save(4, &rp.pit)
	stateSinkObject.Save(5, &rp.flags)
	stateSinkObject.Save(6, &rp.mustBeDir)
	stateSinkObject.Save(7, &rp.symlinks)
	stateSinkObject.Save(8, &rp.curPart)
	stateSinkObject.Save(9, &rp.creds)
	stateSinkObject.Save(10, &rp.nextMount)
	stateSinkObject.Save(11, &rp.nextStart)
	stateSinkObject.Save(12, &rp.absSymlinkTarget)
	stateSinkObject.Save(13, &rp.parts)
}

func (rp *ResolvingPath) afterLoad() {}

// +checklocksignore
func (rp *ResolvingPath) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &rp.vfs)
	stateSourceObject.Load(1, &rp.root)
	stateSourceObject.Load(2, &rp.mount)
	stateSourceObject.Load(3, &rp.start)
	stateSourceObject.Load(4, &rp.pit)
	stateSourceObject.Load(5, &rp.flags)
	stateSourceObject.Load(6, &rp.mustBeDir)
	stateSourceObject.Load(7, &rp.symlinks)
	stateSourceObject.Load(8, &rp.curPart)
	stateSourceObject.Load(9, &rp.creds)
	stateSourceObject.Load(10, &rp.nextMount)
	stateSourceObject.Load(11, &rp.nextStart)
	stateSourceObject.Load(12, &rp.absSymlinkTarget)
	stateSourceObject.Load(13, &rp.parts)
}

func (r *resolveMountRootOrJumpError) StateTypeName() string {
	return "pkg/sentry/vfs.resolveMountRootOrJumpError"
}

func (r *resolveMountRootOrJumpError) StateFields() []string {
	return []string{}
}

func (r *resolveMountRootOrJumpError) beforeSave() {}

// +checklocksignore
func (r *resolveMountRootOrJumpError) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *resolveMountRootOrJumpError) afterLoad() {}

// +checklocksignore
func (r *resolveMountRootOrJumpError) StateLoad(stateSourceObject state.Source) {
}

func (r *resolveMountPointError) StateTypeName() string {
	return "pkg/sentry/vfs.resolveMountPointError"
}

func (r *resolveMountPointError) StateFields() []string {
	return []string{}
}

func (r *resolveMountPointError) beforeSave() {}

// +checklocksignore
func (r *resolveMountPointError) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *resolveMountPointError) afterLoad() {}

// +checklocksignore
func (r *resolveMountPointError) StateLoad(stateSourceObject state.Source) {
}

func (r *resolveAbsSymlinkError) StateTypeName() string {
	return "pkg/sentry/vfs.resolveAbsSymlinkError"
}

func (r *resolveAbsSymlinkError) StateFields() []string {
	return []string{}
}

func (r *resolveAbsSymlinkError) beforeSave() {}

// +checklocksignore
func (r *resolveAbsSymlinkError) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *resolveAbsSymlinkError) afterLoad() {}

// +checklocksignore
func (r *resolveAbsSymlinkError) StateLoad(stateSourceObject state.Source) {
}

func (vfs *VirtualFilesystem) StateTypeName() string {
	return "pkg/sentry/vfs.VirtualFilesystem"
}

func (vfs *VirtualFilesystem) StateFields() []string {
	return []string{
		"mounts",
		"mountpoints",
		"lastMountID",
		"anonMount",
		"devices",
		"dynCharDevMajorUsed",
		"anonBlockDevMinorNext",
		"anonBlockDevMinor",
		"fsTypes",
		"filesystems",
		"groupIDBitmap",
		"mountPromises",
		"toDecRef",
	}
}

func (vfs *VirtualFilesystem) beforeSave() {}

// +checklocksignore
func (vfs *VirtualFilesystem) StateSave(stateSinkObject state.Sink) {
	vfs.beforeSave()
	var mountsValue []*Mount
	mountsValue = vfs.saveMounts()
	stateSinkObject.SaveValue(0, mountsValue)
	stateSinkObject.Save(1, &vfs.mountpoints)
	stateSinkObject.Save(2, &vfs.lastMountID)
	stateSinkObject.Save(3, &vfs.anonMount)
	stateSinkObject.Save(4, &vfs.devices)
	stateSinkObject.Save(5, &vfs.dynCharDevMajorUsed)
	stateSinkObject.Save(6, &vfs.anonBlockDevMinorNext)
	stateSinkObject.Save(7, &vfs.anonBlockDevMinor)
	stateSinkObject.Save(8, &vfs.fsTypes)
	stateSinkObject.Save(9, &vfs.filesystems)
	stateSinkObject.Save(10, &vfs.groupIDBitmap)
	stateSinkObject.Save(11, &vfs.mountPromises)
	stateSinkObject.Save(12, &vfs.toDecRef)
}

func (vfs *VirtualFilesystem) afterLoad() {}

// +checklocksignore
func (vfs *VirtualFilesystem) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(1, &vfs.mountpoints)
	stateSourceObject.Load(2, &vfs.lastMountID)
	stateSourceObject.Load(3, &vfs.anonMount)
	stateSourceObject.Load(4, &vfs.devices)
	stateSourceObject.Load(5, &vfs.dynCharDevMajorUsed)
	stateSourceObject.Load(6, &vfs.anonBlockDevMinorNext)
	stateSourceObject.Load(7, &vfs.anonBlockDevMinor)
	stateSourceObject.Load(8, &vfs.fsTypes)
	stateSourceObject.Load(9, &vfs.filesystems)
	stateSourceObject.Load(10, &vfs.groupIDBitmap)
	stateSourceObject.Load(11, &vfs.mountPromises)
	stateSourceObject.Load(12, &vfs.toDecRef)
	stateSourceObject.LoadValue(0, new([]*Mount), func(y any) { vfs.loadMounts(y.([]*Mount)) })
}

func (p *PathOperation) StateTypeName() string {
	return "pkg/sentry/vfs.PathOperation"
}

func (p *PathOperation) StateFields() []string {
	return []string{
		"Root",
		"Start",
		"Path",
		"FollowFinalSymlink",
	}
}

func (p *PathOperation) beforeSave() {}

// +checklocksignore
func (p *PathOperation) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.Root)
	stateSinkObject.Save(1, &p.Start)
	stateSinkObject.Save(2, &p.Path)
	stateSinkObject.Save(3, &p.FollowFinalSymlink)
}

func (p *PathOperation) afterLoad() {}

// +checklocksignore
func (p *PathOperation) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.Root)
	stateSourceObject.Load(1, &p.Start)
	stateSourceObject.Load(2, &p.Path)
	stateSourceObject.Load(3, &p.FollowFinalSymlink)
}

func (vd *VirtualDentry) StateTypeName() string {
	return "pkg/sentry/vfs.VirtualDentry"
}

func (vd *VirtualDentry) StateFields() []string {
	return []string{
		"mount",
		"dentry",
	}
}

func (vd *VirtualDentry) beforeSave() {}

// +checklocksignore
func (vd *VirtualDentry) StateSave(stateSinkObject state.Sink) {
	vd.beforeSave()
	stateSinkObject.Save(0, &vd.mount)
	stateSinkObject.Save(1, &vd.dentry)
}

func (vd *VirtualDentry) afterLoad() {}

// +checklocksignore
func (vd *VirtualDentry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &vd.mount)
	stateSourceObject.Load(1, &vd.dentry)
}

func init() {
	state.Register((*anonFilesystemType)(nil))
	state.Register((*anonFilesystem)(nil))
	state.Register((*anonDentry)(nil))
	state.Register((*Dentry)(nil))
	state.Register((*DeviceKind)(nil))
	state.Register((*devTuple)(nil))
	state.Register((*registeredDevice)(nil))
	state.Register((*RegisterDeviceOptions)(nil))
	state.Register((*EpollInstance)(nil))
	state.Register((*epollInterestKey)(nil))
	state.Register((*epollInterest)(nil))
	state.Register((*epollInterestList)(nil))
	state.Register((*epollInterestEntry)(nil))
	state.Register((*eventList)(nil))
	state.Register((*eventEntry)(nil))
	state.Register((*FileDescription)(nil))
	state.Register((*FileDescriptionOptions)(nil))
	state.Register((*Dirent)(nil))
	state.Register((*FileDescriptionDefaultImpl)(nil))
	state.Register((*DirectoryFileDescriptionDefaultImpl)(nil))
	state.Register((*DentryMetadataFileDescriptionImpl)(nil))
	state.Register((*StaticData)(nil))
	state.Register((*DynamicBytesFileDescriptionImpl)(nil))
	state.Register((*LockFD)(nil))
	state.Register((*NoLockFD)(nil))
	state.Register((*BadLockFD)(nil))
	state.Register((*FileDescriptionRefs)(nil))
	state.Register((*Filesystem)(nil))
	state.Register((*PrependPathAtVFSRootError)(nil))
	state.Register((*PrependPathAtNonMountRootError)(nil))
	state.Register((*PrependPathSyntheticError)(nil))
	state.Register((*FilesystemRefs)(nil))
	state.Register((*registeredFilesystemType)(nil))
	state.Register((*RegisterFilesystemTypeOptions)(nil))
	state.Register((*EventType)(nil))
	state.Register((*Inotify)(nil))
	state.Register((*Watches)(nil))
	state.Register((*Watch)(nil))
	state.Register((*Event)(nil))
	state.Register((*FileLocks)(nil))
	state.Register((*Mount)(nil))
	state.Register((*umountRecursiveOptions)(nil))
	state.Register((*namespaceRefs)(nil))
	state.Register((*mountEntry)(nil))
	state.Register((*MountNamespace)(nil))
	state.Register((*opathFD)(nil))
	state.Register((*GetDentryOptions)(nil))
	state.Register((*MkdirOptions)(nil))
	state.Register((*MknodOptions)(nil))
	state.Register((*MountFlags)(nil))
	state.Register((*MountOptions)(nil))
	state.Register((*OpenOptions)(nil))
	state.Register((*ReadOptions)(nil))
	state.Register((*RenameOptions)(nil))
	state.Register((*SetStatOptions)(nil))
	state.Register((*BoundEndpointOptions)(nil))
	state.Register((*GetXattrOptions)(nil))
	state.Register((*SetXattrOptions)(nil))
	state.Register((*StatOptions)(nil))
	state.Register((*UmountOptions)(nil))
	state.Register((*WriteOptions)(nil))
	state.Register((*AccessTypes)(nil))
	state.Register((*ResolvingPath)(nil))
	state.Register((*resolveMountRootOrJumpError)(nil))
	state.Register((*resolveMountPointError)(nil))
	state.Register((*resolveAbsSymlinkError)(nil))
	state.Register((*VirtualFilesystem)(nil))
	state.Register((*PathOperation)(nil))
	state.Register((*VirtualDentry)(nil))
}
