/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.dtolabs.rundeck.core.authorization.AclRuleSetAuthorization;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.AclsUtil;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.RuleSetValidation;
import com.dtolabs.rundeck.core.authorization.UserAndRoles;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.BaseValidator;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.Validator;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import com.dtolabs.rundeck.core.config.Features;
import com.dtolabs.rundeck.core.config.FeaturesDefinition;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import grails.artefact.Artefact;
import grails.events.annotation.Subscriber;
import grails.events.bus.EventBus;
import grails.events.bus.EventBusAware;
import grails.plugins.mail.MailMessageBuilder;
import grails.plugins.mail.SendMail;
import groovy.lang.Closure;
import groovy.lang.Delegate;
import groovy.lang.DelegatesTo;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.events.transform.AnnotatedSubscriber;
import org.grails.plugins.metricsweb.MetricService;
import org.rundeck.app.acl.ACLCacheControl;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.ACLFileManagerListener;
import org.rundeck.app.acl.AclPolicyFile;
import org.rundeck.app.acl.AppACLContext;
import org.rundeck.app.acl.ContextACLManager;
import org.rundeck.app.acl.ContextValidator;
import org.rundeck.app.auth.AuthManager;
import org.rundeck.app.cluster.ClusterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import rundeck.services.AuthorizationService;
import rundeck.services.ConfigurationService;
import rundeck.services.TimedAuthorization;
import rundeck.services.Util;
import rundeck.services.feature.FeatureService;

/*
 * Exception performing whole class analysis ignored.
 */
@Artefact(value="Service")
public class AuthorizationService
implements AuthManager,
InitializingBean,
EventBusAware,
ACLCacheControl,
GroovyObject,
EventBusAware.Trait.FieldHelper,
SendMail,
SendMail.Trait.FieldHelper,
ContextACLManager<AppACLContext>,
ContextValidator<AppACLContext>,
Validator,
BaseValidator,
AnnotatedSubscriber {
    public static final String SYSTEM_CONFIG_PATH = "system:config";
    @Delegate
    private ContextACLManager<AppACLContext> aclStorageFileManager;
    @Delegate
    private Validator rundeckYamlAclValidator;
    private AclRuleSetAuthorization rundeckFilesystemPolicyAuthorization;
    private ConfigurationService configurationService;
    private MetricService metricService;
    private ClusterInfo clusterInfoService;
    private FeatureService featureService;
    private ExecutorService executor;
    private LoadingCache<SourceKey, CacheableYamlSource> sourceCache;
    private LoadingCache<String, AclRuleSetSource> storedPolicyPathsCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private EventBus grails_events_bus_EventBusAware__eventBus;
    private static final transient Logger log;
    @Autowired(required=true)
    private ApplicationContext grails_plugins_mail_SendMail__applicationContext;
    public static final Boolean lazyInit;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AuthorizationService() {
        MetaClass metaClass;
        LoadingCache loadingCache;
        LoadingCache loadingCache2;
        ExecutorService executorService;
        this.executor = executorService = Executors.newFixedThreadPool(2);
        this.sourceCache = loadingCache2 = CacheBuilder.newBuilder().refreshAfterWrite((long)2, TimeUnit.MINUTES).build((CacheLoader)new 1(this));
        this.storedPolicyPathsCache = loadingCache = CacheBuilder.newBuilder().expireAfterWrite((long)30, TimeUnit.MINUTES).build((CacheLoader)new 2(this));
        this.metaClass = metaClass = this.$getStaticMetaClass();
        EventBusAware.Trait.Helper.$init$((EventBusAware)this);
        SendMail.Trait.Helper.$init$((SendMail)this);
        EventBusAware.Trait.Helper.$init$((EventBusAware)this);
        AnnotatedSubscriber.Trait.Helper.$init$((AnnotatedSubscriber)this);
        EventBusAware.Trait.Helper.$init$((EventBusAware)this);
        SendMail.Trait.Helper.$init$((SendMail)this);
    }

    private Authorization getSystemAuthorization() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.metricService)) {
            return (Authorization)ScriptBytecodeAdapter.castToType((Object)this.metricService.withTimer(this.getClass().getName(), "getSystemAuthorization", (Callable)new _getSystemAuthorization_closure1((Object)this, (Object)this)), Authorization.class);
        }
        return AclsUtil.append((Authorization)this.rundeckFilesystemPolicyAuthorization, (Authorization)this.getStoredAuthorization());
    }

    public Authorization getAuthorizationForSubject(UserAndRoles subject) {
        return this.getSystemAuthorization();
    }

    public Authorization getProjectAuthorizationForSubject(UserAndRoles subject, String project) {
        return AclsUtil.append((Authorization)this.getAuthorizationForSubject(subject), (Authorization)this.loadStoredProjectAuthorization(project));
    }

    @Deprecated
    public Authorization getProjectAuthorization(String project) {
        return this.loadStoredProjectAuthorization(project);
    }

    private Authorization timedAuthorization(AclRuleSetAuthorization auth) {
        Timer timer = this.metricService.timer(StringGroovyMethods.plus((String)this.getClass().getName(), (CharSequence)".systemAuthorization"), "evaluateTimer");
        Timer timerset = this.metricService.timer(StringGroovyMethods.plus((String)this.getClass().getName(), (CharSequence)".systemAuthorization"), "evaluateSetTimer");
        Meter meter = this.metricService.meter(StringGroovyMethods.plus((String)this.getClass().getName(), (CharSequence)".systemAuthorization"), "evaluateMeter");
        Meter meterset = this.metricService.meter(StringGroovyMethods.plus((String)this.getClass().getName(), (CharSequence)".systemAuthorization"), "evaluateSetMeter");
        return new TimedAuthorization(auth, timer, timerset, meter, meterset);
    }

    public Set<String> getRoleList() {
        return AclsUtil.getGroups((AclRuleSetSource)AclsUtil.merge((AclRuleSetSource)this.getFilesystemRules(), (AclRuleSetSource)this.getStoredPolicies()));
    }

    public AclRuleSetSource getFilesystemRules() {
        if (this.rundeckFilesystemPolicyAuthorization instanceof AclRuleSetSource) {
            return this.rundeckFilesystemPolicyAuthorization;
        }
        return (AclRuleSetSource)ScriptBytecodeAdapter.castToType(null, AclRuleSetSource.class);
    }

    private AclRuleSetSource getStoredPolicies() {
        return this.loadCachedStoredPolicies();
    }

    public Authorization getStoredAuthorization() {
        return this.loadStoredAuthorization();
    }

    private AclRuleSetSource loadCachedStoredPolicies() {
        return (AclRuleSetSource)ScriptBytecodeAdapter.castToType((Object)this.storedPolicyPathsCache.get((Object)SYSTEM_CONFIG_PATH), AclRuleSetSource.class);
    }

    private AclRuleSetSource loadCachedStoredPolicies(String project) {
        return (AclRuleSetSource)ScriptBytecodeAdapter.castToType((Object)this.storedPolicyPathsCache.get((Object)StringGroovyMethods.plus((String)"project:", (CharSequence)project)), AclRuleSetSource.class);
    }

    public AclRuleSetSource loadStoredPolicies() {
        List paths = this.aclStorageFileManager.listStoredPolicyFiles((Object)AppACLContext.system());
        List sources = DefaultGroovyMethods.findAll((List)DefaultGroovyMethods.collect((Iterable)paths, (Closure)new _loadStoredPolicies_closure2((Object)this, (Object)this)), (Closure)new _loadStoredPolicies_closure3((Object)this, (Object)this));
        return new Policies((Iterable)PoliciesCache.fromSources((Iterable)sources));
    }

    public Policies loadStoredPolicies(String project) {
        Reference project2 = new Reference((Object)project);
        List paths = this.aclStorageFileManager.listStoredPolicyFiles((Object)AppACLContext.project((String)((String)project2.get())));
        List sources = DefaultGroovyMethods.findAll((List)DefaultGroovyMethods.collect((Iterable)paths, (Closure)new _loadStoredPolicies_closure4((Object)this, (Object)this, project2)), (Closure)new _loadStoredPolicies_closure5((Object)this, (Object)this));
        Set context = AuthorizationUtil.projectContext((String)((String)project2.get()));
        return new Policies((Iterable)PoliciesCache.fromSources((Iterable)sources, (Set)context));
    }

    @Subscriber(value="rundeck.bootstrap")
    public void init() {
        Object v0;
        if (!this.featureService.featurePresent((FeaturesDefinition)Features.AUTH_SVC_BOOTSTRAP_WARMUP_CACHE)) {
            return;
        }
        log.debug("init...");
        long start = System.currentTimeMillis();
        this.loadCachedStoredPolicies();
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.currentTimeMillis() - start}, new String[]{"init: loadCachedStoredPolicies: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
    }

    private Authorization loadStoredAuthorization() {
        return AclsUtil.createAuthorization((AclRuleSetSource)this.loadCachedStoredPolicies());
    }

    private Authorization loadStoredProjectAuthorization(String project) {
        return AclsUtil.createAuthorization((AclRuleSetSource)this.loadCachedStoredPolicies(project));
    }

    private CacheableYamlSource loadYamlSource(SourceKey key) {
        boolean exists = this.aclStorageFileManager.existsPolicyFile((Object)key.getContext(), key.getFile());
        if (!exists) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key.getContext(), key.getFile()}, new String[]{"path does not exist: ", " - ", ""})));
        }
        AclPolicyFile aclPolicy = this.aclStorageFileManager.getAclPolicy((Object)key.getContext(), key.getFile());
        if (!DefaultTypeTransformation.booleanUnbox((Object)aclPolicy)) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key.getContext(), key.getFile()}, new String[]{"path does not exist: ", " - ", ""})));
        }
        return YamlProvider.sourceFromString((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key.getIdentity(), key.getFile()}, new String[]{"[", "]", ""})), (String)IOGroovyMethods.getText((InputStream)aclPolicy.getInputStream()), (Date)aclPolicy.getModified(), (ValidationSet)new ValidationSet());
    }

    public boolean needsReload(SourceKey key, CacheableYamlSource source) {
        String file = key.getFile();
        boolean needsReload = true;
        boolean exists = this.aclStorageFileManager.existsPolicyFile((Object)key.getContext(), file);
        AclPolicyFile resource = (AclPolicyFile)ScriptBytecodeAdapter.castToType(exists ? this.aclStorageFileManager.getAclPolicy((Object)key.getContext(), file) : null, AclPolicyFile.class);
        needsReload = resource == null || source.getLastModified() == null || resource.getModified().getTime() > source.getLastModified().getTime();
        return needsReload;
    }

    public void cleanSystemCaches(String systemPath) {
        this.cleanCaches(SourceKey.forContext((AppACLContext)AppACLContext.system(), (String)systemPath));
    }

    public void cleanAclCache(AppACLContext context, String path) {
        this.cleanCaches(SourceKey.forContext((AppACLContext)context, (String)path));
    }

    public void cleanCaches(SourceKey key) {
        this.sourceCache.invalidate((Object)key);
        this.storedPolicyPathsCache.invalidate((Object)key.getIdentity());
        this.getEventBus().notify((CharSequence)"acl.modified", new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"storage", "core-storage", "context", key.getContext(), "path", key.getFile()})});
    }

    public void afterPropertiesSet() throws Exception {
        Object v1;
        LoadingCache loadingCache;
        Object v0;
        String spec = this.configurationService.getString("authorizationService.sourceCache.spec", "refreshAfterWrite=2m");
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{spec}, new String[]{"sourceCache: creating from spec: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        this.sourceCache = loadingCache = CacheBuilder.from((String)spec).recordStats().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
        ContextACLManager contextACLManager = this.aclStorageFileManager;
        if (contextACLManager != null) {
            contextACLManager.addListenerMap((Function)ScriptBytecodeAdapter.castToType((Object)new _afterPropertiesSet_closure6((Object)this, (Object)this), Function.class));
            v1 = null;
        } else {
            v1 = null;
        }
        MetricService metricService = this.metricService;
        MetricRegistry registry = metricService != null ? metricService.getMetricRegistry() : null;
        Util.addCacheMetrics((String)StringGroovyMethods.plus((String)this.getClass().getName(), (CharSequence)".sourceCache"), (MetricRegistry)registry, (Cache)this.sourceCache);
    }

    public void pathWasModified(AppACLContext context, String path) {
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Path modified/deleted: ", ", invalidating"})));
            v0 = null;
        } else {
            v0 = null;
        }
        this.cleanAclCache(context, path);
        if (this.clusterInfoService.isClusterModeEnabled()) {
            this.getEventBus().sendAndReceive((CharSequence)"cluster.clearAclCache", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", path, "project", context.isSystem() ? null : context.getProject(), "system", context.isSystem()}), (Closure)new _pathWasModified_closure7((Object)this, (Object)this));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuthorizationService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Autowired(required=true)
    @Traits.TraitBridge(traitClass=EventBusAware.class, desc="(Lgrails/events/bus/EventBus;)V")
    public void setTargetEventBus(EventBus arg1) {
        EventBusAware.Trait.Helper.setTargetEventBus((EventBusAware)this, (EventBus)arg1);
    }

    @Generated
    public /* synthetic */ void grails_events_bus_EventBusAwaretrait$super$setTargetEventBus(EventBus param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setTargetEventBus", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setTargetEventBus", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=EventBusAware.class, desc="()Lgrails/events/bus/EventBus;")
    public EventBus getEventBus() {
        return EventBusAware.Trait.Helper.getEventBus((EventBusAware)this);
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAwaretrait$super$getEventBus() {
        if (this instanceof GeneratedGroovyProxy) {
            return (EventBus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEventBus", (Object)new Object[0]), EventBus.class);
        }
        return (EventBus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEventBus"), EventBus.class);
    }

    static {
        Logger logger;
        Boolean bl;
        lazyInit = bl = Boolean.FALSE;
        log = logger = LoggerFactory.getLogger((String)"rundeck.services.AuthorizationService");
        EventBusAware.Trait.Helper.$static$init$(AuthorizationService.class);
        SendMail.Trait.Helper.$static$init$(AuthorizationService.class);
        EventBusAware.Trait.Helper.$static$init$(AuthorizationService.class);
        AnnotatedSubscriber.Trait.Helper.$static$init$(AuthorizationService.class);
        EventBusAware.Trait.Helper.$static$init$(AuthorizationService.class);
        SendMail.Trait.Helper.$static$init$(AuthorizationService.class);
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAware__eventBus$get() {
        return this.grails_events_bus_EventBusAware__eventBus;
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAware__eventBus$set(EventBus val) {
        EventBus eventBus;
        this.grails_events_bus_EventBusAware__eventBus = eventBus = val;
        return eventBus;
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="()Lorg/springframework/context/ApplicationContext;")
    public ApplicationContext getApplicationContext() {
        return SendMail.Trait.Helper.getApplicationContext((SendMail)this);
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMailtrait$super$getApplicationContext() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApplicationContext)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getApplicationContext", (Object)new Object[0]), ApplicationContext.class);
        }
        return (ApplicationContext)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getApplicationContext"), ApplicationContext.class);
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="(Lorg/springframework/context/ApplicationContext;)V")
    public void setApplicationContext(ApplicationContext arg1) {
        SendMail.Trait.Helper.setApplicationContext((SendMail)this, (ApplicationContext)arg1);
    }

    @Generated
    public /* synthetic */ void grails_plugins_mail_SendMailtrait$super$setApplicationContext(ApplicationContext arg0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setApplicationContext", (Object)new Object[]{arg0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setApplicationContext", (Object[])new Object[]{arg0});
        }
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Object sendMail(@DelegatesTo(strategy=1, genericTypeIndex=-1, type="", value=MailMessageBuilder.class, target="") Closure arg1) {
        return SendMail.Trait.Helper.sendMail((SendMail)this, (Closure)arg1);
    }

    @Generated
    public /* synthetic */ Object grails_plugins_mail_SendMailtrait$super$sendMail(Closure arg0) {
        if (this instanceof GeneratedGroovyProxy) {
            return InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"sendMail", (Object)new Object[]{arg0});
        }
        return ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"sendMail", (Object[])new Object[]{arg0});
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMail__applicationContext$get() {
        return this.grails_plugins_mail_SendMail__applicationContext;
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMail__applicationContext$set(ApplicationContext val) {
        ApplicationContext applicationContext;
        this.grails_plugins_mail_SendMail__applicationContext = applicationContext = val;
        return applicationContext;
    }

    @Generated
    public ACLFileManager forContext(AppACLContext param0) {
        return this.aclStorageFileManager.forContext((Object)param0);
    }

    @Generated
    public void addListenerMap(Function<AppACLContext, ACLFileManagerListener> param0) {
        this.aclStorageFileManager.addListenerMap(param0);
    }

    @Generated
    public void addListener(AppACLContext param0, ACLFileManagerListener param1) {
        this.aclStorageFileManager.addListener((Object)param0, param1);
    }

    @Generated
    public void removeListener(AppACLContext param0, ACLFileManagerListener param1) {
        this.aclStorageFileManager.removeListener((Object)param0, param1);
    }

    @Generated
    public long storePolicyFile(AppACLContext param0, String param1, InputStream param2) throws IOException {
        return this.aclStorageFileManager.storePolicyFile((Object)param0, param1, param2);
    }

    @Generated
    public boolean deletePolicyFile(AppACLContext param0, String param1) throws IOException {
        return this.aclStorageFileManager.deletePolicyFile((Object)param0, param1);
    }

    @Generated
    public long storePolicyFileContents(AppACLContext param0, String param1, String param2) throws IOException {
        return this.aclStorageFileManager.storePolicyFileContents((Object)param0, param1, param2);
    }

    @Generated
    public AclPolicyFile getAclPolicy(AppACLContext param0, String param1) {
        return this.aclStorageFileManager.getAclPolicy((Object)param0, param1);
    }

    @Generated
    public String getPolicyFileContents(AppACLContext param0, String param1) throws IOException {
        return this.aclStorageFileManager.getPolicyFileContents((Object)param0, param1);
    }

    @Generated
    public long loadPolicyFileContents(AppACLContext param0, String param1, OutputStream param2) throws IOException {
        return this.aclStorageFileManager.loadPolicyFileContents((Object)param0, param1, param2);
    }

    @Generated
    public boolean existsPolicyFile(AppACLContext param0, String param1) {
        return this.aclStorageFileManager.existsPolicyFile((Object)param0, param1);
    }

    @Generated
    public List<String> listStoredPolicyFiles(AppACLContext param0) {
        return this.aclStorageFileManager.listStoredPolicyFiles((Object)param0);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(AppACLContext param0, String param1, String param2) throws IOException {
        return this.aclStorageFileManager.validateYamlPolicy((Object)param0, param1, param2);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validatePolicyFile(AppACLContext param0, String param1) throws IOException {
        return this.aclStorageFileManager.validatePolicyFile((Object)param0, param1);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String param0, String param1, File param2) throws IOException {
        return this.rundeckYamlAclValidator.validateYamlPolicy(param0, param1, param2);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String param0, String param1, String param2) throws IOException {
        return this.rundeckYamlAclValidator.validateYamlPolicy(param0, param1, param2);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(File param0) throws IOException {
        return this.rundeckYamlAclValidator.validateYamlPolicy(param0);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String param0, String param1) throws IOException {
        return this.rundeckYamlAclValidator.validateYamlPolicy(param0, param1);
    }

    @Generated
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String param0, File param1) throws IOException {
        return this.rundeckYamlAclValidator.validateYamlPolicy(param0, param1);
    }

    @PostConstruct
    @Traits.TraitBridge(traitClass=AnnotatedSubscriber.class, desc="()V")
    public void registerMethods() {
        AnnotatedSubscriber.Trait.Helper.registerMethods((AnnotatedSubscriber)this);
    }

    @Generated
    public /* synthetic */ void org_grails_events_transform_AnnotatedSubscribertrait$super$registerMethods() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"registerMethods", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"registerMethods");
        }
    }

    @Traits.TraitBridge(traitClass=AnnotatedSubscriber.class, desc="()Ljava/util/List;")
    public List<Method> getSubscribedMethods() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this.getClass().getMethod("init", new Class[0])});
    }

    @Generated
    public /* synthetic */ List<Method> org_grails_events_transform_AnnotatedSubscribertrait$super$getSubscribedMethods() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getSubscribedMethods", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getSubscribedMethods"), List.class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthorizationService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthorizationService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthorizationService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AuthorizationService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AuthorizationService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Authorization access$0(AuthorizationService $that, AclRuleSetAuthorization auth) {
        return $that.timedAuthorization(auth);
    }

    public static /* synthetic */ CacheableYamlSource access$1(AuthorizationService $that, SourceKey key) {
        return $that.loadYamlSource(key);
    }

    public static /* synthetic */ AclRuleSetAuthorization pfaccess$0(AuthorizationService $that) {
        return $that.rundeckFilesystemPolicyAuthorization;
    }

    public static /* synthetic */ ExecutorService pfaccess$1(AuthorizationService $that) {
        return $that.executor;
    }

    public static /* synthetic */ LoadingCache<SourceKey, CacheableYamlSource> pfaccess$2(AuthorizationService $that) {
        return $that.sourceCache;
    }

    public static /* synthetic */ Logger pfaccess$3(AuthorizationService $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(AuthorizationService.class, AuthorizationService.class, (String)"log"), Logger.class);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public ContextACLManager<AppACLContext> getAclStorageFileManager() {
        return this.aclStorageFileManager;
    }

    @Generated
    public void setAclStorageFileManager(ContextACLManager<AppACLContext> contextACLManager) {
        this.aclStorageFileManager = contextACLManager;
    }

    @Generated
    public Validator getRundeckYamlAclValidator() {
        return this.rundeckYamlAclValidator;
    }

    @Generated
    public void setRundeckYamlAclValidator(Validator validator) {
        this.rundeckYamlAclValidator = validator;
    }

    @Generated
    public AclRuleSetAuthorization getRundeckFilesystemPolicyAuthorization() {
        return this.rundeckFilesystemPolicyAuthorization;
    }

    @Generated
    public void setRundeckFilesystemPolicyAuthorization(AclRuleSetAuthorization aclRuleSetAuthorization) {
        this.rundeckFilesystemPolicyAuthorization = aclRuleSetAuthorization;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Generated
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Generated
    public MetricService getMetricService() {
        return this.metricService;
    }

    @Generated
    public void setMetricService(MetricService metricService) {
        this.metricService = metricService;
    }

    @Generated
    public ClusterInfo getClusterInfoService() {
        return this.clusterInfoService;
    }

    @Generated
    public void setClusterInfoService(ClusterInfo clusterInfo) {
        this.clusterInfoService = clusterInfo;
    }

    @Generated
    public FeatureService getFeatureService() {
        return this.featureService;
    }

    @Generated
    public void setFeatureService(FeatureService featureService) {
        this.featureService = featureService;
    }
}

