/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Tr900ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number(">(d+),").number("d+,").number("(d),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([EW])").number("(ddd)(dd.d+),").expression("([NS])").number("(dd)(dd.d+),").expression("[^,]*,").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+),").number("(d+)-").number("(d+),").number("d+,").number("(d+),").number("(d+)").any().compile();

    public Tr900ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.nextInt(0) == 1);
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("rssi", parser.nextDouble());
        position.set("event", parser.nextInt(0));
        position.set("adc1", parser.nextInt(0));
        position.set("battery", parser.nextInt(0));
        position.set("input", parser.next());
        position.set("status", parser.next());
        return position;
    }
}

