/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.xz;

import coursierapi.shaded.xz.ArrayCache;
import coursierapi.shaded.xz.FilterDecoder;
import coursierapi.shaded.xz.LZMA2Coder;
import coursierapi.shaded.xz.LZMA2InputStream;
import coursierapi.shaded.xz.UnsupportedOptionsException;
import java.io.InputStream;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] byArray) throws UnsupportedOptionsException {
        if (byArray.length != 1 || (byArray[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | byArray[0] & 1;
        this.dictSize <<= (byArray[0] >>> 1) + 11;
    }

    @Override
    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new LZMA2InputStream(inputStream, this.dictSize, null, arrayCache);
    }
}

