/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.project;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class IgnoringXmlFilter
extends XMLFilterImpl {
    private final Deque<Boolean> include = new ArrayDeque<Boolean>();

    public IgnoringXmlFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (Objects.equals(uri, "https://www.dita-ot.org/project")) {
            this.include.push(true);
            super.startElement(uri, localName, qName, this.filterAttributes(atts));
        } else {
            this.include.push(false);
        }
    }

    private Attributes filterAttributes(Attributes atts) {
        int len = atts.getLength();
        if (len == 0) {
            return atts;
        }
        boolean allLocal = true;
        for (int i = 0; i < len; ++i) {
            String ns = atts.getURI(i);
            if (ns == null || ns.isEmpty()) continue;
            allLocal = false;
            break;
        }
        if (allLocal) {
            return atts;
        }
        AttributesImpl res = null;
        for (int i = 0; i < len; ++i) {
            String ns = atts.getURI(i);
            if (ns != null && !ns.isEmpty()) continue;
            if (res == null) {
                res = new AttributesImpl();
            }
            res.addAttribute(ns, atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        if (res == null) {
            return XMLUtils.EMPTY_ATTRIBUTES;
        }
        return res;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.include.pop().booleanValue()) {
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.include.peek().booleanValue()) {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.include.peek().booleanValue()) {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.include.peek().booleanValue()) {
            super.skippedEntity(name);
        }
    }
}

