/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Configuration;
import org.slf4j.helpers.MarkerIgnoringBase;

public abstract class AbstractLogger
extends MarkerIgnoringBase
implements DITAOTLogger {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BOLD = "\u001b[1m";
    protected int msgOutputLevel = 4;
    protected boolean useColor;
    protected final boolean legacyFormat = Configuration.configuration.getOrDefault("cli.log-format", "legacy").equals("legacy");
    private static final Pattern ARGUMENT = Pattern.compile("\\{}|%s");

    public void setOutputLevel(int msgOutputLevel) {
        this.msgOutputLevel = msgOutputLevel;
    }

    public void setUseColor(boolean useColor) {
        this.useColor = useColor;
    }

    public void info(String msg) {
        this.log(msg, new Object[0], null, 2);
    }

    public void info(String format, Object arg) {
        this.log(format, new Object[]{arg}, null, 2);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(format, new Object[]{arg1, arg2}, null, 2);
    }

    public void info(String format, Object ... arguments) {
        this.log(format, arguments, null, 2);
    }

    public void info(String msg, Throwable t) {
        this.log(msg, new Object[0], t, 2);
    }

    public boolean isWarnEnabled() {
        return this.msgOutputLevel >= 1;
    }

    public void warn(String msg) {
        this.log(msg, new Object[0], null, 1);
    }

    public void warn(String format, Object arg) {
        this.log(format, new Object[]{arg}, null, 1);
    }

    public void warn(String format, Object ... arguments) {
        this.log(format, arguments, null, 1);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(format, new Object[]{arg1, arg2}, null, 1);
    }

    public void warn(String msg, Throwable t) {
        this.log(msg, new Object[0], t, 1);
    }

    public boolean isErrorEnabled() {
        return this.msgOutputLevel >= 0;
    }

    public void error(String msg) {
        this.log(msg, new Object[0], null, 0);
    }

    public void error(String format, Object arg) {
        if (arg instanceof Throwable) {
            this.log(format, new Object[0], (Throwable)arg, 0);
        } else {
            this.log(format, new Object[]{arg}, null, 0);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (arg2 instanceof Throwable) {
            this.log(format, new Object[]{arg1}, (Throwable)arg2, 0);
        } else {
            this.log(format, new Object[]{arg1, arg2}, null, 0);
        }
    }

    public void error(String format, Object ... arguments) {
        Object last = arguments[arguments.length - 1];
        if (last instanceof Throwable) {
            Object[] args = new Object[arguments.length - 1];
            System.arraycopy(arguments, 0, args, 0, args.length);
            this.log(format, args, (Throwable)last, 0);
        } else {
            this.log(format, arguments, null, 0);
        }
    }

    public void error(String msg, Throwable t) {
        this.log(msg, new Object[0], t, 0);
    }

    public boolean isTraceEnabled() {
        return this.msgOutputLevel >= 4;
    }

    public void trace(String msg) {
        this.log(msg, new Object[0], null, 4);
    }

    public void trace(String format, Object arg) {
        if (arg instanceof Throwable) {
            this.log(format, new Object[0], (Throwable)arg, 4);
        } else {
            this.log(format, new Object[]{arg}, null, 4);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (arg2 instanceof Throwable) {
            this.log(format, new Object[]{arg1}, (Throwable)arg2, 4);
        } else {
            this.log(format, new Object[]{arg1, arg2}, null, 4);
        }
    }

    public void trace(String format, Object ... arguments) {
        Object last = arguments[arguments.length - 1];
        if (last instanceof Throwable) {
            Object[] args = new Object[arguments.length - 1];
            System.arraycopy(arguments, 0, args, 0, args.length);
            this.log(format, args, (Throwable)last, 4);
        } else {
            this.log(format, arguments, null, 4);
        }
    }

    public void trace(String msg, Throwable t) {
        this.log(msg, new Object[0], t, 4);
    }

    public boolean isDebugEnabled() {
        return this.msgOutputLevel >= 3;
    }

    public void debug(String msg) {
        this.log(msg, new Object[0], null, 3);
    }

    public void debug(String format, Object arg) {
        this.log(format, new Object[]{arg}, null, 3);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(format, new Object[]{arg1, arg2}, null, 3);
    }

    public void debug(String format, Object ... arguments) {
        this.log(format, arguments, null, 3);
    }

    public void debug(String msg, Throwable t) {
        this.log(msg, new Object[0], t, 3);
    }

    public boolean isInfoEnabled() {
        return this.msgOutputLevel >= 2;
    }

    public abstract void log(String var1, Throwable var2, int var3);

    protected void log(String msg, Object[] args, Throwable t, int level) {
        if (level > this.msgOutputLevel) {
            return;
        }
        StringBuilder buf = null;
        if (args.length > 0) {
            if (buf == null) {
                buf = new StringBuilder();
            }
            if (msg.contains("{}") || msg.contains("%s")) {
                buf.append(MessageFormat.format(this.addIndex(msg), args));
            } else {
                buf.append(MessageFormat.format(msg, args));
            }
        } else if (buf != null) {
            buf.append(msg);
        }
        String res = this.legacyFormat ? (buf != null ? buf.toString() : msg) : (buf != null ? AbstractLogger.removeLevelPrefix(buf).toString() : AbstractLogger.removeLevelPrefix(msg));
        this.log(res, t, level);
    }

    protected static String removeLevelPrefix(String msg) {
        int start = msg.indexOf("][");
        if (start == -1) {
            return msg;
        }
        int end = msg.indexOf("]", start + 1);
        if (end == -1) {
            return msg;
        }
        return switch (msg.substring(start + 2, end)) {
            case "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL" -> msg.substring(0, start) + msg.substring(end);
            default -> msg;
        };
    }

    protected static StringBuilder removeLevelPrefix(StringBuilder msg) {
        int start = msg.indexOf("][");
        if (start == -1) {
            return msg;
        }
        int end = msg.indexOf("]", start + 1);
        if (end == -1) {
            return msg;
        }
        return switch (msg.substring(start + 2, end)) {
            case "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL" -> msg.replace(start, end, "");
            default -> msg;
        };
    }

    private String addIndex(String msg) {
        Matcher matcher = ARGUMENT.matcher(msg);
        StringBuilder buf = new StringBuilder();
        int start = 0;
        int i = 0;
        while (matcher.find(start)) {
            buf.append(msg, start, matcher.start());
            buf.append("{");
            buf.append(i);
            buf.append("}");
            start = matcher.end();
            ++i;
        }
        if (start < msg.length()) {
            buf.append(msg, start, msg.length());
        }
        return buf.toString();
    }
}

