/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jemmy.JemmyException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FolderContext {
    private URL _base;

    public FolderContext(URL uRL) {
        FileObject[] fileObjectArray = URLMapper.findFileObjects((URL)uRL);
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            throw new IllegalStateException("Cannot find file object: " + uRL);
        }
        this._base = uRL;
    }

    public static FolderContext getDataFolder(JellyTestCase jellyTestCase) {
        URL uRL = ((Object)((Object)jellyTestCase)).getClass().getResource("data/");
        if (uRL == null) {
            throw new IllegalStateException("Cannot find 'data' folder for: " + ((Object)((Object)jellyTestCase)).getClass().getName());
        }
        return new FolderContext(uRL);
    }

    public static FolderContext getWorkDir(JellyTestCase jellyTestCase) throws IOException {
        String string = jellyTestCase.getWorkDir().getAbsolutePath();
        FileSystem fileSystem = Repository.getDefault().findFileSystem(string);
        if (fileSystem == null) {
            throw new IllegalStateException("Cannot mount: " + string);
        }
        URL uRL = fileSystem.getRoot().getURL();
        if (uRL == null) {
            throw new IllegalStateException("Cannot find work dir for: " + ((Object)((Object)jellyTestCase)).getClass().getName());
        }
        return new FolderContext(uRL);
    }

    public FileObject getFileObject(String string) {
        Object var2_2 = null;
        URL uRL = null;
        uRL = string == null ? this._base : this.makeURL(string);
        FileObject[] fileObjectArray = URLMapper.findFileObjects((URL)uRL);
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return null;
        }
        return fileObjectArray[0];
    }

    public DataObject createFolder(String string) throws IOException {
        return this.createDataObject(string, null);
    }

    public DataObject createDataObject(String string, final String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getParent();
        final String string4 = file.getName();
        final FileObject fileObject = this.getFileObject(string3);
        if (fileObject == null) {
            throw new IllegalStateException("Cannot find folder: " + this.makeURL(string3));
        }
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (string2 == null) {
                    fileObjectArray[0] = fileObject.createFolder(string4);
                } else {
                    FileObject fileObject2 = fileObject.createData(string4);
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject2.lock();
                        OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                        outputStream = new BufferedOutputStream(outputStream);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                        outputStreamWriter.write(string2);
                        ((Writer)outputStreamWriter).close();
                        fileLock.releaseLock();
                        fileLock = null;
                        fileObjectArray[0] = fileObject2;
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        return DataObject.find((FileObject)fileObjectArray[0]);
    }

    public DataObject getDataObject(String string) {
        DataObject dataObject = null;
        FileObject fileObject = this.getFileObject(string);
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    public void deleteDataObject(String string) throws IOException {
        DataObject dataObject = this.getDataObject(string);
        if (dataObject == null) {
            return;
        }
        dataObject.getNodeDelegate().destroy();
    }

    public String getTreePath(String string) {
        String string2 = null;
        FileObject fileObject = this.getFileObject("");
        try {
            string2 = fileObject.getFileSystem().getDisplayName() + '|' + fileObject.getPackageName('|') + '|' + string;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new JemmyException("Cannot get filesystem for: " + fileObject.getPackageNameExt('/', '.'), (Throwable)fileStateInvalidException);
        }
        return string2;
    }

    private URL makeURL(String string) {
        if (string == null || string.equals("")) {
            return this._base;
        }
        string = string.trim();
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        URL uRL = this._base;
        try {
            uRL = new URL(this._base, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }
}

