/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.ShowHistoryAction;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class HistoryViewerPanel
extends HistoryBrowserPanel {
    protected transient AdjustmentSynchronizer adjustmentSynchronizer;
    protected transient SelectionSynchronizer selectionSynchronizer;

    protected HistoryViewerPanel(HistoryBrowserModel model) {
        this.setModel(model);
        this.build();
    }

    private JScrollPane embedInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(pane.getVerticalScrollBar());
        return pane;
    }

    protected abstract JTable buildReferenceTable();

    protected abstract JTable buildCurrentTable();

    private void build() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embedInScrollPane(this.buildReferenceTable()), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embedInScrollPane(this.buildCurrentTable()), gc);
    }

    protected void enableSemanticSelectionSynchronization(ListSelectionModel thisSelectionModel, DiffTableModel thisModel, DiffTableModel otherModel, BiPredicate<TwoColumnDiff.Item, TwoColumnDiff.Item> isSemanticallyEquivalent) {
        this.selectionSynchronizer.setSelectionIndexMapper((selection, sourceSelectionModel) -> {
            DiffTableModel sourceModel = sourceSelectionModel == thisSelectionModel ? thisModel : otherModel;
            DiffTableModel destinationModel = sourceSelectionModel == thisSelectionModel ? otherModel : thisModel;
            return IntStream.range(0, destinationModel.getRowCount()).filter(i -> isSemanticallyEquivalent.test(sourceModel.getValueAt((int)selection, 0), destinationModel.getValueAt(i, 0)));
        });
    }

    static class ZoomToObjectAction
    extends AbstractAction {
        private transient PrimitiveId primitiveId;

        ZoomToObjectAction(String name, String shortDescription) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", shortDescription);
            new ImageProvider("dialogs", "zoomin").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            IPrimitive p = this.getPrimitiveToZoom();
            if (p != null && p.isSelectable()) {
                p.getDataSet().setSelected(p);
                AutoScaleAction.autoScale(AutoScaleAction.AutoScaleMode.SELECTION);
            }
        }

        public void setPrimitiveId(PrimitiveId pid) {
            this.primitiveId = pid;
            this.updateEnabledState();
        }

        protected IPrimitive getPrimitiveToZoom() {
            if (this.primitiveId == null) {
                return null;
            }
            OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
            if (ds == null) {
                return null;
            }
            return ds.getPrimitiveById(this.primitiveId);
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getActiveData() != null && this.getPrimitiveToZoom() != null);
        }
    }

    static class ListPopupMenu
    extends JPopupMenu {
        private final ZoomToObjectAction zoomToObjectAction;
        private final ShowHistoryAction showHistoryAction;

        ListPopupMenu(String name, String shortDescription) {
            this.zoomToObjectAction = new ZoomToObjectAction(name, shortDescription);
            this.add(this.zoomToObjectAction);
            this.showHistoryAction = new ShowHistoryAction();
            this.add(this.showHistoryAction);
        }

        void prepare(PrimitiveId pid) {
            this.zoomToObjectAction.setPrimitiveId(pid);
            this.zoomToObjectAction.updateEnabledState();
            this.showHistoryAction.setPrimitiveId(pid);
            this.showHistoryAction.updateEnabledState();
        }
    }
}

