/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class SessionTokenAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider,
RefreshableOnNotAuthenticatedProvider<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTokenAuthenticationDetailsProvider.class);
    private static final String CONFIG_FILE_DEBUG_INFORMATION_LOG = "\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm";
    private static final String DEFAULT_PRIVATE_KEY_FILE_PATH = "~/.oci/sessions/DEFAULT/oci_api_key.pem";
    private static final long DEFAULT_REFRESH_INITIAL_DELAY_MINUTES = 0L;
    private static final long DEFAULT_REFRESH_INTERVAL_MINUTES = 55L;
    private static final long DEFAULT_SESSION_LIFETIME_HOURS = 24L;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture scheduledFuture;
    private final boolean usingDefaultScheduler;
    private final SimplePrivateKeySupplier privateKeySupplier;
    private final Region region;
    private final char[] passphraseCharacters;
    private final String tenantId;
    private final String fingerprint;
    private final String userId;
    private final String sessionTokenFilePath;
    private volatile String sessionToken;

    public SessionTokenAuthenticationDetailsProvider() throws IOException {
        this(ConfigFileReader.parseDefault());
    }

    public SessionTokenAuthenticationDetailsProvider(String profile) throws IOException {
        this(ConfigFileReader.parseDefault(profile));
    }

    public SessionTokenAuthenticationDetailsProvider(String configurationFilePath, String profile) throws IOException {
        this(ConfigFileReader.parse(configurationFilePath, profile));
    }

    protected SessionTokenAuthenticationDetailsProvider(String privateKeyFilePath, Region region, String regionId, String passPhrase, String tenantId, String fingerprint, String userId, String sessionTokenFilePath, String sessionToken, long initialRefreshDelay, long refreshPeriod, TimeUnit timeUnit, long sessionLifetimeHours, ScheduledExecutorService scheduler, boolean usingDefaultScheduler) throws IOException {
        if (privateKeyFilePath == null) {
            LOG.debug("privateKeyFilePath was not provided, using the default path: {}", (Object)DEFAULT_PRIVATE_KEY_FILE_PATH);
            privateKeyFilePath = DEFAULT_PRIVATE_KEY_FILE_PATH;
        }
        this.privateKeySupplier = new SimplePrivateKeySupplier(privateKeyFilePath);
        if (region == null) {
            Validate.notNull(regionId, "SessionTokenAuthenticationDetailsProvider: Set either region or regionId", new Object[0]);
            this.region = Region.fromRegionCodeOrId(regionId);
        } else {
            this.region = region;
        }
        this.passphraseCharacters = passPhrase != null ? passPhrase.toCharArray() : null;
        this.tenantId = Validate.notNull(tenantId, "SessionTokenAuthenticationDetailsProvider: tenantId is a required parameter", new Object[0]);
        this.fingerprint = fingerprint;
        this.userId = userId;
        this.sessionTokenFilePath = sessionTokenFilePath;
        this.sessionToken = sessionToken;
        if (sessionToken == null) {
            Validate.notNull(sessionTokenFilePath, "SessionTokenAuthenticationDetailsProvider: Set either sessionToken or sessionTokenFilePath", new Object[0]);
            this.setSessionTokenFromFilePath(sessionTokenFilePath);
        }
        this.scheduler = scheduler;
        this.usingDefaultScheduler = usingDefaultScheduler;
        this.setTokenRefreshSchedule(initialRefreshDelay, refreshPeriod, timeUnit, sessionLifetimeHours);
    }

    public SessionTokenAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) throws IOException {
        this.sessionTokenFilePath = Validate.notNull(configFile.get("security_token_file"), "Missing security_token_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        this.tenantId = Validate.notNull(configFile.get("tenancy"), "Missing tenancy in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        String pemFilePath = Validate.notNull(configFile.get("key_file"), "Missing key_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        this.privateKeySupplier = new SimplePrivateKeySupplier(pemFilePath);
        this.region = ConfigFileAuthenticationDetailsProvider.getRegionFromConfigFile(configFile);
        this.setSessionTokenFromFilePath(this.sessionTokenFilePath);
        this.usingDefaultScheduler = true;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.setTokenRefreshSchedule(0L, 55L, TimeUnit.MINUTES, 24L);
        this.fingerprint = configFile.get("fingerprint");
        this.userId = configFile.get("user");
        String passPhrase = configFile.get("pass_phrase");
        this.passphraseCharacters = passPhrase != null ? passPhrase.toCharArray() : null;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public ExecutorService getScheduler() {
        return this.scheduler;
    }

    public void close() {
        this.scheduledFuture.cancel(false);
        if (this.usingDefaultScheduler) {
            this.scheduler.shutdownNow();
        }
    }

    private void setTokenRefreshSchedule(long refreshDelay, long refreshInterval, TimeUnit timeUnit, long sessionLifetime) {
        if (this.scheduler == null) {
            LOG.debug("Refresh schedule disabled");
            return;
        }
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> this.refreshSessionToken(), refreshDelay, refreshInterval, timeUnit);
        this.scheduler.schedule(() -> this.close(), sessionLifetime, TimeUnit.HOURS);
    }

    public void setSessionTokenFromFilePath(String sessionTokenFilePath) throws IOException {
        File sessionTokenFile = new File(FileUtils.expandUserHome(sessionTokenFilePath));
        StringBuilder token = new StringBuilder();
        LOG.info("Loading session token from: {}", (Object)sessionTokenFile.getAbsolutePath());
        Scanner reader = new Scanner(sessionTokenFile);
        while (reader.hasNextLine()) {
            token.append(reader.nextLine());
        }
        reader.close();
        this.setSessionToken(token.toString());
    }

    private void writeCurrentSessionTokenToFile() throws IOException {
        if (this.sessionTokenFilePath == null) {
            LOG.debug("Not writing token to file");
            return;
        }
        FileWriter writer = new FileWriter(FileUtils.expandUserHome(this.sessionTokenFilePath));
        LOG.info("Writing current session token to token path");
        writer.write(this.sessionToken);
        writer.close();
    }

    @Override
    public String refresh() {
        LOG.debug("Refreshing session token from file");
        String oldSessionToken = this.sessionToken;
        try {
            this.setSessionTokenFromFilePath(this.sessionTokenFilePath);
            if (this.sessionToken.equals(oldSessionToken)) {
                LOG.warn("A session token refresh was attempted but it did not change. The token file has not been updated!");
            } else {
                LOG.info("A session token refresh was attempted and the token was successfully changed. The token file has been updated!");
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to refresh session token.", (Throwable)e);
            e.printStackTrace();
        }
        return this.sessionToken;
    }

    public synchronized boolean refreshSessionToken() {
        Service service = Services.serviceBuilder().serviceName("auth").serviceEndpointPrefix("auth").build();
        String endpoint = Region.formatDefaultRegionEndpoint(service, this.region);
        LOG.debug("Refreshing session token, refresh endpoint: {}/v1/authentication/refresh", (Object)endpoint);
        try {
            HttpClient httpClient = HttpProvider.getDefault().newBuilder().baseUri(endpoint).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(DefaultRequestSigner.createRequestSigner(this), Collections.emptyMap())).build();
            SessionTokenRefreshRequest request = new SessionTokenRefreshRequest(this.sessionToken);
            this.sessionToken = ((TokenRefreshResponse)ClientCall.builder((HttpClient)httpClient, request, (Supplier<TokenRefreshResponse.Builder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/oracle/bmc/auth/SessionTokenAuthenticationDetailsProvider$TokenRefreshResponse$Builder;)()).logger((Logger)SessionTokenAuthenticationDetailsProvider.LOG, (String)"SessionTokenRefresh").method((Method)Method.POST).serviceDetails((String)"Java SDK Authentication", (String)"SessionTokenRefresh", (String)"https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm").appendPathPart((String)"v1").appendPathPart((String)"authentication").appendPathPart((String)"refresh").appendHeader((String)"content-type", (String)"application/json").handleBody(SessionToken.class, (BiConsumer<TokenRefreshResponse.Builder, SessionToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, token(com.oracle.bmc.auth.SessionTokenAuthenticationDetailsProvider$SessionToken ), (Lcom/oracle/bmc/auth/SessionTokenAuthenticationDetailsProvider$TokenRefreshResponse$Builder;Lcom/oracle/bmc/auth/SessionTokenAuthenticationDetailsProvider$SessionToken;)V)()).hasBody().callSync()).token.getToken();
            this.writeCurrentSessionTokenToFile();
        }
        catch (Exception e) {
            LOG.error("Unable to refresh session token.", (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.sessionToken;
    }

    @Override
    public InputStream getPrivateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.passphraseCharacters != null ? new String(this.passphraseCharacters) : null;
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphraseCharacters;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public String toString() {
        return String.format("SessionTokenAuthenticationDetailsProvider(region=%s, tenantId=%s, userId=%s, fingerprint=%s, passphraseCharacters=%s, privateKeySupplier=%s, sessionTokenFilePath=%s, sessionToken=%s)", this.region.toString(), this.tenantId, this.userId, this.fingerprint, this.passphraseCharacters != null ? "<provided>" : null, this.privateKeySupplier != null ? "<provided>" : null, this.sessionTokenFilePath != null ? "<provided>" : null, this.sessionToken != null ? "<provided>" : null);
    }

    public static SessionTokenAuthenticationDetailsProviderBuilder builder() {
        return new SessionTokenAuthenticationDetailsProviderBuilder();
    }

    public static class SessionTokenAuthenticationDetailsProviderBuilder {
        private String privateKeyFilePath = null;
        private Region region = null;
        private String regionId = null;
        private String passPhrase = null;
        private String tenantId = null;
        private String fingerprint = null;
        private String userId = null;
        private String sessionTokenFilePath = null;
        private String sessionToken = null;
        private boolean usingDefaultScheduler = true;
        private long initialRefreshDelay = 0L;
        private long refreshPeriod = 55L;
        private TimeUnit timeUnit = TimeUnit.MINUTES;
        private long sessionLifetimeHours = 24L;
        private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

        public SessionTokenAuthenticationDetailsProviderBuilder privateKeyFilePath(String privateKeyFilePath) {
            this.privateKeyFilePath = privateKeyFilePath;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder region(Region region) {
            this.region = region;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder region(String regionId) {
            this.regionId = regionId;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder passPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder sessionTokenFilePath(String sessionTokenFilePath) {
            this.sessionTokenFilePath = sessionTokenFilePath;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder initialRefreshDelay(long initialRefreshDelay) {
            this.initialRefreshDelay = initialRefreshDelay;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder refreshPeriod(long refreshPeriod) {
            this.refreshPeriod = refreshPeriod;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder sessionLifetimeHours(long sessionLifetimeHours) {
            this.sessionLifetimeHours = sessionLifetimeHours;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder scheduler(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            this.usingDefaultScheduler = false;
            return this;
        }

        public SessionTokenAuthenticationDetailsProviderBuilder disableScheduledRefresh() {
            this.scheduler = null;
            this.usingDefaultScheduler = false;
            return this;
        }

        public SessionTokenAuthenticationDetailsProvider build() throws IOException {
            return new SessionTokenAuthenticationDetailsProvider(this.privateKeyFilePath, this.region, this.regionId, this.passPhrase, this.tenantId, this.fingerprint, this.userId, this.sessionTokenFilePath, this.sessionToken, this.initialRefreshDelay, this.refreshPeriod, this.timeUnit, this.sessionLifetimeHours, this.scheduler, this.usingDefaultScheduler);
        }
    }

    static class TokenRefreshResponse
    extends BmcResponse {
        final SessionToken token;

        TokenRefreshResponse(int status, Map<String, List<String>> headers, SessionToken token) {
            super(status, headers);
            this.token = token;
        }

        public static Builder builder() {
            return new Builder();
        }

        static class Builder
        implements BmcResponse.Builder<TokenRefreshResponse> {
            private int status;
            private Map<String, List<String>> headers;
            SessionToken token;

            Builder() {
            }

            private Builder(TokenRefreshResponse b) {
                this.status = b.get__httpStatusCode__();
                this.headers = b.getHeaders();
                this.token = b.token;
            }

            public BmcResponse.Builder<TokenRefreshResponse> token(SessionToken token) {
                this.token = token;
                return this;
            }

            @Override
            public BmcResponse.Builder<TokenRefreshResponse> __httpStatusCode__(int __httpStatusCode__) {
                this.status = __httpStatusCode__;
                return this;
            }

            @Override
            public BmcResponse.Builder<TokenRefreshResponse> headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Override
            public BmcResponse.Builder<TokenRefreshResponse> copy(TokenRefreshResponse o) {
                return new Builder(o);
            }

            @Override
            public TokenRefreshResponse build() {
                return new TokenRefreshResponse(this.status, this.headers, this.token);
            }
        }
    }

    @InternalSdk
    public static class SessionTokenRefreshRequest
    extends BmcRequest<SessionTokenRequest> {
        private String token;

        SessionTokenRefreshRequest(String token) {
            this.token = token;
        }

        @Override
        @InternalSdk
        public SessionTokenRequest getBody$() {
            return new SessionTokenRequest(this.token);
        }

        @InternalSdk
        public static class SessionTokenRequest {
            public String currentToken;

            public SessionTokenRequest(String token) {
                this.currentToken = token;
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class SessionToken {
        @JsonProperty(value="currentToken")
        private String currentToken;

        public SessionToken(String token) {
            this.currentToken = token;
        }

        @JsonValue
        public String getToken() {
            return this.currentToken;
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            String token;

            public Builder token(String token) {
                this.token = token;
                return this;
            }

            public SessionToken build() {
                return new SessionToken(this.token);
            }
        }
    }
}

