/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.util.internal.Validate;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedContentResourcePrincipalFederationClient
implements FederationClient,
ProvidesConfigurableRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(FixedContentResourcePrincipalFederationClient.class);
    private final SessionKeySupplier sessionKeySupplier;
    private final SecurityTokenAdapter securityTokenAdapter;

    public FixedContentResourcePrincipalFederationClient(String resourcePrincipalSessionToken, SessionKeySupplier sessionKeySupplier) {
        this.sessionKeySupplier = Validate.notNull(sessionKeySupplier, "sessionKeySupplier must not be null", new Object[0]);
        this.securityTokenAdapter = new SecurityTokenAdapter(resourcePrincipalSessionToken, sessionKeySupplier);
    }

    @Override
    public String getSecurityToken() {
        return this.securityTokenAdapter.getSecurityToken();
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.securityTokenAdapter.getSecurityToken();
    }

    @Override
    public String getStringClaim(String key) {
        return this.securityTokenAdapter.getStringClaim(key);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time, boolean refreshKeys) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), refreshKeys);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck, Optional<Duration> time, boolean refreshKeys) {
        FixedContentResourcePrincipalFederationClient fixedContentResourcePrincipalFederationClient = this;
        synchronized (fixedContentResourcePrincipalFederationClient) {
            if (!doFinalTokenValidityCheck || (time.isPresent() ? !this.securityTokenAdapter.isValid(time) : !this.securityTokenAdapter.isValid())) {
                LOG.info("Refreshing session keys.");
                if (refreshKeys) {
                    this.sessionKeySupplier.refreshKeys();
                }
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }
}

